# Turbo-Make / UNIX Makefile for PVRAY Quantizer by F van der Hulst

# Turbo C stuff

# CC     =c:\tc\tcc
# OBJ    =obj
# LINK   =c:\tc\tlink
# CFLAGS =-mc -1 -a -K -G -O -Z -d -c -k- -N- -v- -p -C -Ic:\tc\include -w
# LFLAGS = @link.oct

# Following are for SCO Unix:
# CC     = cc
# LINK   = cc
# OBJ    = o
# CFLAGS = -c -M3 -J -Ox
# LFLAGS = -o ../bin/octree -Ox -lm

# Following are for GNU:
CC     = gcc
LINK   = gcc
OBJ    = o
CFLAGS = -ansi -c -O -I/usr/lib/gcc-include -Dsparc
LFLAGS = -o ../bin/octree /usr/lib/libm.a

# Implicit rules for making an object file from a .C file...
#
.c.$(OBJ) :
	$(CC) $(CFLAGS) $*.c

OBJS = quant.$(OBJ) files.$(OBJ) egif_lib.$(OBJ) gif_hash.$(OBJ) octree.$(OBJ)

../bin/octree.exe : $(OBJS)
	$(LINK) $(OBJS) $(LFLAGS)

quant.$(OBJ)    : quant.c quant.h heckbert.h

egif_lib.$(OBJ) : egif_lib.c quant.h gif_hash.h

gif_hash.$(OBJ) : gif_hash.c gif_hash.h

files.$(OBJ)    : files.c quant.h

octree.$(OBJ) : octree.c quant.h
