/* $Id: sunview.c,v 1.16 90/05/09 22:11:44 pturner Exp Locker: pturner $
 *
 * driver for sunview
 *
 */

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <pixrect/pixrect.h>
#include <pixrect/pixrect_hs.h>
#include <pixrect/pr_line.h>
#include "externs.h"

double devtoworldx(), devtoworldy();

#define MINCOLOR 0
#define MAXCOLOR 9

static int sviewcolor = 1;
static int sviewdmode;
static int sviewfont = 0;
static int sviewlinestyle = 1;

extern double devcharsize;
extern double charsize;

/*
 * the following is a tunable parameter and may
 * need to be adjusted
 */
#ifdef HIRES
double sviewcharsize = 0.80;

#else
double sviewcharsize = 0.60;

#endif

double xconv(), yconv();

void drawsview();

int win_h, win_w;

static Pr_brush b = {1};
static short int mypat1[2] = {1, 0};
static short int mypat2[3] = {2, 10, 0};
static short int mypat3[3] = {10, 10, 0};
static short int mypat4[3] = {15, 15, 0};
static short int mypat5[5] = {5, 2, 15, 2, 0};
static short int mypat6[3] = {20, 20, 0};
static short int mypat7[3] = {25, 25, 0};
static short int *patterns[] = {mypat1, mypat2, mypat3, mypat4, mypat5, mypat6, mypat7};
static Pr_texture tex;

#define PIX_XOR PIX_SRC^PIX_DST

extern Canvas canvas;
extern Pixwin *pw;

static void sunviewinit()
{
    win_h = (int) window_get(canvas, CANVAS_HEIGHT);
    win_w = (int) window_get(canvas, CANVAS_WIDTH);
    pw_writebackground(pw, 0, 0, win_w, win_h, 0);
}

void putstrsview(x, y, s)
    int x, y;
    char *s;
{
}

static int sview_write_mode = PIX_SET;

void set_write_mode(m)
    int m;
{
    sview_write_mode = m;
}

void sviewsetmode(mode)
    int mode;
{
    switch (mode) {
    case 1:
	sunviewinit();
	break;
    case 2:
	break;
    }
}

/*
 * fix for dotted/dashed linestyles
 */
#define MAXL 1024
static int npending;
static struct pr_pos polypoints[MAXL];

static void flush_pending()
{
    int i;

    if (sviewcolor == 1 && sviewlinestyle == 1) {
	for (i = 0; i < npending - 1; i++) {
	    pw_vector(pw, polypoints[i].x, polypoints[i].y, polypoints[i + 1].x, polypoints[i + 1].y, sview_write_mode, 1);
	}
    } else {
	pw_polyline(pw, 0, 0, npending, polypoints, POLY_DONTCLOSE, &b, &tex, sview_write_mode);
    }
    npending = 0;
}

static int x1, y1;

void drawsview(x, y, mode)
    int x, y, mode;
{
    if (mode) {
	polypoints[npending].x = x;
	polypoints[npending].y = win_h - y;
	npending++;
	if (npending == MAXL) {
	    flush_pending();
	}
    } else {
	if ((x == x1 && y == y1)) {
	    return;
	} else {
	    flush_pending();
	    polypoints[npending].x = x;
	    polypoints[npending].y = win_h - y;
	    npending++;
	}
    }
    x1 = x;
    y1 = y;
}

int xconvsview(x)
    double x;
{
    return ((int) (win_w * xconv(x)));
}

int yconvsview(y)
    double y;
{
    return ((int) (win_h * yconv(y)));
}

void sviewsetfont(n)
    int n;
{
    flush_pending();
    hselectfont(sviewfont = n);
}

int sviewsetcolor(c)
    int c;
{
    flush_pending();
    if (c) {
	c = c % MAXCOLOR;
    }
    b.width = c;
    sviewcolor = c;

    return c;
}

void sviewdrawtic(x, y, dir, updown)
    int x, y, dir, updown;
{
    switch (dir) {
    case 0:
	switch (updown) {
	case 0:
	    drawsview(x, y, 0);
	    drawsview(x, y + devxticl, 1);
	    break;
	case 1:
	    drawsview(x, y, 0);
	    drawsview(x, y - devxticl, 1);
	    break;
	}
	break;
    case 1:
	switch (updown) {
	case 0:
	    drawsview(x, y, 0);
	    drawsview(x + devyticl, y, 1);
	    break;
	case 1:
	    drawsview(x, y, 0);
	    drawsview(x - devyticl, y, 1);
	    break;
	}
	break;
    }
}

void dispstrsview(x, y, rot, s)
    int x, y, rot;
    char *s;
{
    flush_pending();
    puthersh(x, y, sviewcharsize * charsize, rot, sviewcolor, drawsview, s);
}

int sviewsetlinestyle(style)
    int style;
{
    flush_pending();
    if (style)
	tex.pattern = patterns[style - 1];	/* Which pattern to use */
    return (sviewlinestyle = style);
}

/*

TODO - experimenting with barcharts

setpattern(k)
    int k;
{
    switch (k) {
    case 1:
	curpat = pattern11_pr;
	break;
    case 2:
	curpat = pattern10_pr;
	break;
    case 3:
	curpat = pattern9_pr;
	break;
    case 4:
	curpat = pattern8_pr;
	break;
    case 5:
	curpat = pattern7_pr;
	break;
    case 6:
	curpat = pattern6_pr;
	break;
    case 7:
	curpat = pattern5_pr;
	break;
    case 8:
	curpat = pattern4_pr;
	break;
    case 9:
	curpat = pattern3_pr;
	break;
    case 10:
	curpat = pattern2_pr;
	break;
    case 11:
	curpat = pattern1_pr;
	break;
    default:
	curpat = pattern11_pr;
	break;
    }
}

fillpattern(n, px, py)
    int n;
    double px[], py[];

{
    Pixrect *pr;
    int npts[1], i;
    static struct pr_pos vlist0[50];

    npts[0] = n;
    for (i = 0; i < n; i++) {
	get_device(px[i], py[i],&(vlist0[i].x), &(vlist0[i].y));
    }
    pw_polygon_2(pw, 0, 0, 1, npts, vlist0, PIX_SRC, curpat, 0, 0);
}
*/

void sviewleavegraphics()
{
    flush_pending();
    sviewsetmode(2);
}

void sviewinitgraphics(dmode)
{
    npending = 0;
    x1 = 99999;
    y1 = 99999;
    sviewdmode = dmode;
    sviewsetmode(1);
    devconvx = xconvsview;
    devconvy = yconvsview;
    vector = drawsview;
    devwritestr = dispstrsview;
    devsetcolor = sviewsetcolor;
    devsetfont = sviewsetfont;
    devsetline = sviewsetlinestyle;
    devdrawtic = sviewdrawtic;
    devleavegraphics = sviewleavegraphics;
#ifdef HIRES
    devxticl = 15;
    devyticl = 15;
    devarrowlength = 15;
#else
    devxticl = 12;
    devyticl = 12;
    devarrowlength = 12;
#endif
    devcharsize = sviewcharsize;
    sviewsetcolor(1);
    sviewsetlinestyle(1);
}
