/*****
 *
 * File: cm_cell.h
 *   By: Dave Hiebeler
 *       August 1989
 *
 * Header file for most of the CM Cellsim files
 *
 *****/

/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/


/*****
 *
 * Includes, typedefs
 *
 *****/

#include <stdio.h>
#include <math.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <cm/paris.h>
#include <cm/cmfb.h>
#include "cm_cellproto.h"
#include "sock_rtns.h"

typedef unsigned char byte;
typedef void ((*void_func_ptr)());
typedef byte ((*func_ptr)());



/*****
 *
 * Global vars
 *
 *****/

int
    B, L, S, N, R, TSIZE, AMASK, nhood,
    array_size, function, parm1, parm2,
    phase, SOCKET_INUSE,
    CM_disp_interval, use_FB, use_Sun_disp, CM_delay, forever_flag,debug2;

unsigned int
    max_index;	/* max index into LT shared-array on CM */

int ns, debug;	/* socket fd and debug-level */

FILE *logfile;

unsigned char
    *grid, *table,	/* array and table on CMFE */
    red[256], green[256], blue[256];	/* for making cmap */


void_func_ptr
    initialization_function;

func_ptr
    update_function, exit_function;

int (*auto_step)();
void (*probe_func)();


/*****
 *
 * Some defines
 *
 *****/

/*** neighborhood types ***/
#define NH_VONN		1
#define NH_MOORE	2
#define NH_MARG		4
#define NH_LIN		8

/*** Handy definitions for doing NEWS operations on CM ***/
#define North 1, CM_downward
#define South 1, CM_upward
#define East 0, CM_upward
#define West 0, CM_downward

/*** Definitions for getting single NEWS coordinates ***/
#define VERTICAL 1
#define HORIZONTAL 0


/*****
 *
 * Various CM-related variables
 *
 *****/

/* Various fields used (probably not all of these are necessary;
 * the code hasn't been very optimized for memory-usage yet).
 */
CM_field_id_t
    cell, temp_value, trans, nbor_values, table_index, one,
    bottom, not_bottom,
    tmp_north, tmp_south, tmp_east,
    tmp_west, tmp_nw, tmp_sw, tmp_ne, tmp_se,
    VNorth, VSouth, VEast, VWest, VCenter,
    MNorth, MSouth, MEast, MWest, MCenter, MNW, MSW, MNE, MSE,
    LR1_L, LR1_C, LR1_R,
    LR2_LL, LR2_L, LR2_C, LR2_R, LR2_RR,
    LR3_LLL, LR3_LL, LR3_L, LR3_C, LR3_R, LR3_RR, LR3_RRR,
    MargCcw, MargOpp, MargCw, MargCenter, MargPhase,
    UL, UR, LR, LL, rand_num;

/*** Misc stuff ***/
unsigned int geo_array[31];
CM_vp_set_id_t vp_set;
CM_geometry_id_t geo;

struct CMFB_display_id disp_id;
CMFB_display_id_t FB_attach_ret_val;


/*** Offsets into the word that holds the neighors of each cell ***/
#define V_W_OFF 4
#define V_C_OFF 3
#define V_E_OFF 2
#define V_N_OFF 1
#define V_S_OFF 0

#define M_NW_OFF 8
#define M_W_OFF 7
#define M_SW_OFF 6
#define M_N_OFF 5
#define M_C_OFF 4
#define M_S_OFF 3
#define M_NE_OFF 2
#define M_E_OFF 1
#define M_SE_OFF 0

#define MARG_C_OFF 4
#define MARG_CCW_OFF 3
#define MARG_OPP_OFF 2
#define MARG_CW_OFF 1
#define MARG_PHASE_OFF 0

#define LR1_L_OFF 2
#define LR1_C_OFF 1
#define LR1_R_OFF 0

#define LR2_LL_OFF 4
#define LR2_L_OFF 3
#define LR2_C_OFF 2
#define LR2_R_OFF 1
#define LR2_RR_OFF 0

#define LR3_LLL_OFF 6
#define LR3_LL_OFF 5
#define LR3_L_OFF 4
#define LR3_C_OFF 3
#define LR3_R_OFF 2
#define LR3_RR_OFF 1
#define LR3_RRR_OFF 0


/*** macros to look up neighbors ***/
/* Von-N */
#define VGetNorth CM_get_from_news_1L(VNorth,cell,North,L)
#define VGetSouth CM_get_from_news_1L(VSouth,cell,South,L)
#define VGetEast  CM_get_from_news_1L(VEast,cell,East,L)
#define VGetWest  CM_get_from_news_1L(VWest,cell,West,L)
#define VGetCenter CM_u_move_1L(VCenter,cell,L);

/* Linear, radius=1 */
#define LR1GetL CM_get_from_news_1L(LR1_L, cell, West, L)
#define LR1GetC CM_u_move_1L(LR1_C, cell, L)
#define LR1GetR CM_get_from_news_1L(LR1_R, cell, East, L)

/* Linear, radius=2 */
#define LR2GetL CM_get_from_news_1L(LR2_L, cell, West, L)
#define LR2GetC CM_u_move_1L(LR2_C, cell, L)
#define LR2GetR CM_get_from_news_1L(LR2_R, cell, East, L)
/* After calling above macros, then the following 2 will work */
#define LR2GetLL CM_get_from_news_1L(LR2_LL, LR2_L, West, L);
#define LR2GetRR CM_get_from_news_1L(LR2_RR, LR2_R, East, L);

/* Linear, radius=3 */
#define LR3GetL CM_get_from_news_1L(LR3_L, cell, West, L)
#define LR3GetC CM_u_move_1L(LR3_C, cell, L)
#define LR3GetR CM_get_from_news_1L(LR3_R, cell, East, L)
/* After calling above macros, then the following 2 will work */
#define LR3GetLL CM_get_from_news_1L(LR3_LL, LR3_L, West, L);
#define LR3GetRR CM_get_from_news_1L(LR3_RR, LR3_R, East, L);
/* After calling the above, these last 2 will work */
#define LR3GetLLL CM_get_from_news_1L(LR3_LLL, LR3_LL, West, L);
#define LR3GetRRR CM_get_from_news_1L(LR3_RRR, LR3_RR, East, L);

/* Moore */
#define MGetCenter CM_u_move_1L(MCenter,cell,L);
#define MGetNorth CM_get_from_news_1L(MNorth,cell,North,L)
#define MGetSouth CM_get_from_news_1L(MSouth,cell,South,L)
#define MGetEast  CM_get_from_news_1L(MEast,cell,East,L)
#define MGetWest  CM_get_from_news_1L(MWest,cell,West,L)
/* Note -- before you can use the following 4 macros, you must
 * have called the above 4 macros!
 */
#define MGetNW    CM_get_from_news_1L(MNW,MNorth,West,L);
#define MGetSW    CM_get_from_news_1L(MSW,MSouth,West,L);
#define MGetNE    CM_get_from_news_1L(MNE,MNorth,East,L);
#define MGetSE    CM_get_from_news_1L(MSE,MSouth,East,L);

/* Note that looking up Margolus nbors is a bit more tricky,
 * so that is implemented as a function instead of macros.
 */

