/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/server/RCS/cdb_list.c,v $
 *
 *
 *  MODULE NAME:    cdb_list.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <string.h>
#include "BigNum.h"
#include "BigRSA.h"
#include "cdc.h"
#include "cdc_db.h"

extern int optind, opterr;
extern char *optarg;

int cdc_debug = 0;
char   *progname, *rindex();

main(argc, argv)
int argc;
char   *argv[];
{
    char    *cp;
    int     more, i, vflag = 0, dflag = 0, errflg = 0, c;
    char *database;
    char contents[PRIVATE_KEY_SIZE];
    char key[MAX_CDB_KEY_SZ];
    int  len, type;
    
    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;

    opterr = 0;
    while ((c=getopt(argc, argv, "vd:")) != EOF)
      switch(c) {
        case 'v' :
	  vflag = 1;
	  break;
	case 'd' :
	  dflag = 1;
	  database = optarg;
	  break;
	case '?' :
	  errflg++;
	}
    
    if (errflg) {
      fprintf(stderr, "Usage: %s [-v] [-d database-name]\n", progname);
      exit(1);
    }
    if (dflag == 0)  database = DBM_FILE;

    if (cdc_db_set_name(database) != 0)  {
      printf("cdc database '%s' doesn't exist\n", database);
      exit(-1);
    }

    more = 0;
    printf("List the master CDC database %s :\n\n", ((vflag==0)?"keys":"keys and contents"));
    bzero(contents, PRIVATE_KEY_SIZE);
    bzero(key, MAX_CDB_KEY_SZ);
    cdb_read_contents(&more, key, contents, &len, &type);
    if (type == FLAG_ATTRIB) {
       printf("  %s", key);
       if (vflag)
	 printf("\t%s", contents);
    } else {
       printf("  %s\t", key);
       if (vflag) {
	 for (i=0; i< len; i++) printf("%02x",(unsigned char) contents[i]);
       }
    }
    printf("\n");
    while (more != 0) {
      bzero(contents, PRIVATE_KEY_SIZE);
      bzero(key, MAX_CDB_KEY_SZ);
      cdb_read_contents(&more, key, contents, &len, &type);
      if (type == FLAG_ATTRIB) {
	printf("  %s", key);
	if (vflag)
	  printf("\t%s", contents);
      } else {
	printf("  %s\t", key);
	if (vflag) {
	  for (i=0; i< len; i++) printf("%02x",(unsigned char) contents[i]);
	}
      }
      printf("\n");
    }
    printf("\n");
    exit(0);
}
