/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cfile/RCS/in_tkt.c,v $
 *
 *
 *  MODULE NAME:    in_tkt.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <cdc.h>
#include <cdc_db.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>

extern int cdc_debug;

/*
 * in_tkt() is used to initialize the ticket store.  It creates the
 * file to contain the tickets and writes the given user's name "pname"
 * in the file.  in_tkt() returns ASUCCESS on success, or AFAILURE if
 * something goes wrong.
 */

int spx_in_tkt(myname, pname, id)
    char *myname, *pname, *id;
{
    int tktfile, creat();
    short me, getuid();
    struct stat buf;
    int count;
    char *file;
    int fd;
    register int i;
    char charbuf[BUFSIZ];

    me = getuid ();
    file = (char *) spx_tkt_string(myname, id);
    if (lstat(file,&buf) == 0) {
        if (me != 0) {
	  if (buf.st_uid != me || !(buf.st_mode & S_IFREG) ||
	      buf.st_mode & 077) {
	    if (cdc_debug)
	      fprintf(stderr,"Error initializing %s",file);
	    return(AFAILURE);
	  }
	}
	/* file already exists, and permissions appear ok, so nuke it */
	if ((fd = open(file, O_RDWR, 0)) < 0)
	    goto out; /* can't zero it, but we can still try truncating it */

	bzero(charbuf, sizeof(charbuf));

	for (i = 0; i < buf.st_size; i += sizeof(charbuf))
	    if (write(fd, charbuf, sizeof(charbuf)) != sizeof(charbuf)) {
		(void) fsync(fd);
		(void) close(fd);
		goto out;
	    }
	
	(void) fsync(fd);
	(void) close(fd);
    }
 out:
    if ((tktfile = creat(file,0600)) < 0) {
	if (cdc_debug)  /*  cdc_debug  */
	    fprintf(stderr,"Error initializing %s",spx_tkt_string(pname, id));
        return(AFAILURE);
    }
    if (lstat(file,&buf) < 0) {
	if (cdc_debug)
	    fprintf(stderr,"Error initializing %s",spx_tkt_string(pname, id));

        return(AFAILURE);
    }
    if (me != 0) {
      if (buf.st_uid != me || !(buf.st_mode & S_IFREG) ||
	  buf.st_mode & 077) {
	if (cdc_debug)
	  fprintf(stderr,"Error initializing %s",spx_tkt_string(pname, id));
        return(AFAILURE);
      }
    }
    count = strlen(pname);
    if (write(tktfile,pname,count) != count) {
        (void) close(tktfile);
        return(AFAILURE);
    }
    write(tktfile,"; ",2);

    (void) close(tktfile);
    return(ASUCCESS);
}
