SPHINX DEFINITIONS ::=

BEGIN

AttributeType ::= OBJECT IDENTIFIER
AttributeValue ::= CaseIgnoreString 
CaseIgnoreString ::= CHOICE {   
        t61     T61String (SIZE (1..64)),
        string  PrintableString (SIZE(1..64))
        }

AttributeValueAssertion ::= SEQUENCE {
        type    AttributeType, 
        value   AttributeValue
        }
RDN ::= SET OF AttributeValueAssertion
DistinguishedName ::= SEQUENCE OF RDN
Name ::= DistinguishedName


joint-iso-ccitt  OBJECT IDENTIFIER ::= {2}
iso OBJECT IDENTIFIER ::= {1}
identified-organization OBJECT IDENTIFIER ::= {iso 3}
ecma OBJECT IDENTIFIER ::= {identified-organization 12} -- ECMA
member-company OBJECT IDENTIFIER ::= {ecma 2}

-- the following are defined in ISO 9594/X.500

ds OBJECT IDENTIFIER ::= {joint-iso-ccitt 5}
algorithm OBJECT IDENTIFIER ::= {ds 8}

encryptionAlgorithm OBJECT IDENTIFIER ::= {algorithm 1}  -- From Annex H of X.509
hashAlgorithm       OBJECT IDENTIFIER ::= {algorithm 2}  -- From Annex H of X.509
signatureAlgorithm  OBJECT IDENTIFIER ::= {algorithm 3}  -- From Annex H of X.509
rsa                 OBJECT IDENTIFIER ::= {encryptionAlgorithm 1}
                               -- parmeter is INTEGER keysize

-- this definition is from Bert Kaliski's email message and has no official status

rsaMD2withRSA       OBJECT IDENTIFIER ::= {signatureAlgorithm 2}  -- RSADSI specifid
                               -- parmeter is INTEGER keysize

-- the following are from the 1989 OSI Implementors Workshop "Stable" Agreements

oiw OBJECT IDENTIFIER ::= {identified-organization 14} -- implementor's workshop
dssig OBJECT IDENTIFIER ::= {oiw 7}
oiwAlgorithm OBJECT IDENTIFIER ::= {dssig 2}

oiwEncryptionAlgorithm OBJECT IDENTIFIER ::= {oiwAlgorithm 1}
oiwHashAlgorithm OBJECT IDENTIFIER ::= {oiwAlgorithm 2}
oiwSignatureAlgorithm OBJECT IDENTIFIER ::= {oiwAlgorithm 3}
 
oiwMD2 OBJECT IDENTIFIER ::= { oiwHashAlgorithm 1}  -- null parameter
oiwMD2withRSA  OBJECT IDENTIFIER ::= {oiwSignatureAlgorithm 1}  -- null parameter
 
-- the following are defined for our purposes

dec OBJECT IDENTIFIER ::= { member-company 1011 } -- Digital Equipment Corporation
cryptoAlgorithm OBJECT IDENTIFIER ::= {dec 7} 

decEncryptionAlgorithm OBJECT IDENTIFIER ::= {cryptoAlgorithm 1}
decHashAlgorithm OBJECT IDENTIFIER ::= {cryptoAlgorithm 2}
decSignatureAlgorithm OBJECT IDENTIFIER ::= {cryptoAlgorithm 3}

decMD2withRSA   OBJECT IDENTIFIER ::= { decSignatureAlgorithm 1 }
                        -- parameter is UID, OPTIONAL
decMD4withRSA   OBJECT IDENTIFIER ::= { decSignatureAlgorithm 2 }
                        -- parameter is UID, OPTIONAL
decDEAMAC       OBJECT IDENTIFIER ::= { decSignatureAlgorithm 3 }

decDEA	        OBJECT IDENTIFIER ::= { decEncryptionAlgorithm 2 }

decMD2	        OBJECT IDENTIFIER ::= { decHashAlgorithm 1 }
decMD4	        OBJECT IDENTIFIER ::= { decHashAlgorithm 2 }

-- the following are from 9594-8

Version ::= INTEGER { v1988(0), v1992(1) }
CertificateSerialNumber ::= INTEGER

ShortPosixTime ::= INTEGER

LongPosixTime ::= SEQUENCE {
	seconds		INTEGER,  -- seconds since January 1, 1970, GMT
	nanoseconds	INTEGER   -- additional precision, in nanoseconds
        }

Validity ::=	SEQUENCE {
	notBefore	UTCTime,
	notAfter	UTCTime 
        }

ShortPosixValidity ::= SEQUENCE {
	notBefore	ShortPosixTime,
	notAfter	ShortPosixTime 
        }

UID ::= BIT STRING

AlgorithmIdentifier ::= SEQUENCE {
	algorithm	OBJECT IDENTIFIER ,
        parameter       CHOICE{
                keySize         INTEGER,
                null            NULL } OPTIONAL
        }

SubjectPublicKeyInfo  ::=  SEQUENCE {
	algorithm		AlgorithmIdentifier ,
                            -- of the signature type which this key verifies
                            -- normally, oiwMD2withRSA (1.3.14.7.2.3.1)
                            -- could be decMD2withRSA  (1.3.12.2.1011.7.3.1)
                            -- might be decMD2withRSA (2.5.8.3.2), unlikely
                            -- however, could be the encryption type which this
                            -- key encrypts, which would be "rsa " (2.5.8.1.1)
	subjectPublicKey	BIT STRING 
                            -- the "bits" further decode into a DEC public key
	}

Certificate ::= SEQUENCE {		-- SIGNED CertifInfo
	cinfo                   CertifInfo ,
	algorithm               AlgorithmIdentifier ,
	signature		BIT STRING
        }
        
CertifInfo ::=  SEQUENCE {
        version [0]             Version DEFAULT v1988 ,
        serialNumber            CertificateSerialNumber ,
        signature               AlgorithmIdentifier ,
        issuer                  Name,
        valid                   Validity,
        subject                 Name,
        subjectPublicKey        SubjectPublicKeyInfo ,
        issuerUID [1]           IMPLICIT UID OPTIONAL ,  -- v1992
        subjectUID [2]          IMPLICIT UID OPTIONAL    -- v1992
        }

DECPublicKey ::= SEQUENCE {
	modulus		        INTEGER,
	exponent	        INTEGER 
        }

DECPrivateKey ::= SEQUENCE {
	p		INTEGER,   -- prime p
	q   [0]		IMPLICIT INTEGER OPTIONAL,  -- prime q
	mod [1]		IMPLICIT INTEGER OPTIONAL,  -- modulus
	exp [2]		IMPLICIT INTEGER OPTIONAL,  -- public exponent
	dp  [3]         IMPLICIT INTEGER OPTIONAL,  -- exponent mod p
	dq  [4]         IMPLICIT INTEGER OPTIONAL,  -- exponent mod q
	cr  [5]		IMPLICIT INTEGER OPTIONAL
					-- chinese remainder coefficient
					-- for CRL routines
	}

LocalUserName	::= OCTET STRING        -- Should this be "printable string"?
ChannelId	::= OCTET STRING
VersionNumber   ::= OCTET STRING (SIZE(3))
			-- first octet is major version
			-- second octet is minor version
			-- third octet is ECO rev.

versionZero	VersionNumber ::= '000000'H

AuthenticationToken ::= SEQUENCE {
	version [0]		IMPLICIT VersionNumber DEFAULT versionZero ,
	authenticator [1]       IMPLICIT Authenticator ,
        encryptedkey [2]        IMPLICIT EncryptedKey OPTIONAL ,
                                  -- required if initiating token
	userclaimant [3]        IMPLICIT UserClaimant OPTIONAL ,
                                  -- required if not doing node authentication
                                  -- missing if only doing node authentication
        nodeclaimant [4]        IMPLICIT NodeClaimant OPTIONAL
                                  -- required if not doing user authentication
        }
        
Authenticator ::= SEQUENCE {           -- SIGNED AuthenticatorInfo
        authenticatorInfo       AuthenticatorInfo ,
        algorithm               AlgorithmIdentifier ,
                                    -- decDEAMAC (1.3.12.2.1011.7.3.3)
        signature		BIT STRING
                                    -- this is made using the DES MAC algorithm
	}

AuthenticatorInfo ::= SEQUENCE {
        type                    BIT STRING { delegationRequired(0),
                                             mutualRequested   (1) } ,
        whenSigned              LongPosixTime ,
        channelId  [3]          IMPLICIT ChannelId OPTIONAL
        }

EncryptedKey ::= SEQUENCE {
        algorithm	        AlgorithmIdentifier,
                            -- rsa encryption (2.5.8.1.1), parameter is keysize
        encryptedAuthKey	BIT STRING 
                            -- DES authenticating key in low order bytes
                            -- 'when signed' binary time in next four bytes
                            -- 'when expires' binary time in next four bytes
                            -- padded with random bytes, top byte is "40H" ,
                            -- encrypted using target public key and RSA
        }

UserClaimant ::= SEQUENCE {
        userTicket [0]          IMPLICIT LoginTicket ,
        evidence  		Evidence,
        userName [3]            IMPLICIT Name OPTIONAL
        }

LoginTicket ::= SEQUENCE {              -- SIGNED TicketInfo
	tktinfo		        TicketInfo ,
	algorithm               AlgorithmIdentifier , 
                                    -- oiwMD2withRSA (1.3.14.7.2.3.1)
        signature		BIT STRING
	}

TicketInfo ::= 	SEQUENCE {
	version	[0] 	        IMPLICIT VersionNumber
						DEFAULT versionZero ,
	validity 		ShortPosixValidity ,
	subjectUID		UID ,
	delegatingPublicKey	SubjectPublicKeyInfo
	}

Evidence ::= CHOICE {
		delegator [1]   IMPLICIT Delegator ,
                                -- present if delegating
                sharedKeyTicketSignature [2]
                                IMPLICIT SignatureData
                                -- sigature part of SharedKeyTicketInFull
                                -- present if not delegating
                }

Delegator ::= SEQUENCE {
        algorithm               AlgorithmIdentifier ,
				    -- decDEA encryption (1.3.12.2.1011.7.1.2)
				    -- Encrypted delegating private key
				    -- using DES algorithm
        encryptedPrivKey        BIT STRING
        }

SignatureData ::=  SEQUENCE {
	algorithm               AlgorithmIdentifier , 
        signatureBits           BIT STRING
        }

SharedKeyTicketInFull ::= SEQUENCE {
	encryptedkey		EncryptedKey,
	algorithm		AlgorithmIdentifier,
	signature		BIT STRING
	}

EncryptedKeyandTarget ::= SEQUENCE {
	deskey			OCTET STRING,
	validity		ShortPosixValidity,
	targetUID		UID,
	targetPublicKey		SubjectPublicKeyInfo
	}


NodeClaimant ::=  SEQUENCE {
        nodeTicketSignature [0] IMPLICIT NodeTicketSignature,
        nodeName [1]            IMPLICIT Name OPTIONAL ,
        userName [2]            IMPLICIT LocalUserName OPTIONAL
        }

NodeTicketSignature ::= SEQUENCE {
	algorithm               AlgorithmIdentifier , 
                                -- oiwMD2withRSA (1.3.14.7.2.3.1)
                                -- Signature bits computed over 
                                -- EncryptedKeyandUserName structure
                                -- using node private key
        signedEncryptedKey      BIT STRING
                                -- Signature bits computed over Encrypted Key structure
        }

EncryptedKeyandUserName ::= SEQUENCE {
        encryptedKey            EncryptedKey ,
        username                LocalUserName
        }
        
MutualResponseToken ::= CHOICE {
                        v1Response [0] IMPLICIT OCTET STRING (SIZE (1..6))
                        }
                            -- others to be defined in future versions
                            -- first six bytes of MAC computed using 
                            -- the authenticating key, consisting of fields
                            -- made from the authenticator time stamp value.
                            -- first four octets are "seconds" integer
                            -- next four octets are "nanoseconds" integer,
                            -- most significant octet first.
                            -- equivalent to ECB encryption and 
                            -- then discarding last 2 bytes

CDCAPDU ::= CHOICE {
		errorResponse         [1]  IMPLICIT ErrorResponse ,
		readPrinLoginRequest  [2]  IMPLICIT ReadPrinLoginRequest ,
		readPrinLoginResponse [3]  IMPLICIT ReadPrinLoginResponse ,
                readPrinCertRequest   [4]  IMPLICIT ReadPrinCertRequest ,
                readPrinCertResponse  [5]  IMPLICIT ReadPrinCertResponse ,
                readTACertRequest     [6]  IMPLICIT ReadTACertRequest ,
                readTACertResponse    [7]  IMPLICIT ReadTACertResponse }

CDCStatus ::= INTEGER { success(0) ,
                        accessDenied(1) ,
                        unrecognizedDomain(2) ,
                        unrecognizedCA(3) ,
                        unrecognizedPrincipal(4) ,
			decodeRequestError(5) ,
			illegalRequest(6) ,
			unknownObject(7) ,
			illegalAttribute(8)
              }

ListOfNames ::= SEQUENCE OF Name

ReadPrinLoginRequest ::= SEQUENCE {
                flags [0]     BIT STRING DEFAULT {},  -- none defined for now
                principal     Name ,
		logindata [2] BIT STRING DEFAULT {}
        }

ReadPrinCertRequest ::= SEQUENCE {
                flags [0]       BIT STRING DEFAULT {},  -- none defined for now
		index [1]       IMPLICIT INTEGER DEFAULT 0,
		resolveFrom [2] Name OPTIONAL,
                principal       Name ,
                crossDomains    ListOfNames OPTIONAL
                                        -- the first one wins
        }

ReadTACertRequest ::= SEQUENCE {
                flags [0]     BIT STRING DEFAULT {},  -- none defined for now
		index [1]     IMPLICIT INTEGER DEFAULT 0,
                principal     Name
        }

ErrorResponse ::= CDCStatus

ReadPrinLoginResponse ::= SEQUENCE {
                status [0]       IMPLICIT CDCStatus DEFAULT success ,
                loginInfo        BIT STRING
        }

CertPath ::= SEQUENCE OF Certificate

ReadPrinCertResponse ::= SEQUENCE {
                status [0]       IMPLICIT CDCStatus DEFAULT success ,
                index [1]        INTEGER OPTIONAL ,
		resolveTo [2]    Name OPTIONAL ,
                certPath [3]     IMPLICIT CertPath
                                        -- for principal certificate read,
                                        --   first comes domain  (if one),
                                        --   next is CA  (if one),
                                        --   next is principal.
        }

ReadTACertResponse ::= SEQUENCE {
                status [0]       IMPLICIT CDCStatus DEFAULT success ,
                index [1]        INTEGER OPTIONAL ,
                certPath [2]     IMPLICIT CertPath
					-- for ta certificate read,
					--   first comes most specific,
					--   next are general cross-certifiers.
        }

END
