/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/rdn_to_str.c,v $
 *
 *
 *  MODULE NAME:    rdn_to_string.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"

unsigned char buffer[500];
int encode_SPHINX_Name();


char *oid_to_abbrev(atype)
char *atype;
{
    static char ts[20];

    if (strcmp(atype,"2.5.4.6")==0) {
	strcpy(ts,"C");
	goto finished;
    }
    if (strcmp(atype,"2.5.4.10")==0) {
	strcpy(ts,"O");
	goto finished;
    }
    if (strcmp(atype,"2.5.4.11")==0) {
	strcpy(ts,"OU");
	goto finished;
    }
    if (strcmp(atype,"2.5.4.3")==0) {
	strcpy(ts,"CN");
	goto finished;
    }
    if (strcmp(atype,"0.9.2342.19200300.100.1.25")==0) {
        strcpy(ts,"DC");
        goto finished;
    }
    strcpy(ts,atype);
finished:
    return(ts);
}

char *get_local_name(name)
struct type_SPHINX_Name *name;
{
  char *str_buf;
  struct type_SPHINX_RDN    *rdn;
  struct type_SPHINX_AttributeValueAssertion  *ava;

  str_buf = (char *) malloc(40);
  for (name; name; name = name->next) {
    rdn = name->RDN;
    for (rdn ; rdn ; rdn = rdn->next) {
      ava = rdn->AttributeValueAssertion;
      if (!rdn->next)  break;
    }
  }
  strcpy(str_buf, qb2str(ava->value->un.string));
  return(str_buf);
}

char *rdn_to_str(name)
struct type_SPHINX_Name *name;
{
  char *str_buf;
  struct type_SPHINX_RDN    *rdn;
  struct type_SPHINX_AttributeValueAssertion  *ava;

  str_buf = (char *) malloc(80);
  *str_buf = '\0';
  for (name; name; name = name->next) {
    rdn = name->RDN;
    strcat(str_buf,"/");
    for (rdn ; rdn ; rdn = rdn->next) {
	ava = rdn->AttributeValueAssertion;
	strcat(str_buf, oid_to_abbrev(sprintoid(ava->type)));
	strcat(str_buf, "=");
	strcat(str_buf,qb2str(ava->value->un.string));
	if (rdn->next)  strcat(str_buf,",");
      }
  }
  return(str_buf);
}

char *last_rdn_to_str(name)
struct type_SPHINX_Name *name;
{
  char *str_buf;
  struct type_SPHINX_RDN    *rdn;
  struct type_SPHINX_AttributeValueAssertion  *ava;

  str_buf = (char *) malloc(80);
  *str_buf = '\0';
  for (name; name; name = name->next) {
    rdn = name->RDN;
    if (name->next == NULL)
      for (rdn ; rdn ; rdn = rdn->next) {
	ava = rdn->AttributeValueAssertion;
	strcat(str_buf, oid_to_abbrev(sprintoid(ava->type)));
	strcat(str_buf, "=");
	strcat(str_buf,qb2str(ava->value->un.string));
	if (rdn->next)  strcat(str_buf,",");
      }
  }
  return(str_buf);
}
