(*  :Title:	Initialization for signal processing supporting objects  *)

(*  :Authors:	Brian Evans, James McClellan  *)

(*  :Summary:	This is an initialization file only  *)

(*  :Context:	Global`  *)

(*  :PackageVersion:  2.4	*)

(*
    :Copyright:	Copyright 1989, 1990 by
		the Digital Signal Processing Group
		at the Georgia Institute of Technology

	Permission to use, copy, modify, and distribute this software
	and its documentation for any purpose and without fee is
	hereby granted, provided that the above copyright notice
	appear in all copies and that both that copyright notice and
	this permission notice appear in supporting documentation,
	and that the name of Georgia Tech or Georgia Institute of
	Technology not be used in advertising or publicity pertaining
	to distribution of the software without specific, written prior
	permission.  Georgia Tech makes no representations about the
	suitability of this software for any purpose.  It is provided
	"as is" without express or implied warranty.
 *)

(*  :History:	*)

(*  :Keywords:	*)

(*  :Source:	*)

(*  :Warning:	*)

(*  :Mathematica Version:  1.2 or 2.0  *)

(*  :Limitation:  *)


(*  B E G I N     I N I T I A L I Z A T I O N  *)



Which[


(*  Check to make sure that these have not already been loaded  *)

MemberQ[ $ContextPath, "SignalProcessing`Support`" ],

  Print["Version 2.4 of the signal processing support packages has \
	already been loaded"],


(*  For Mathematica 2.0, we only define the stubs  *)

TrueQ[ $VersionNumber >= 2.0 ],

  Print["Defining stubs for objects in version 2.4 of the \
           signal processing support packages ..."];

  DeclarePackage[ "SignalProcessing`Support`Convolution`", { 
			"$ConvolutionDomain", "Area", "AutoCorrelation",
			"ConvertFromList", "ConvertToList",
			"CTPiecewiseConvolution", "DTPiecewiseConvolution",
			"IntervalQ", "PiecewiseConvolution", "PlotList",
			"SetConvolutionDomain", "SimplifyList",
			"ValidIntervalQ" } ];

  DeclarePackage[ "SignalProcessing`Support`DataType`", { 
			"AddDataType", "AllDataTypes", "AssociateDataType",
			"CombineDataType", "ComplexAntiSymmetric",
			"ComplexSymmetric", "DataType", "DataTypeQ",
			"DataTypes", "DefConstant", "FTDataType",
			"GetPosition", "Imaginary", "Irrational",
			"IrrationalQ", "IsComplexQ", "IsImaginaryQ",
			"IsIntegerQ", "IsIrrationalQ", "IsRationalQ",
			"IsRealQ", "SubDataTypeQ", "SymbolDataType",
			"SymbolDataTypeQ", "UnAssociateDataType" } ];

  DeclarePackage[ "SignalProcessing`Support`FilterSupport`", { 
			"Analog", "Bandpass", "Bandstop", "Bessel",
			"BilinearTransformation", "Butterworth", "CFIR",
			"CIIR", "ChebyshevI", "ChebyshevII", "DesignFilter",
			"Digital", "Elliptic", "FilterOrder",
			"FilterParameters", "FIR", "Highpass", "IIR",
			"IIRFunction", "Lowpass" } ];

  DeclarePackage[ "SignalProcessing`Support`Multirate`", { 
			"BezoutNumbers", "CommutableResamplingMatricesQ",
			"DistinctCosetVectors",
			"IntegerVectorQ", "NormalizeSamplingMatrix",
			"ResamplingMatrix", "ResamplingMatrixMod",
			"SmithNormalForm", "SmithFormSameU",
			"SmithFormSameV", "SmithOrderedForm",
			"SmithReducedForm" } ];

  DeclarePackage[ "SignalProcessing`Support`ROC`", { 
			"FindRMinus", "FindRPlus", "GetRMinus", "GetRPlus",
			"InfCheck", "IntersectsROC", "LTransData",
			"LVariables", "Rminus", "Rplus", "Transform",
			"WithinROC", "ZTransData", "ZVariables" } ];

  DeclarePackage[ "SignalProcessing`Support`SigProc`", { 
			"Aliasby", "CConvolve", "Convolve", "Continuous",
			"CPulse", "CStep", "Delta", "DeltaPlot", "Dialogue",
			"DFT", "DTFT", "Difference", "Dirichlet", "Discrete",
			"DiscreteGraphics", "Domain", "Downsample",
			"DummyVariables", "FT", "GetDeltaFunctions", "Impulse",
			"Interleave", "IntervalsToFunction", "InvDFT",
			"InvDTFT", "InvFT", "InvL", "InvZ", "L",
			"LineImpulse", "OperatorInOperExpr", "OperatorName",
			"ParametersInOperExpr", "Periodic",
			"PolyphaseDownsample", "PolyphaseUpsample",
			"Pulse", "RationalGCD", "Rev", "ScaleAxis",
			"ScalingFactor", "SequencePlot", "SequenceToFunction",
			"Shift", "SignalPlot", "SignalsInOperExpr",
			"Sinc", "Step", "Summation", "TheFunction",
			"ToContinuous", "ToDiscrete", "Unit", "Upsample",
			"UpsampledFunction", "UpsampleFactor",
			"UpsampleSequence", "Z", "AliasedSinc",
			"AliasSinc", "ASinc" } ];

  DeclarePackage[ "SignalProcessing`Support`SupCode`", { 
			"AllSubsets", "Arrow2D", "AssociateItem",
			"CirclePS", "Combine", "ComplexQ", "ComplexTo2DCoord",
			"ComplexTo2DCoordList", "ConstantQ",
			"ConstantTerm", "Element", "EmptyQ",
			"GenerateCode", "GeneratePattern", "GenerateSymbol",
			"GetAllExponents", "GetAllFactors",
			"GetOperatorVariables", "GetRoot", "GetRootList",
			"GetStateField", "GetVariables", "GetValue",
			"HasAttributes", "ImaginaryQ", "InRange",
			"IncList", "InfinityQ", "ListQ", "MixedPolynomialQ",
			"MyApart", "MyCollectAll", "MyFreeQ", "MyMessage",
			"MyTogether", "NegExponent", "NormalizedQ", "NullPlot",
			"PatternQ", "PointwisePlot", "PrintIt", "ProtectIt",
			"RationalQ", "RationalFunctionQ",
			"RationalPolynomialQ", "RealQ", "RealValuedQ",
			"ReplaceWith", "SameFormQ", "Second", "SetExclusion",
			"SetStateField", "SPLessGreaterRules",
			"SPSimplificationRules", "StripPackage",
			"SubsetQ", "TableLookup", "Third",
			"ToCollection", "ToList", "UnprotectIt",
			"VariableQ", "ZeroQ" } ];

  DeclarePackage[ "SignalProcessing`Support`TransSupport`", { 
			"AddT", "ConjT", "ConvolveT", "DerivativeT",
			"DomainScale", "InformUserQ", "IntegrateT",
			"Linear", "LineImpulsemDT", "MagRangeScale",
			"MagPhasePlot", "MultiDInvTransform",
			"MultiDTransform", "MultT", "PhaseRangeScale",
			"PoleZeroPlot", "Radian", "ROCPlot",
			"RootLocus", "ScaleT", "ShadedAnnulus", "Stable",
			"SubT", "SubstituteForT", "TransformFixUp",
			"TransformLookup", "MagnitudePhasePlot",
			"RootLocusPlot" } ];

  DeclarePackage[ "SignalProcessing`Support`Tree`", { 
			"AddChildToTree", "DeleteFromTree",
			"InitTree", "SubTree" } ];

  AppendTo[$ContextPath, "SignalProcessing`Support`"],


(*  Load necessary files in order of hierarchy, bottom up. *)

True, 

  Print["Loading version 2.4 of the signal processing support packages ..."];

  Needs[ "SignalProcessing`Support`SupCode`" ];		(* level a  *)

  Needs[ "SignalProcessing`Support`FilterSupport`" ];	(* level b  *)
  Needs[ "SignalProcessing`Support`SigProc`" ];

  Needs[ "SignalProcessing`Support`ROC`" ];		(* level c  *)
  Needs[ "SignalProcessing`Support`Convolution`" ];

  Needs[ "SignalProcessing`Support`TransSupport`" ];	(* level d  *)

  AppendTo[$ContextPath, "SignalProcessing`Support`"]

]

(*  Temporary messages  *)

support::error = "The current context should be Global` and it is not."
support::loaded =
	"Supporting routines, objects, and rules for the signal \
	processing package have been loaded successfully."
support::change =
	"The loading process has changed such that the files Tree.m and \
	DataType.m are no longer automatically loaded (the signal \
	processing packages no longer rely on the definitions in these files)."

(*  Error checking  *)

If [ SameQ[$Context, "Global`"],
     Message[ support::loaded ],
     Message[ support::error ] ]

If [ ! TrueQ[ $VersionNumber >= 2.0 ],
     Message[ support::change ] ]

(*  Remove temporary messages  *)

support::error = .
support::loaded = .
support::change = .


(*  E N D     I N I T I A L I Z A T I O N  *)

Null
