 /*
  * Khoros: $Id: iconimage.c,v 1.3 1992/03/20 22:50:43 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: iconimage.c,v 1.3 1992/03/20 22:50:43 dkhoros Exp $";
#endif

 /*
  * $Log: iconimage.c,v $
 * Revision 1.3  1992/03/20  22:50:43  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: iconimage.c
 >>>>
 >>>>      Program Name: iconimage
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This program displays an iconified version of an image.
 >>>>	
 >>>>	

 >>>>            Author: Mark Young and Stephanie Hallet
 >>>>
 >>>> Date Last Updated: Fri Feb 28 15:32:55 1992
 >>>>
 >>>>          Routines: main- the main program for iconimage
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "iconimage.h"


/****************************************************************
 *
 * Routine Name:  main program for iconimage
 *
 *       Input:  
 *           -i  input image filename 
 *
 *
 *           [-ov] overlay image filename
 *           [-s] input shape mask filename
 *           [-c] input clip mask filename
 *           [-x] x value of upper-left corner of icon  (-1 < value < 1000)
 *           [-y] y value of upper-left corner of icon  (-1 < value < 1000)
 *           [-w] width of icon image in pixels  (0 < value < 1000)
 *           [-h] height of icon image in pixels  (0 < value < 1000)
 *           [-update] update time  (value >= 0.0)
 *           [-display] host:display.screen
 *           [-use_cmap] use colormap?
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        float update = 0.0;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        consolidate_args();
/* -main_before_lib_call_end */

/* -main_library_call */
        if (iconimage->update_flag)
           update = iconimage->update;

        if (! liconimage(iconimage->i, iconimage->ov, iconimage->s,
                         iconimage->c, iconimage->x, iconimage->y, 
                         iconimage->w, iconimage->h, update,
                         iconimage->display, iconimage->use_cmap))
        {
            (void) fprintf(stderr, "liconimage Failed\\n");
             exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for iconimage 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "iconimage :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis program displays an iconified version of an image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-ov]  overlay image filename (infile) [null]\n");
	fprintf(stderr,"\t[-s]  input shape mask filename (infile) [null]\n");
	fprintf(stderr,"\t[-c]  input clip mask filename (infile) [null]\n");
	fprintf(stderr,"\t[-x]  x value of upper-left corner of icon (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-y]  y value of upper-left corner of icon (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-w]  width of icon image in pixels (integer, 0 to 1000) [64]\n");
	fprintf(stderr,"\t[-h]  height of icon image in pixels (integer, 0 to 1000) [64]\n");
	fprintf(stderr,"\t[-update]  update time (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-display]  host:display.screen (string) [null]\n");
	fprintf(stderr,"\t[-use_cmap]  use colormap? (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for iconimage\n");
	fprintf(stderr, "\t[-V] Gives the version for iconimage\n");
	fprintf(stderr, "\t[-U] Gives the usage for iconimage\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called iconimage.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses iconimage.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for iconimage
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*ov_pstr = 
	"\nEnter: (ov) overlay image filename \n        {infile}: "; 
char	*s_pstr = 
	"\nEnter: (s) input shape mask filename \n        {infile}: "; 
char	*c_pstr = 
	"\nEnter: (c) input clip mask filename \n        {infile}: "; 
char	*x_pstr = 
	"\nEnter: (x) x value of upper-left corner of icon \n        {integer, -1 to 1000 [-1] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y value of upper-left corner of icon \n        {integer, -1 to 1000 [-1] }: "; 
char	*w_pstr = 
	"\nEnter: (w) width of icon image in pixels \n        {integer, 0 to 1000 [64] }: "; 
char	*h_pstr = 
	"\nEnter: (h) height of icon image in pixels \n        {integer, 0 to 1000 [64] }: "; 
char	*update_pstr = 
	"\nEnter: (update) update time \n        {float, >= 0.0 [0.000000] }: "; 
char	*display_pstr = 
	"\nEnter: (display) host:display.screen \n        {string}: "; 
char	*display_def = NULL;
char	*use_cmap_pstr = 
	"\nEnter: (use_cmap) use colormap? \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "iconimage", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "iconimage.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "iconimage: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "iconimage.ans");
		}

	     }

	}

	/*
	 * allocate the iconimage structure
	 */
	iconimage = (iconimage_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (iconimage_struct));

	/*
	 * get required arguments for iconimage
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(iconimage->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(iconimage->i))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(iconimage->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    iconimage->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(iconimage->i))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for iconimage
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	iconimage->ov_flag = vget_infile(fid, prompt_flag,
	"-ov", ov_pstr, &(iconimage->ov))
;

	iconimage->s_flag = vget_infile(fid, prompt_flag,
	"-s", s_pstr, &(iconimage->s))
;

	iconimage->c_flag = vget_infile(fid, prompt_flag,
	"-c", c_pstr, &(iconimage->c))
;

	iconimage->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(iconimage->x),
	-1, -1, 1000);

	iconimage->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(iconimage->y),
	-1, -1, 1000);

	iconimage->w_flag = vget_int(fid, prompt_flag,
	"-w", w_pstr, &(iconimage->w),
	64, 0, 1000);

	iconimage->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(iconimage->h),
	64, 0, 1000);

	iconimage->update_flag = vget_float(fid, prompt_flag,
	"-update", update_pstr, &(iconimage->update),
	0.000000, 1.000000, 1.000000);

	iconimage->display_flag = vget_string(fid, prompt_flag,
	"-display", display_pstr, &(iconimage->display),
	display_def);

	if (prompt_flag == FALSE)
	{
	    if ((iconimage->display_flag == 1)&&(iconimage->display == NULL))
    	{
		fprintf(stderr, "iconimage:\n");
		fprintf(stderr, "you must specify a name following '-display'\n");
		gw_usage();
		exit(1);
		}
	}
	iconimage->use_cmap_flag = vget_logic(fid, prompt_flag,
	"-use_cmap", use_cmap_pstr, &(iconimage->use_cmap), 1);


}



