 /*
  * Khoros: $Id: run_comm.c,v 1.1 1991/05/10 15:58:30 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_comm.c,v 1.1 1991/05/10 15:58:30 khoros Exp $";
#endif

 /*
  * $Log: run_comm.c,v $
 * Revision 1.1  1991/05/10  15:58:30  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "editimage.h"

/********************************************************
*
*  Routine Name:  run_comment
*
*       Purpose:  drives the pane 'comment'
*
*         Input:  form - pointer to the form tree 
*		  comment_info  - information structure for pane 'comment'
*        Output:  action of the application program
*
*     Called By:  run_function()
*
*   Automatically Generated By:  conductor
*
********************************************************/

run_comment(form, comment_info)

xvf_form *form;
comment_subform_comment *comment_info;
{
	if (xvdisplay->image == NULL)
	{
	    xvf_error_wait("Please display an image before attempting to comment it!", "run_comment", NULL);
	    return;
	}

	_xvf_get_comment(form, comment_info);

	/*
	 * user clicked on pane action button 'comment'
	 */
	if (comment_info->comment)
	{
	    comment_image(comment_info->comment_string); 
	}
}

/********************************************************
*
*  Routine Name:  comment_image
*
*       Purpose:  changes the comment of the displayed image
*
*         Input:  the comment string
*        Output:  none
*
*     Called By:  run_image()
*
*    Written By:  Mark Young
*
********************************************************/

comment_image(comment)

char    *comment;
{
        int    length;
        struct xvimage *image = xvdisplay->image;

        length = xvf_strlen(comment);

        if (length == 0)
        {
           image->comment[0] = '\0';
        }
        else if (length >= 512)
        {
           (void) strncpy(image->comment, comment, 511);
           image->comment[511] = '\0';
        }
        else
        {
           (void) strcpy(image->comment, comment);
        }
}
