 /*
  * Khoros: $Id: set.c,v 1.2 1992/03/20 22:48:14 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: set.c,v 1.2 1992/03/20 22:48:14 dkhoros Exp $";
#endif

 /*
  * $Log: set.c,v $
 * Revision 1.2  1992/03/20  22:48:14  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"

/************************************************************
*
*  Routine Name:  xvf_set_colormap()
*
*      Purpose:   Used to set the colormap to be used by the forms.
*		  After calling xvf_initialize() the user is allowed
*		  to then call this routine to set the colormap
*		  to be used in creating all the forms.
*
*        Input:	  colormap - the colormap to be used in creating the
*			     forms.
*
*       Output:	  set the global xvf_colormap variable.
*
*    Called By:   the application program
*
*   Written By:   Mark Young
*
*
*************************************************************/
static int colormap_override = False;

xvf_set_colormap(colormap)

Colormap colormap;
{
	if (colormap_override == False) xvf_colormap = colormap;
}



/************************************************************
*
*  Routine Name:  xvf_set_visual()
*
*      Purpose:   Used to set the visual to be used by the forms.
*		  After calling xvf_initialize() the user is allowed
*		  to then call this routine to set the visual
*		  to be used in creating all the forms.
*
*        Input:	  visual - the visual to be used in creating the
*			   forms.
*
*       Output:	  set the global xvf_visual variable.
*
*    Called By:   the application program
*
*   Written By:   Mark Young
*
*
*************************************************************/



xvf_set_visual(visual)

Visual *visual;
{
	int	    i, vis_id, def_id, count;
	int	    screen = XDefaultScreen(xvf_display);

	long	    mask;
	Visual	    *default_visual;
	XVisualInfo vinfo, *vinfos;


	/*
	 *  Before allowing the visual to be set we better make sure
	 *  that the default visual and the desired visual have the
	 *  same depth otherwise the xvforms will bomb with some
	 *  wierd X protocol error.  (Mark 3/18/92) 
	 */
	mask = VisualScreenMask;
	vinfo.screen = screen;
	vinfos = XGetVisualInfo(xvf_display, mask, &vinfo, &count);
	default_visual = DefaultVisual(xvf_display, screen);

	vis_id = def_id = -1;
	for (i = 0; i < count; i++)
	{
	   if (vinfos[i].visual == default_visual)
	      def_id = i;
	   if (vinfos[i].visual == visual)
	      vis_id = i;
	}

	if (vis_id == -1)
	   return;
	else if (def_id != -1 && vinfos[vis_id].depth != vinfos[def_id].depth)
	{
	   xvf_visual   = NULL;
	   xvf_colormap = NULL;
	   colormap_override = True;
	}
	else
	   xvf_visual = visual;
}
