 /*
  * Khoros: $Id: lvect2band.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvect2band.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvect2band.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvect2band.c
 >>>>
 >>>>      Program Name: vect2band
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:23:55 1991 
 >>>>
 >>>>          Routines: lvect2band - the library call for vect2band
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvect2band - library call for vect2band
*
* Purpose:
*    
*    reformats data stored in vector format to a file where  each
*    vector is represented as a single band in the output file.
*    
*    
* Input:
*    
*    *image         pointer to the input/output xvimage structure
*    
*    
* Output:
*    
*    *image         pointer to the input/output (struct xvimage)
*    
*    
*
* Written By: Charlie Gage
*    
*    24-Jan-91 Scott Wilson - Removed restriction that the  input
*    image  be a single row image. I don't think this restriction
*    was intended originally but it was there anyway. The  output
*    image  now  contains one band for each vector (pixel) in the
*    input image regardless of the number of rows. The bands  are
*    generated  in  scan-line  order  of the vectors in the input
*    image.
*    
*    
****************************************************************/


/* -library_def */
int 
lvect2band (image)
struct xvimage  *image;
/* -library_def_end */

/* -library_code */
{
  int
         i,              /* loop control variables */
         num_rows,       /* number of ROWS in output image */
         num_cols,       /* number of COLS in output image */
         num_bands,      /* number of BANDS in output image */
         num_vects,      /* number of vectors returned by dload_vector */
         dimension,      /* dimension of each vector returned by dload_vector */
         border,         /* set border to 0, when calling unload_vector */
         process_dir;    /* 0 = IMG_VECTOR, 1 = IMG_BAND */

  char   **vectors;     /* vector array returned by load_vector */

  char   **load_vector();

  int    dunload_vector();

  char *program = "lvect2band";


  border = 0;
  process_dir = 1;       /* set process_dir to IMG_BAND */

 /*-------------------------------------------------------------------*/
 /*  Check for valid data_storage_type                                */
 /*-------------------------------------------------------------------*/
  if (image->data_storage_type == VFF_TYP_BIT) 
  {
    (void)fprintf(stderr,"lvect2band: Incorrect data storage type.\n");
    (void)fprintf(stderr,"Data can be any type except BIT.\n");
    return(0);
  }

 /*-------------------------------------------------------------------*/
 /* Input image can only have one image                               */
 /*-------------------------------------------------------------------*/
if (! (proper_num_images(program, image, 1, FALSE))) {
   (void) fprintf (stderr,"%s: ERROR All inputs must contain only one image\n", program);
   return(0);
 }

 /*-------------------------------------------------------------------*/
 /* Check for valid map_scheme and map_enable combinations            */
 /*-------------------------------------------------------------------*/
if ( (image->num_data_bands > 1) && (image->map_scheme == VFF_MS_ONEPERBAND) )
{
  fprintf(stderr,"%s: MUST remove map or map data through the map before using this routine.\n", program);
  return(0);
}

if ((image->map_scheme == VFF_MS_CYCLE) || (image->map_scheme == VFF_MS_GROUP))
{
  fprintf(stderr,"%s: will not work with map_scheme of MS_CYCLE or MS_GROUP\n", program);
  return(0);
}

 /*----------------------------------------------------------------------*/
 /* Determine size and geometry of resulting output image.               */
 /*   ---------------------------------------------------                */
 /*   number of rows:  equal to the subrow_size of the input image.      */
 /*   number of cols:  equal to the number of data bands divided by      */
 /*                     the subrow_size of the input image.              */
 /*   number of bands: the number of bands is equal to the number of     */
 /*                     pixels (or vectors) in a band of the input image.*/
 /*                     the input image.                                 */
 /*----------------------------------------------------------------------*/
  if (image->subrow_size <= 0)
    num_rows = 1;
  else
    num_rows = image->subrow_size;
  num_cols = (image->num_data_bands / num_rows);
  num_bands = (image->row_size)*(image->col_size);

 /*----------------------------------------------------------------------*/
 /*  Call load_vector to rearange the data as a list of vectors.         */
 /*    This returns a 2-D array of data.                                 */
 /*----------------------------------------------------------------------*/
 if ( (vectors = (char **)load_vector(image, border, &num_vects, &dimension)) == NULL)
  {
    (void) fprintf(stderr,"lvect2band: load_vector failed\n");
    return(0);
  }

 /*----------------------------------------------------------------------*/
 /* Call dunload_vector to unstack each vector as a band                 */
 /*----------------------------------------------------------------------*/
  free(image->imagedata);
  if (! dunload_vector((char **)vectors, image, image->data_storage_type, num_vects, dimension, process_dir))
  {
    (void) fprintf(stderr,"lvect2band: dunload_vector failed\n");
    return(0);
  }

 /*----------------------------------------------------------------------*/
 /* Adjust Header information for output image                           */
 /*----------------------------------------------------------------------*/
  image->col_size = num_rows;                  /* num rows */
  image->row_size = num_cols;                  /* num cols */
  image->num_data_bands = num_bands;           /* num_data_bands */
  image->color_space_model = VFF_CM_NONE;
  if (image->map_scheme == VFF_MS_NONE)
      image->map_scheme = VFF_MS_NONE;
  else
      image->map_scheme = VFF_MS_SHARED;

 /* Reset subrow size of resulting output image */
  image->subrow_size = 0;

 /*----------------------------------------------------------------------*/
 /* Release memory for "vector" array                                    */
 /*----------------------------------------------------------------------*/
  for (i = 0; i < num_vects; i++)
       free((char *) vectors[i]);

  free((char **) vectors);
  return(1);

}
/* -library_code_end */
