 /*
  * Khoros: $Id: raw2viff.c,v 1.2 1991/12/18 09:51:46 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: raw2viff.c,v 1.2 1991/12/18 09:51:46 dkhoros Exp $";
#endif

 /*
  * $Log: raw2viff.c,v $
 * Revision 1.2  1991/12/18  09:51:46  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: raw2viff.c
 >>>>
 >>>>      Program Name: raw2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Transforms RAW data into the VIFF file format.
 >>>>	
 >>>>	

 >>>>            Author: Ramiro Jordan, Mike Lang, Mark Young, Tom Sauer
 >>>>
 >>>> Date Last Updated: Wed Nov 13 12:33:44 1991
 >>>>
 >>>>          Routines: main- the main program for raw2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "raw2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for raw2viff
 *
 *       Input:  
 *          -i  input raw data file 
 *          -o  resulting output image (viff file) 
 *          -r  number of rows   (value >= 0)
 *          -c  number of columns   (value >= 0)
 *
 *
 *          [-l] if yes the input file is supposed to be interleaved; if no (default) it is considered as not interleaved
 *          [-m] increment factor for skipping rows  (value >= 0)
 *          [-n] increment factor for skipping columns  (value >= 0)
 *          [-b] specify the number of data bands in the image  (value > 0)
 *          [-d] specify the number of location bands or the dimension  (value >= 0)
 *          [-h] number of points to offset from the start of the data file  (value >= 0)
 *          [-s] number of points to offset from the first point of each band  (value >= 0)
 *          [-t] lets user choose output data type
 *		'byte' (choose byte data type),
 *		'bit' (choose bit data type),
 *		'short' (choose short data type),
 *		'int' (choose integer data type),
 *		'float' (choose float data type),
 *		'complex' (choose complex data type),
 *		 or 'double' (choose double data type)
 *		   [default = byte] 
 *          [-mt] choose input data machine type
 *		'Local Machine' (choose machine type),
 *		'DECstation' (choose machine type),
 *		'Mips cpu, big endian mode' (choose machine type),
 *		'Encore, Sequent, NS32000' (choose machine type),
 *		'MIPS' (choose machine type),
 *		'MC680x0' (choose machine type),
 *		'Sun' (choose machine type),
 *		'MacII' (choose machine type),
 *		'NeXT' (choose machine type),
 *		'Sony News' (choose machine type),
 *		'Vax' (choose machine type),
 *		'Cray' (choose machine type),
 *		'Convex' (choose machine type),
 *		'Apollo' (choose machine type),
 *		'Silicon Graphics' (choose machine type),
 *		'Titan' (choose machine type),
 *		'IBM RT' (choose machine type),
 *		'IBM032' (choose machine type),
 *		'RISC 6000' (choose machine type),
 *		'Motorola 88000' (choose machine type),
 *		'hp9000' (choose machine type),
 *		 or 'Data General' (choose machine type)
 *		   [default = Local Machine] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image;
int     type, start, offset, row_inc, col_inc, numbands, dimensions;
int     interleave, nrows, ncols, mach_type;
char    *malloc();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
if (!vget_type(&type,raw2viff->t_toggle))
{
   (void)fprintf(stderr,"raw2viff: unknown data type!\n");
   exit(1);
}

  /* check to see if the raw data type is the current machine. If so
   * then get the type
   */

if (VStrcmp(raw2viff->mt_toggle, "Local Machine") == 0) mach_type = machtype(NULL);
else  mach_type = machorder(raw2viff->mt_toggle);

start = raw2viff->s_int;
offset = raw2viff->h_int;
row_inc = raw2viff->m_int;
col_inc = raw2viff->n_int;
numbands = raw2viff->b_int;
dimensions = raw2viff->d_int;
interleave = raw2viff->l_logic;
nrows = raw2viff->r_int;
ncols = raw2viff->c_int;

/* -main_before_lib_call_end */

/* -main_library_call */
if(! lraw2viff(raw2viff->i_file, &image, nrows, ncols, offset, start, 
               row_inc, col_inc, numbands, dimensions, interleave, 
               type, mach_type))
{
    (void) fprintf(stderr, "lraw2viff Failed\n");
    exit(1);
}

/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(raw2viff->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for raw2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "raw2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tTransforms RAW data into the VIFF file format.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input raw data file  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image (viff file)  (outfile)\n");
	fprintf(stderr,"\t-r  number of rows  (integer, >= 0)\n");
	fprintf(stderr,"\t-c  number of columns  (integer, >= 0)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-l]  if yes the input file is supposed to be interleaved; if no (default) it is considered as not interleaved (boolean) [false]\n");
	fprintf(stderr,"\t[-m]  increment factor for skipping rows (integer, >= 0) [1]\n");
	fprintf(stderr,"\t[-n]  increment factor for skipping columns (integer, >= 0) [1]\n");
	fprintf(stderr,"\t[-b]  specify the number of data bands in the image (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-d]  specify the number of location bands or the dimension (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-h]  number of points to offset from the start of the data file (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-s]  number of points to offset from the first point of each band (integer, >= 0) [0]\n");
	fprintf(stderr, "\t[-t]  lets user choose output data type\n");
	fprintf(stderr, "\t\t'byte'  (choose byte data type),\n");
	fprintf(stderr, "\t\t'bit'  (choose bit data type),\n");
	fprintf(stderr, "\t\t'short'  (choose short data type),\n");
	fprintf(stderr, "\t\t'int'  (choose integer data type),\n");
	fprintf(stderr, "\t\t'float'  (choose float data type),\n");
	fprintf(stderr, "\t\t'complex'  (choose complex data type),\n");
	fprintf(stderr, "\t\t or 'double'  (choose double data type)\n");
	fprintf(stderr, "\t\t[default = byte]\n");
	fprintf(stderr, "\n");	fprintf(stderr, "\t[-mt]  choose input data machine type\n");
	fprintf(stderr, "\t\t'Local Machine'  (choose machine type),\n");
	fprintf(stderr, "\t\t'DECstation'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Mips cpu, big endian mode'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Encore, Sequent, NS32000'  (choose machine type),\n");
	fprintf(stderr, "\t\t'MIPS'  (choose machine type),\n");
	fprintf(stderr, "\t\t'MC680x0'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Sun'  (choose machine type),\n");
	fprintf(stderr, "\t\t'MacII'  (choose machine type),\n");
	fprintf(stderr, "\t\t'NeXT'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Sony News'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Vax'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Cray'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Convex'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Apollo'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Silicon Graphics'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Titan'  (choose machine type),\n");
	fprintf(stderr, "\t\t'IBM RT'  (choose machine type),\n");
	fprintf(stderr, "\t\t'IBM032'  (choose machine type),\n");
	fprintf(stderr, "\t\t'RISC 6000'  (choose machine type),\n");
	fprintf(stderr, "\t\t'Motorola 88000'  (choose machine type),\n");
	fprintf(stderr, "\t\t'hp9000'  (choose machine type),\n");
	fprintf(stderr, "\t\t or 'Data General'  (choose machine type)\n");
	fprintf(stderr, "\t\t[default = Local Machine]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for raw2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for raw2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called raw2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses raw2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for raw2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input raw data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image (viff file) \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows \n        {integer, >= 0}: "; 
char	*c_pstr = 
	"\nEnter: (c) number of columns \n        {integer, >= 0}: "; 
char	*l_pstr = 
	"\nEnter: (l) if yes the input file is supposed to be interleaved; if no (default) it is considered as not interleaved \n        {boolean, (y/n)  [no] }: "; 
char	*m_pstr = 
	"\nEnter: (m) increment factor for skipping rows \n        {integer, >= 0 [1] }: "; 
char	*n_pstr = 
	"\nEnter: (n) increment factor for skipping columns \n        {integer, >= 0 [1] }: "; 
char	*b_pstr = 
	"\nEnter: (b) specify the number of data bands in the image \n        {integer, > 0 [1] }: "; 
char	*d_pstr = 
	"\nEnter: (d) specify the number of location bands or the dimension \n        {integer, >= 0 [0] }: "; 
char	*h_pstr = 
	"\nEnter: (h) number of points to offset from the start of the data file \n        {integer, >= 0 [0] }: "; 
char	*s_pstr = 
	"\nEnter: (s) number of points to offset from the first point of each band \n        {integer, >= 0 [0] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose output data type -- \n      \t\t'byte' (choose byte data type)\n\t\t'bit' (choose bit data type)\n\t\t'short' (choose short data type)\n\t\t'int' (choose integer data type)\n\t\t'float' (choose float data type)\n\t\t'complex' (choose complex data type)\n\t\tor 'double' (choose double data type)\n  [byte]:  "; 
char	*mt_pstr = "\nEnter: (mt) choose input data machine type -- \n      \t\t'Local Machine' (choose machine type)\n\t\t'DECstation' (choose machine type)\n\t\t'Mips cpu, big endian mode' (choose machine type)\n\t\t'Encore, Sequent, NS32000' (choose machine type)\n\t\t'MIPS' (choose machine type)\n\t\t'MC680x0' (choose machine type)\n\t\t'Sun' (choose machine type)\n\t\t'MacII' (choose machine type)\n\t\t'NeXT' (choose machine type)\n\t\t'Sony News' (choose machine type)\n\t\t'Vax' (choose machine type)\n\t\t'Cray' (choose machine type)\n\t\t'Convex' (choose machine type)\n\t\t'Apollo' (choose machine type)\n\t\t'Silicon Graphics' (choose machine type)\n\t\t'Titan' (choose machine type)\n\t\t'IBM RT' (choose machine type)\n\t\t'IBM032' (choose machine type)\n\t\t'RISC 6000' (choose machine type)\n\t\t'Motorola 88000' (choose machine type)\n\t\t'hp9000' (choose machine type)\n\t\tor 'Data General' (choose machine type)\n  [Local Machine]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "raw2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "raw2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "raw2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "raw2viff.ans");
		}

	     }

	}

	/*
	 * allocate the raw2viff structure
	 */
	raw2viff = (raw2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (raw2viff_struct));

	/*
	 * get required arguments for raw2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(raw2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(raw2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(raw2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    raw2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(raw2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(raw2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(raw2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(raw2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    raw2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(raw2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(raw2viff->r_flag = vget_int(fid, prompt_flag,
			"-r", r_pstr, &(raw2viff->r_int),
			512, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(raw2viff->r_flag))
		{
		    fprintf(stderr, "\t\tr is required, please re-enter: \n");
		    raw2viff->r_flag = vget_int(fid, prompt_flag,
		    "-r", r_pstr, &(raw2viff->r_int),
		    512, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-r' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(raw2viff->c_flag = vget_int(fid, prompt_flag,
			"-c", c_pstr, &(raw2viff->c_int),
			512, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(raw2viff->c_flag))
		{
		    fprintf(stderr, "\t\tc is required, please re-enter: \n");
		    raw2viff->c_flag = vget_int(fid, prompt_flag,
		    "-c", c_pstr, &(raw2viff->c_int),
		    512, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-c' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for raw2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	raw2viff->l_flag = vget_logic(fid, prompt_flag,
	"-l", l_pstr, &(raw2viff->l_logic), 0);

	raw2viff->m_flag = vget_int(fid, prompt_flag,
	"-m", m_pstr, &(raw2viff->m_int),
	1, 1, 1);

	raw2viff->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(raw2viff->n_int),
	1, 1, 1);

	raw2viff->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(raw2viff->b_int),
	1, 2, 2);

	raw2viff->d_flag = vget_int(fid, prompt_flag,
	"-d", d_pstr, &(raw2viff->d_int),
	0, 1, 1);

	raw2viff->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(raw2viff->h_int),
	0, 1, 1);

	raw2viff->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(raw2viff->s_int),
	0, 1, 1);


	/*
	 * get optional toggles for raw2viff
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		raw2viff->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(raw2viff->t_toggle),
		"byte");

		if (((strcmp(raw2viff->t_toggle, "byte") == 0)) || 
		     ((strcmp(raw2viff->t_toggle, "bit") == 0)) || 
		     ((strcmp(raw2viff->t_toggle, "short") == 0)) || 
		     ((strcmp(raw2viff->t_toggle, "int") == 0)) || 
		     ((strcmp(raw2viff->t_toggle, "float") == 0)) || 
		     ((strcmp(raw2viff->t_toggle, "complex") == 0)) || 
		     ((strcmp(raw2viff->t_toggle, "double") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	    ok = FALSE;
	    while(!ok)
	    {
		raw2viff->mt_flag = vget_string(fid, prompt_flag,
		"-mt", mt_pstr, &(raw2viff->mt_toggle),
		"Local Machine");

		if (((strcmp(raw2viff->mt_toggle, "Local Machine") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "DECstation") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Mips cpu, big endian mode") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Encore, Sequent, NS32000") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "MIPS") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "MC680x0") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Sun") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "MacII") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "NeXT") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Sony News") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Vax") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Cray") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Convex") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Apollo") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Silicon Graphics") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Titan") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "IBM RT") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "IBM032") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "RISC 6000") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Motorola 88000") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "hp9000") == 0)) || 
		     ((strcmp(raw2viff->mt_toggle, "Data General") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		raw2viff->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(raw2viff->t_toggle),
		"byte");

		if (((strcmp(raw2viff->t_toggle, "byte") != 0)) && 
		     ((strcmp(raw2viff->t_toggle, "bit") != 0)) && 
		     ((strcmp(raw2viff->t_toggle, "short") != 0)) && 
		     ((strcmp(raw2viff->t_toggle, "int") != 0)) && 
		     ((strcmp(raw2viff->t_toggle, "float") != 0)) && 
		     ((strcmp(raw2viff->t_toggle, "complex") != 0)) && 
		     ((strcmp(raw2viff->t_toggle, "double") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
		raw2viff->mt_flag = vget_string(fid, prompt_flag,
		"-mt", mt_pstr, &(raw2viff->mt_toggle),
		"Local Machine");

		if (((strcmp(raw2viff->mt_toggle, "Local Machine") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "DECstation") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Mips cpu, big endian mode") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Encore, Sequent, NS32000") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "MIPS") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "MC680x0") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Sun") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "MacII") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "NeXT") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Sony News") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Vax") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Cray") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Convex") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Apollo") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Silicon Graphics") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Titan") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "IBM RT") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "IBM032") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "RISC 6000") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Motorola 88000") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "hp9000") != 0)) && 
		     ((strcmp(raw2viff->mt_toggle, "Data General") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



