 /*
  * Khoros: $Id: lpbm2viff.c,v 1.2 1991/10/02 00:29:45 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lpbm2viff.c,v 1.2 1991/10/02 00:29:45 khoros Exp $";
#endif

 /*
  * $Log: lpbm2viff.c,v $
 * Revision 1.2  1991/10/02  00:29:45  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lpbm2viff.c
 >>>>
 >>>>      Program Name: pbm2viff
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:32:59 1991 
 >>>>
 >>>>          Routines: lpbm2viff - the library call for pbm2viff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "file_formats/pbm.h"
#include "vrev.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lpbm2viff - library call for pbm2viff
*
* Purpose:
*    
*    Converts a PBM image into a VIFF image.
*    
*    
* Input:
*    
*         struct pbm  *pbm:  PBM image input
*    
*    
* Output:
*    
*         struct xvimage **viff:  VIFF output image
*    
*    
*
* Written By: Mark Young
****************************************************************/


/* -library_def */
int lpbm2viff(pbm, viff)

struct  pbm *pbm;
struct  xvimage **viff;
/* -library_def_end */

/* -library_code */
{
        char     comment[LENGTH];
        struct   xvimage *createimage();
        int      data_storage_type, num_bands, num_bytes;
	unsigned long color_space_model;


        /*
         *  Set the data type for the resulting viff structure.
         */
        if (pbm->type == PBM)
        {
           num_bands = 1;
	   color_space_model = VFF_CM_NONE;
           data_storage_type = VFF_TYP_BIT;
        }
        else if (pbm->type == PGM)
        {
           num_bands = 1;
	   color_space_model = VFF_CM_NONE;
           if (pbm->maxval <= 255 && pbm->raw)
              data_storage_type = VFF_TYP_1_BYTE;
           else
              data_storage_type = VFF_TYP_4_BYTE;
        }
        else if (pbm->type == PPM)
        {
           num_bands = 3;
	   color_space_model = VFF_CM_genericRGB;
           if (pbm->maxval <= 255 && pbm->raw)
              data_storage_type = VFF_TYP_1_BYTE;
           else
              data_storage_type = VFF_TYP_4_BYTE;
        }
        else
        {
           (void) fprintf(stderr,"lpbm2viff: Error! Unknown type of pbm \
file.\n");
           (void) fprintf(stderr,"   Portable bitmap/pixmap can be of either \
pbm, pgm, or ppm format.  !\n");
           return(FALSE);
        }

        /*
         *  Create the new viff image structure.
         */
        (void) sprintf(comment, "Image created by pbm2viff from portable bitmap\
/pixmap definition.\n");
        *viff = createimage(pbm->height, pbm->width, data_storage_type, 1,
                        num_bands, comment,
                        (unsigned long)0, /* map_row_size */
                        (unsigned long)0, /* map_col_size */
                        (unsigned long)VFF_MS_NONE,
                        (unsigned long)VFF_MAPTYP_NONE,
                        (unsigned long)VFF_LOC_IMPLICIT,
                        (unsigned long)0);/* location dimension */

        if (*viff == NULL)
        {
           (void) fprintf(stderr,"lpbm2viff:  Unable to allocate memory for \
viff image.\n");
           return(FALSE);
        }
	(*viff)->color_space_model = color_space_model;

        if (pbm->type == PPM)           /* convert PPM image to VIFF */
        {
           if (pbm->raw)
           {
              int      i, j, size;
              unsigned char *src, *dest;

              size = pbm->width * pbm->height;
              src = (unsigned char *) pbm->data;
              dest = (unsigned char *) (*viff)->imagedata;

              for (i = 0, j = 0; i < size; i++)
              {
                 dest[i] = src[j++];
                 dest[i+size] = src[j++];
                 dest[i+size*2] = src[j++];
              }
           }
           else
           {
              int i, j, size;
              int *src, *dest;

              size = pbm->width * pbm->height;
              src = (int *) pbm->data;
              dest = (int *) (*viff)->imagedata;

              for (i = 0, j = 0; i < size; i++)
              {
                 dest[i] = src[j++];
                 dest[i+size] = src[j++];
                 dest[i+size*2] = src[j++];
              }
           }
        }
        else if (pbm->type == PGM)     /* convert PGM image to VIFF */
        {
           num_bytes = viff_rowsize(data_storage_type,pbm->width) * pbm->height;
           bcopy(pbm->data, (*viff)->imagedata, num_bytes);
        }
        else                           /* convert PBM image to VIFF */
        {
           int i, size;
           unsigned char *src, *dest;

           size = viff_rowsize(data_storage_type, pbm->width) * pbm->height;
           src = (unsigned char *) pbm->data;
           dest = (unsigned char *) (*viff)->imagedata;

           for (i = 0; i < size; i++)
           {
              if (pbm->raw)
                 dest[i] = ~rev[src[i]];
              else
                 dest[i] = ~src[i];
           }
        }
        return(TRUE);
}
/* -library_code_end */
