#ifndef POINT3DEFS
#define POINT3DEFS
/*
** Definitions for 3D float points:
*/

typedef float Pt3Coord;
typedef struct { Pt3Coord x, y, z; } Point3;

extern void Pt3Print(/* Point3 *p */);
extern void Pt3From(/* Point3 *p, Pt3Coord x, y, z */);
extern void Pt3Copy(/* Point3 *a, *b */);

extern void Pt3Add(/* Point3 *a, *b, *c */);
extern void Pt3Sub(/* Point3 *a, *b, *c */);
extern void Pt3Neg(/* Point3 *a, *b */);
extern void Pt3Mul(/* Pt3Coord s, Point3 *a, *b */);
extern void Pt3Comb(/* Pt3Coord sa, Point3 *a, Pt3Coord sb, Point3 *b, *c */);
extern void Pt3Lerp(/* Pt3Coord a, Point3 *a, *b, *c */);

extern Pt3Coord Pt3Dot(/* Point3 *a, *b */);
extern void Pt3Cross(/* Point3 *a, *b, *c */);
extern Pt3Coord Pt3TripleDot(/* Point3 *a, *b, *c */);
extern void Pt3TripleCross(/* Point3 *a, *b, *c, *d */);

extern Pt3Coord Pt3Distance(/* Point3 *a, *b */);
extern Pt3Coord Pt3Length(/* Point3 *p */);
extern Pt3Coord Pt3Angle(/* Point3 *a, *b */);

extern int Pt3Equal(/* Point3 *a, *b */);
extern int Pt3Parallel(/* Point3 *a, *b */);
extern int Pt3Perpendicular(/* Point3 *a, *b */);

/* Note -- this was incorrect -- there is only one arg
   Tamara Munzner 7/17/90 */
extern void Pt3Unit(/* Point3 *a */);

extern void Pt3Transform(/* Transform3 T, Point3 *a, *b */);
extern void Pt3TransformN(/* Transform3 T, Point3 *a, *b, int n */);

extern Point3 Pt3Origin;

#define Pt3X(pt) (pt)->x
#define Pt3Y(pt) (pt)->y
#define Pt3Z(pt) (pt)->z

#endif
