// This contains a spline editor subroutine/object
#include <gl/gl.h>
#include <gl/sphere.h>
#include <gl/device.h>
#include <gl/image.h>
#include <stream.h>
#include <unistd.h>
#include <math.h>

void matrix_mult(float a[4][4],float b[4][3],float c[4][3]);
typedef 	struct	{	float real,imag;} complex;



extern "C" {
#include <forms.h>
    extern void savemovieframe(); 
    void zporc_(long int*,float *,float *);
}

#include "graphics.h"
#include "spline_ed.h"
#include "../inc/debug.h"
#include "../inc/colors.h"

#define CNTRL_PNT_RADIUS 10
#define CSPLINE 2

float cspline_matrix[4][4] = {
    { -0.5, 1.5, -1.5, 0.5},
    {  1.0,-2.5,  2.0,-0.5},
    { -0.5,   0,  0.5, 0},
    {    0,   1,  0  , 0}
};

float precisionmatrix[4][4] =  {
    { 6.0/8000.0, 0.0, 0.0, 0.0},
    { 6.0/8000.0, 2.0/400.0, 0.0,0.0},
    { 1.0/8000.0, 1.0/400.0, 1.0/20.0, 0.0},
    {0.0, 0.0, 0.0, 1}
};



spline_cntrl_points::spline_cntrl_points(int a) {
    

       
    status("Init control points",a);
    num_pts = a;
    pnts = new float[num_pts*3];

    reset();
    //	 print();
};



/*** reset -- set the cntrl points to initial values ***/
void spline_cntrl_points::reset()
{
    int		i,indx;
    float inc;		// space between each spline control point
    float xpos;

    status("reseting");
    indx=0;
    inc = 50;
    xpos = 0.0;
    for (i=0;i<num_pts;i++) {
	pnts[indx] = xpos;
	pnts[indx+1] = -10.0;
	pnts[indx+2] = 0.0;
	xpos+= inc;
	indx+= 3;
    }
}
 
/*** print_pnts() -- print the sline control points ***/
void spline_cntrl_points::print(void)
{
    
    int i;
    status("Print Point");
    for (i=0;i<num_pts; i++) {
	cout << "Point #"<< i << " = ("<<xpos(i)<<",";
	cout << ypos(i)<<","<< zpos(i);
	cout << ")" << endl;
    }
}


/*** find_point -- Find the control point(if any) at curr cursor loc. ***/
int spline_cntrl_points::find_point()
{
    long hits;
    short pick_buf[50];
    
    status("find_point");
    
    // Use the GL pick routines to find out which control point
    // was selecteed (Ortho must be the same as in draw_points())
    
    initnames();
    pick(pick_buf,45);
    plot();			// This won't show on the screen
    hits = endpick(pick_buf);
    
    if (hits >1) {
	// return the first picked point
	return(pick_buf[1]);
    }	
    
    else if (hits==0)
      return(-1);
    else {
	// pick_buf[0] = Number of points in set
	// pick_buf[1] = first point selected
	// pick_buf[2] = 2nd point in 1st set (never happen)
	
	//status("pick buf[1]  = ",pick_buf[1]);
	return((int) pick_buf[1]);
    }
}


/*** plot -- Plot spine control points ***/
void spline_cntrl_points::plot(void)
{
    int i;
    
    // make these ortho things variables for scrolling windows??
    // and just print the control points within?
    ortho(XMIN,XMAX,YMIN,YMAX,ZMIN,ZMAX); 
    cpack(c_yellow);
    for (i=0;i<num_pts; i++) {
	loadname(i);
	circf(xpos(i), ypos(i), CNTRL_PNT_RADIUS);
    }
}


spline_cntrl_points::~spline_cntrl_points()
{
    status("Delete cntrl_pnts");
    delete pnts;
}	




/////////////////////////////////////////////////////////////////////////
///	spline_editor	class	routines			     ///
///								     ///
////////////////////////////////////////////////////////////////////////

/*** spline_editor -- initialize the object ***/
spline_editor::spline_editor(int id_num,int no_cntrls,long start,long end) {
    
    
    status("spline_editor init",no_cntrls);
    
    if (start >= end) {
	status("Invalid Frame Parameters - Aborting ");
	exit(-1);
    }
    
    sprintf(title,"UnTitled");
    gid = 0 ;
    st_frame = start;
    end_frame= end;
    curr_frame = 1; 
    cntrl_pts = new spline_cntrl_points(no_cntrls);
    id = id_num;
};



/*** open -- set up the spline graphics window ***/
long spline_editor::open(void) {
     return(open(-1,-1,-1,-1));
}



/*** open -- set up the spline graphics window ***/
long spline_editor::open(long xpos,long ypos,long xsize,long ysize) {
    
    status("spline_editor::open");
    

    if (xpos== -1)	
      keepaspect(2,1);	// window aspect
    else
      prefposition(xpos,xpos+xsize,ypos,ypos+ysize);
    
    if (title==NULL)      gid = winopen("NoTitle");
    else		  gid = winopen(title);
    
    doublebuffer();
    ortho(XMIN,XMAX,YMIN,YMAX,ZMIN,ZMAX); 
    RGBmode();
    defbasis(CSPLINE, cspline_matrix);
    curvebasis(CSPLINE);   
    curveprecision(10);
    gconfig();
    redraw();			// Draw the axis/spline_points
    return(gid);
};



/*** redraw ***/
void spline_editor::redraw()
{
    
    // These could be common to the family instead
    
    static	float p1[] = { 0.0,-700.0};
    static	float p2[] = { 0.0, 700.0};
    static	float p3[] = { 0.0, 0.0};
    static	float p4[] = { 900.0,0.0};
    
    float	mark[2];
    int	x;
    
    winset(gid);
    cpack(c_black);    clear();    zclear();
    
    cpack(c_white);    			// Draw the "axis"
    bgnline();    v2f(p1);	v2f(p2);    endline();
    bgnline();    v2f(p3);	v2f(p4);    endline();
    
    // Plot the axis 
    for (x=0;x<=1000; x+=25) {
	bgnline();
	if	((x % 100)==0) {
	    mark[0] = (float)x;
	    mark[1] = 40;
	    v2f(mark);
	}
	else {
	    mark[0] = (float)x;
	    mark[1] = 20;
	    v2f(mark);
	}
	mark[1] = 0.0;
	v2f(mark);
	endline();
    }
    cntrl_pts->plot();		// plot the control points
    
    // plot the spline
    cpack(c_red);
    crvn(cntrl_pts->num_pts,(Coord [][3])cntrl_pts->pnts);
    swapbuffers();
    /*   savemovieframe(); */
}



/*** value - return the value of spline surve at frame # ***/
float spline_editor::value(long frame) {
    
    float	dist,delta;
    float	xcoor,ycoor;
    int		st_pnt,i;
        
    // convert frame to an X-coordinate
    // status("value lookup for frame",frame);
    
    
    if ((frame < st_frame) || (frame > end_frame)) {
	status("Illegal Frame:",frame);
	return(-1);
    }
    
    // make these class variables that are updated only when needed
    delta = (float) (end_frame - st_frame);
    dist  = XMAX - 100.0;		
    xcoor = (dist/delta) * (float) (frame-st_frame);
    
    // first find what spline segment the point is on
    // skip the cases where at first or last "NULL" segment
    if ((xcoor < cntrl_pts->xpos(1))  	
	||       (xcoor > cntrl_pts->xpos(cntrl_pts->num_pts-2))) { 
	//status("Xcoor ",xcoor);
	//status("Frame does not exist on this spline",title);
	return(-1);
    }
    
    st_pnt=0;
    for (i=2; i <(cntrl_pts->num_pts-1); i++) {
	if (cntrl_pts->xpos(i) >= xcoor) {
	    st_pnt = i-2;
	    break;
	}
    }
        
    //    status(" first control point  ",st_pnt,cntrl_pts->xpos(st_pnt));
    //    status(" Last  control point  ",st_pnt+3,cntrl_pts->xpos(st_pnt+3));
    
    // now find the coefficients for the spline equation 
    // assuming that we always use cardinal spline
    // coefficients should be precalculated also!!

    float	result[4][3];
    float 	*geom_matrix;
    float	t,det,x1,x2;
    float	coeff[3+1];		/* for IMSL fortran routine */
    complex	roots[3];		/* for IMSL fortran routine */

    // If the control point is less than 0 than return -1
    if (cntrl_pts->ypos(st_pnt+1) < 0)
      return(-1);

    geom_matrix = cntrl_pts->pnts + ((st_pnt ) *3);
    matrix_mult(cspline_matrix,(float [4][3])geom_matrix,result);

    // everything above need not be done every time!!!

    // I use a IMSL routine zporc to solve the t^3 t^2 T t^0 = 0
    // equation using the Jenkin-Traub 3-stage algorithm
    // Since I am lazy, you will have to roll your own :)
        
    
    static long int	order=3;  // for imsl routine 
    t = -1;
    if (result[0][0] != 0.0) { // solve using 3rd order equation
	// these are reversed for the IMSL routine
	coeff[0] = result[3][0]-xcoor;
	coeff[1] = result[2][0];
	coeff[2] = result[1][0];
	coeff[3] = result[0][0];
	
	zporc_(&order,&coeff[0],(float *)&roots[0]);
	//status("Cooeficients 0,1 ",coeff[0],coeff[1]);
	//status("Coeeficients 2,3 ",coeff[2],coeff[3]);
	//status("Root 1 ",roots[0].real,roots[0].imag);
	//status("Root 2 ",roots[1].real,roots[1].imag);
	//status("Root 3 ",roots[2].real,roots[2].imag);
	for (i=0;i<3;i++)
	  if ((roots[i].imag==0) && (roots[i].real>=0) &&
	      (roots[i].real<=1.0)) {
	      t= roots[i].real;
	      break;
	  }

	if (t==-1) {
	    status("zporc_ Only Complex roots to spline equation :( ");
	}
    }
    
    else if (result[1][0] !=0.0) { // 2nd order solver w/ quadratic formula
	status("2nd Order Solver ");
	det = ((result[2][0]*result[2][0])- 4.0*result[1][0]*
	       (result[3][0]-xcoor)); 
	if	 (det<0) {
	    status("Negative determinant in 2order solver");
	}
	else {
	    det = fsqrt(det);
	    x1 = (-result[2][0] + det)/ 2*result[1][0];
	    x2 = (-result[2][0] - det)/ 2*result[1][0];
	    status("2nd order results for t",x1,x2);
	    if (x1 > 0)	      	t = x1;
	    else if (x2 > 0)		t = x2;
	    else {
		status("WARNING:Negative t in 2nd order solver",x1,x2);
	    }
	}
    }
    else if (result[2][0] !=0.0) {	// linear solver 
	status("Linear Solver");
	t = -((result[3][0]-xcoor)/result[2][0]); 
    }
    else  {// should never happen
	status("WARNING:: \07 All polynomial coefficients are zero");
    }
    
    if ((t<0) || (t>1)) {
	status("WARNING: \07 Bad T value in spline_editor::value",t);
    }
    
    ycoor= (result[0][1]*t*t*t + result[1][1]*t*t + 
	    result[2][1]*t     + result[3][1]);

    return((float) ycoor/YMAX);
}



/*** callback -- handles when a mouse is pushed in this window ***/
void spline_editor::callback(long dev,short val) {
    
    long 	ox,oy, sx,sy, mx,my;
    int 	pck_pnt;
    float 	wx,wy;
    
    status("Spline Editor::callback");
    switch (dev) {
      case REDRAW:
	redraw();
	break;
	
      case LEFTMOUSE:
	if 	(val ==0) 	{ status("Mouse Released"); break; }
	else if (val==1)	status("Mouse Pushed");
	
	curr_frame = curr_frame;
	pck_pnt = cntrl_pts->find_point();
	
	if (pck_pnt == -1)	 // no point picked
	  break;
	
	// Now poll the mouse valuator until the button is released
	// can make these static vars and put under REDRAW
	getorigin(&ox,&oy);
	getsize(&sx,&sy);
	
	while (getbutton(LEFTMOUSE) == TRUE) {
	    mx = getvaluator(MOUSEX);
	    my = getvaluator(MOUSEY);
	    
	    /* Now we have to find out what the "world"
	      coordinates of the screen coords are */
	    
	    wx = ((float) (mx-ox) * (XMAX-XMIN) / (float) sx) + XMIN;	
	    wy = ((float)(my-oy) * (YMAX-YMIN) / (float) sy) + YMIN;
	    
	    if (wy > YMAX)	wy = YMAX;
	    if (wy < YMIN)	wy = YMIN;
	    
	    // Make sure points stay in correct order 
	    if ( pck_pnt >0)	// if not 1st point
	      if (wx < cntrl_pts->xpos(pck_pnt-1))
		wx = cntrl_pts->xpos(pck_pnt-1);
	    
	    if ( pck_pnt != cntrl_pts->num_pts-1)
	      if (wx> cntrl_pts->xpos(pck_pnt+1))
		wx = cntrl_pts->xpos(pck_pnt+1);
	    
	    cntrl_pts->eq(pck_pnt,wx,wy);
	    redraw();
	}	
    }
}


///////////////////////////////////////////////////////////////////////////////
///	spline_merge::  a set of routines to combine to splines together    ///
///									    ///
///////////////////////////////////////////////////////////////////////////////


int spline_editor::append(spline_editor *a)
{
    
    long		n_cntrls,n_start,n_end;
    float		offset,xst,xend;
    int 		cnt,i ;
    spline_cntrl_points *new_pnts;

    // note: this routine removes the last cntrl points of the script
    // and the fiorst control point of the scene being appended.

    // make x-pos of end_frame and xpos of (a->st_frame)
    xend =  cntrl_pts->xpos(cntrl_pts->num_pts-2);
    xst  =  a->cntrl_pts->xpos(1)+1; 
  
// Transisition time is the amount of time the face
// takes (in xcoords) to switch between emotions
// maybe make transition time a function of the ypos distance,
// but we need to keep all the spline_editors in sync so maybe not

#define TRANSITION_TIME 30
    offset = xend-xst+TRANSITION_TIME;
    status("xst",xst);
    status("xend",xend);
    status("offset ",offset);

    n_cntrls = cntrl_pts->num_pts + a->cntrl_pts->num_pts-2;
    n_start  = st_frame;
    n_end    = end_frame + (a->end_frame - a->st_frame);

   
    new_pnts = new spline_cntrl_points(n_cntrls);

    cnt = 0 ;
    for (i=0;i<cntrl_pts->num_pts-1;i++) {
	new_pnts->eq(cnt,cntrl_pts->xpos(i),cntrl_pts->ypos(i));
	cnt++;
    }
    
    for (i=1;i<a->cntrl_pts->num_pts;i++) {
	new_pnts->eq(cnt,a->cntrl_pts->xpos(i)+offset,a->cntrl_pts->ypos(i));
	cnt++;
    }
    
    delete cntrl_pts;
    cntrl_pts = new_pnts;
    return(TRUE);
}


int spline_editor::prepend(spline_editor *a)
{
    
    long		n_cntrls,n_start,n_end;
    float		offset,offset2,xend;
    int 		cnt,i ;
    spline_cntrl_points *new_pnts;



  
// Transisition time is the amount of time the face
// takes (in xcoords) to switch between emotions
// maybe make transition time a function of the ypos distance,
// but we need to keep all the spline_editors in sync so maybe not

#define TRANSITION_TIME 30
    // make x-pos of end_frame and xpos of (a->st_frame)
    offset2 = a->cntrl_pts->xpos(1) - TRANSITION_TIME;
    xend =  a->cntrl_pts->xpos(cntrl_pts->num_pts-2)- offset2;
    offset = xend+TRANSITION_TIME;  // amount to shift existing pnts right
   

    status("xend",xend);
    status("offset ",offset);

    n_cntrls = cntrl_pts->num_pts + a->cntrl_pts->num_pts - 2;
    n_start  = st_frame;
    n_end    = end_frame + (a->end_frame - a->st_frame);

   
    new_pnts = new spline_cntrl_points(n_cntrls);

    cnt = 0 ;
    for (i=0;i<a->cntrl_pts->num_pts-1;i++) {
	new_pnts->eq(cnt,a->cntrl_pts->xpos(i)-offset2,a->cntrl_pts->ypos(i));
	cnt++;
    }
    
    for (i=1;i<cntrl_pts->num_pts;i++) {
	new_pnts->eq(cnt,cntrl_pts->xpos(i)+offset,cntrl_pts->ypos(i));
	cnt++;
    }
    
    delete cntrl_pts;
    cntrl_pts = new_pnts;
    return(TRUE);
}




int spline_editor::replace(spline_editor *a)
{

    long		n_cntrls,n_start,n_end;
    int 		cnt,i ;
    spline_cntrl_points *new_pnts;

    // we could just copy over the whole structure with an  *= ??

    n_cntrls = a->cntrl_pts->num_pts;
    n_start  = a->st_frame;
    n_end    = a->end_frame;
   
    new_pnts = new spline_cntrl_points(n_cntrls);
    cnt = 0 ; 
    for (i=0;i<a->cntrl_pts->num_pts;i++) {
	new_pnts->eq(cnt,a->cntrl_pts->xpos(i),a->cntrl_pts->ypos(i));
	cnt++;
    }
    
    delete cntrl_pts;
    cntrl_pts = new_pnts;
    return(TRUE);
}



	























// Some debugging routines to see how our spline solver is working
void plot_point(long gid,long color, float xcoor,float ycoor)
{
    
    float	coor[4];
    coor[0] = xcoor;
    coor[1] = ycoor;
    coor[2] = 0;
    coor[3] = .25;
    // status("gid2",gid);
    winset(gid);
    pushmatrix();
    cpack(color);
    //   bgnpoint();
    //    v3f(coor);
    //   endpoint();
    circf(xcoor,ycoor,2.5);
    popmatrix();
}


void plot_dbg_spline(long gid,float coef[4][3])
{
    
    float	t,xcoor,ycoor;
    for (t=0.0; t<1.0;t+=.05) {
	xcoor = coef[0][0]*t*t*t + coef[1][0]*t*t +coef[2][0]*t + coef[3][0];
	ycoor = coef[0][1]*t*t*t + coef[1][1]*t*t +coef[2][1]*t + coef[3][1];
	plot_point(gid,0x88ff00,xcoor,ycoor);
    }
}


void	plot_t_spline(long gid,float coef[4][3],float t)
{
    float	xcoor,ycoor;
    xcoor = coef[0][0]*t*t*t + coef[1][0]*t*t +coef[2][0]*t + coef[3][0];
    ycoor = coef[0][1]*t*t*t + coef[1][1]*t*t +coef[2][1]*t + coef[3][1];
    //    status("T-point",xcoor,ycoor);
    plot_point(gid,0x00FF00,xcoor,ycoor);
}






void matrix_mult(float a[4][4],float b[4][3],float c[4][3])
{
    int		i,j,n;
    float	temp;

    /* mat A * mat B = mat C 
      This can be optimized since we know the structure of
	matrix and only need first 2 colomns */


    /* Debug print the  matrixes */
/*    cout << "Geometry Matrix: "<<endl;
    for (i=0;i<4;i++) {
	for (j=0;j<3;j++) {
	    cout << b[i][j]<<" ";
	}
	cout << endl;
    }

    
    cout << "Basis Matrix: " << endl ;
    for (i=0; i<4;i++) {
	for (j=0;j<4;j++)
	    cout << a[i][j]<<"  ";
	cout << endl;
    }

  */  
    for (i=0; i<4; i++) {		// loop thru C elements
	for (j=0;j<3;j++) {
	    

	    /* c[i][j] = [ith row of A] * [jth column of B] */
	  
	    temp = 0 ; 
	//    cout << " ( "<<i <<"," <<j<<") = "<<endl;

	    for (n=0;n<4;n++) {
		temp += a[i][n] * b[n][j]; 
		//cout << a[i][n] << " * " <<b[n][j] << " +" << endl;
	    }
	    c[i][j] = temp;
	   
	 //   cout << "Which equals = " << temp << endl;
	 //   cout << temp << " ";
	}
	//cout << endl;
    }
    
    /*
    cout << "Result Matrix: "<<endl;
    for (i=0;i<4;i++) {
	for (j=0;j<3;j++) {
	    cout << c[i][j]<<"\t ";
	}
	cout << endl;
    }
    */
}

void calc_coeff(float a[4][4],float b[4][3],float c[4][2])
{
    int		i,j,n;
    float	temp;

    /* mat A * mat B = mat C 
      This can be optimized since we know the structure of
	matrix and only need first 2 colomns */


    /* Debug print the  matrixes */
/*    cout << "Geometry Matrix: "<<endl;
    for (i=0;i<4;i++) {
	for (j=0;j<3;j++) {
	    cout << b[i][j]<<" ";
	}
	cout << endl;
    }

    
    cout << "Basis Matrix: " << endl ;
    for (i=0; i<4;i++) {
	for (j=0;j<4;j++)
	    cout << a[i][j]<<"  ";
	cout << endl;
    }

  */  

    

    for (i=0; i<4; i++) {		// loop thru C elements
	for (j=0;j<2;j++) {
	    

	    /* c[i][j] = [ith row of A] * [jth column of B] */
	  
	    temp = 0 ; 
	//    cout << " ( "<<i <<"," <<j<<") = "<<endl;

	    for (n=0;n<4;n++) {
		temp += a[i][n] * b[n][j]; 
		//cout << a[i][n] << " * " <<b[n][j] << " +" << endl;
	    }
	    c[i][j] = temp;
	   
	 //   cout << "Which equals = " << temp << endl;
	 //   cout << temp << " ";
	}
	//cout << endl;
    }
    
    /*
    cout << "Result Matrix: "<<endl;
    for (i=0;i<4;i++) {
	for (j=0;j<3;j++) {
	    cout << c[i][j]<<"\t ";
	}
	cout << endl;
    }
    */
}



