unit cmdparse;

{$I init.inc}

{*Unit CmdParse***********************************************************

 Command line input parser

 Author      : Tom Kooij
 Date        : 23/04/93
 Last Change : 12/06/93

 ************************************************************************}

interface

uses dos,globals;

procedure ParseCommandLine;

implementation

procedure Usage;
begin
  writeln('TKTRACE <filename> [options]');
  writeln;
  writeln('Options:');
  writeln('        -(A)ntialias (N)one/(A)daptive/(Q)uick');
  writeln('        -(W)idth <integer>');
  writeln('        -(H)eight <integer>');
  writeln('        -(S)ilent [no statistics while rendering]');
  writeln;
  writeln('Example: TKTRACE demo -aq -w320 -h200');
  writeln;
  halt(1);
end;


procedure ParseError(Str : string);
begin
  writeln('Error in Option: ',Str);
  writeln;
  Usage;
end;

procedure ParseOption(var OptionStr : String);
var
  TempStr  :  String;
  Control,
  TempInt  :  Integer;

begin
  case OptionStr[2] of
      'a','A' : begin
                  case OptionStr[3] of
                       'n','N' : antialias := A_NONE;
                       'a','A' : antialias := A_ADAPTIVE;
                       'q','Q' : antialias := A_QUICK;
                  else
                       ParseError(OptionStr);
                  end
                end;
      'w','W' : begin
                  tempstr := Copy(OptionStr,3,length(OptionStr));
                  val(tempstr,tempint,control);
                  if control=0
                     then
                        Image^.xres := tempint
                     else
                        ParseError(OptionStr);
                end;
      'h','H' : begin
                  tempstr := Copy(OptionStr,3,length(OptionStr));
                  val(tempstr,tempint,control);
                  if control=0
                     then
                        Image^.yres := tempint
                     else
                        ParseError(OptionStr);
                 end;
      's','S' : tickflag := false;

      else
                ParseError(OptionStr);
   end;
end;

procedure ParseFileName(OptionStr : string);

var
  Dir : DirStr;
  Name : NameStr;
  Ext  : ExtStr;

begin
  FSplit(OptionStr, Dir, Name, Ext);
  InFileName := Dir + Name + Ext;
  OutFileName := Dir + Name + '.tga';
end;

procedure ParseCommandLine;
var
  count : byte;
  dummystr : string;

begin
  InFileName := '';
  For count := 1 to ParamCount do
  begin
    DummyStr := ParamStr(count);
    If (DummyStr[1] = '-') or (DummyStr[2] = '/')
       then parseoption(DummyStr)
       else parsefilename(DummyStr);
  end;
  If InFileName = '' then usage;
end;

end.


