/* This file is part of the Project Athena Zephyr Notification System.
 * It contains code for the "zinit" command.
 *
 *	Created by:	Robert French
 *
 *	$Source: /mit/zephyr/src/clients/zinit/RCS/zinit.c,v $
 *	$Author: jtkohl $
 *
 *	Copyright (c) 1987 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */

#include <zephyr/mit-copyright.h>

#include <zephyr/zephyr.h>

#include <pwd.h>

#ifndef lint
static char rcsid_zinit_c[] = "$Header: zinit.c,v 1.8 89/06/29 12:09:15 jtkohl Exp $";
#endif lint

#define	OLD_ATTACHTAB	"/etc/attachtab"
#define	ATTACHTAB	"/usr/tmp/attachtab"
#define	OK_VNO		"A0"
#define	OK_VNO1		"A1"

void do_old(), do_new();
char *myname;

/*ARGSUSED*/
main(argc,argv)
	int argc;
	char *argv[];
{
	int retval;
	short port;
	FILE *fp;
	int old = 0;

	myname = argv[0];

	if ((retval = ZInitialize()) != ZERR_NONE) {
		com_err(myname,retval,"while initializing");
		exit(1);
	}

	if ((port = ZGetWGPort()) == -1) {
		com_err(myname,errno,"while getting WindowGram port");
		exit(1);
	} 
		
	fp = fopen(ATTACHTAB,"r");
	if (!fp) {
		if (!(fp = fopen(OLD_ATTACHTAB, "r")))
			exit(0);
		else
			old = 1;	/* old-style attachtab */
	}

	if (old)
		do_old(port,fp);
	else
		do_new(port,fp);
	(void) fclose(fp);
}

void
do_old(port, fp)
short port;
FILE *fp;
{
	char buf[BUFSIZ],type[BUFSIZ],hesname[BUFSIZ],pack[BUFSIZ];
	char host[BUFSIZ],ipaddr[BUFSIZ],mountpt[BUFSIZ],theclassinst[BUFSIZ];
	ZSubscription_t sub[2];
	int num, retval;

	while (fgets(buf,sizeof buf,fp) != (char *)0) {
		if (sscanf(buf,"%s %s %s %s %s %d %s %d",
			   type,hesname,pack,host,ipaddr,
			   &num,mountpt,&num) != 8)
			continue;
		(void) sprintf(theclassinst,"%s:%s",host,pack);
		sub[0].class = "filsrv";
		sub[0].classinst = host;
		sub[0].recipient = "*";
		sub[1].class = "filsrv";
		sub[1].classinst = theclassinst;
		sub[1].recipient = "*";
		if ((retval = ZSubscribeTo(sub,2,(u_short)port))
		    != ZERR_NONE) {
			com_err(myname,retval,"while subscribing");
			exit(1);
		}
	}
}

void
do_new(port, fp)
short port;
FILE *fp;
{
	char buf[BUFSIZ], theclassinst[BUFSIZ];
	char scratch[BUFSIZ], host[BUFSIZ], packname[BUFSIZ];
	int num, retval;
	ZSubscription_t sub[2];

	while (fgets(buf, sizeof buf, fp) != (char *) 0) {
		if (strncmp(OK_VNO, buf, sizeof(OK_VNO)-1) &&
		    strncmp(OK_VNO1, buf, sizeof(OK_VNO1)-1)) {
		    /* assume it's an old-type attachtab */
		    rewind(fp);
		    do_old(port,fp);
		    return;
		}
		if (strncmp("NFS", &buf[5], 3) && strncmp("RVD", &buf[5], 3)) {
		    fprintf(stderr,
			    "%s: unknown filesystem type in '%s'\n",
			    myname, buf);
		    exit(1);
		}
		/* it's an RVD or NFS filesystem */
		if (sscanf(buf, "%s %s %s %s %s %s %d %s %d %s",
			   scratch, scratch, scratch, host,
			   packname, scratch, &num, scratch,
			   &num, scratch) != 10)
			continue; /* busted entry; ignore */

		(void) sprintf(theclassinst,"%s:%s",host,packname);
		sub[0].class = "filsrv";
		sub[0].classinst = host;
		sub[0].recipient = "*";
		sub[1].class = "filsrv";
		sub[1].classinst = theclassinst;
		sub[1].recipient = "*";			
		if ((retval = ZSubscribeTo(sub,2,(u_short)port))
		    != ZERR_NONE) {
			com_err(myname,retval,"while subscribing");
			exit(1);
		}
	}
}
