/*
 *	GLOBDEFS.H
 *	 this C header file contains general definitions and declarations
 *	 for the IP/TCP/POP2 protocol server.
 *
 *      (C) Copyright 1991 Regents of the University of California
 *
 *      Permission to use, copy, modify, and distribute this program
 *      for any purpose and without fee is hereby granted, provided
 *      that this copyright and permission notice appear on all copies
 *      and supporting documentation, the name of University of California
 *      not be used in advertising or publicity pertaining to distribution
 *      of the program without specific prior permission, and notice be
 *      given in supporting documentation that copying and distribution is
 *      by permission of the University of California.
 *      The University of California makes no representations about
 *      the suitability of this software for any purpose.  It is provided
 *      "as is" without express or implied warranty.
 *
 *	*** VAX/UNIX  4.3BSD ***
 *	REVISIONS:
 *			12-87	[ks]	original implementation
 *		1.000	 5-88	[ks]
 *		1.001	 2-89	[ks]
 *
 */


#include <stdio.h>

#include <ctype.h>			/* UNIX/C definitions, etc */
#include <errno.h>
#include <signal.h>
#include <pwd.h>
#ifdef SHADOWPWD
#include <shadow/shadow.h>
#include <shadow/pwauth.h>
#endif
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

extern errno;				/* For handling of compiler err msgs */
extern int sys_nerr;
extern char *sys_errlist[];

#ifndef SHADOWPWD
extern char *crypt();			/* Forward declarations */
#endif
extern char *getpass();
extern char *malloc();
extern char *realloc();
extern char *strchr();
extern char *strrchr();

extern char *fgetl();

#define	EXIT_NORMAL	0x00		/* Normal exit status for UNIX */

#ifdef _toupper				/* Standardize toupper/lower handling */
#undef _toupper
#endif
#define _toupper(ch)   ((((ch) >= 'a') && ((ch) <= 'z')) ? (ch & 0xdf) : ch)

#ifdef _tolower
#undef _tolower
#endif
#define _tolower(ch)   ((((ch) >= 'A') && ((ch) <= 'Z')) ? (ch | 0x20) : ch)


#define VERSION		"1.001"		/* Rev strings */
#define REVDATE		"February, 1989"

/* #define DEBUG	1		 Comment out for no debug messages */
#define LOGFILE		"/tmp/pop2svr.log"
/* #define ALONE	1		 Comment out for use with inetd */

#define TRUE		-1		/* General utility constants */
#define FALSE		0
#define UNDEFINED	-1

#define NULL_CHAR	'\000'		/* ASCII character constants */
#define CTLC_CHAR	'\003'
#define BELL_CHAR	'\007'
#define BS_CHAR		'\010'
#define TAB_CHAR	'\011'
#define LF_CHAR		'\012'
#define FF_CHAR		'\014'
#define CR_CHAR		'\015'
#define CTLR_CHAR	'\022'
#define CTLU_CHAR	'\025'
#define ESC_CHAR	'\033'
#define CTLUS_CHAR	'\037'
#define SP_CHAR		'\040'
#define BANG_CHAR	'\041'
#define DQUOTE_CHAR	'\042'
#define POUND_CHAR	'\043'
#define DOLLAR_CHAR	'\044'
#define SQUOTE_CHAR	'\047'
#define LPAREN_CHAR	'\050'
#define RPAREN_CHAR	'\051'
#define STAR_CHAR	'\052'
#define PLUS_CHAR	'\053'
#define COMMA_CHAR	'\054'
#define DASH_CHAR	'\055'
#define DOT_CHAR	'\056'
#define SLASH_CHAR	'\057'
#define COLON_CHAR	'\072'
#define SEMI_CHAR	'\073'
#define LANKLE_CHAR	'\074'
#define RANKLE_CHAR	'\076'
#define QMARK_CHAR	'\077'
#define AT_CHAR		'\100'
#define LBRACK_CHAR	'\133'
#define BACKSL_CHAR	'\134'
#define RBRACK_CHAR	'\135'
#define YES_CHAR	'\171'
#define PIPE_CHAR	'\174'
#define DEL_CHAR	'\177'

#define NULLCHAR	(char *)0

	/* Variables needed by all phases of the simulator */
extern char	flash_buf[];		/* Very temp storage */


	/* Stucture definitions */
struct FLD_ENTRIES {
    long fhdr_entry;			/* Entry pt to BSMTP headers, if any */
    long fmsg_entry;			/* Entry pt to msg in file */
    char *pop_hdr;			/* RCPT header for POP2 client */
    long bcount;			/* # bytes in this message */
    int  status;			/* Status of this message */
};


	/* Macros to ease allocation of dynamic pointer arrays */
	/* Char pointer array */
#define get_c_array(a,m) {\
	a = (char **)malloc(sizeof(char *)*( (m) + 1));\
}

#define chk_c_size(a,m,i) {\
	if (  ( (i) ) && (!( (i) % (m) ))  ) {\
	    a = (char **)realloc( (a) ,(sizeof(char *)*( (i) + (m) +1)));\
	}\
}

	/* FLD_ENTRIES structure array */
#define get_e_array(a,m) {\
	a = (struct FLD_ENTRIES *)malloc(sizeof(struct FLD_ENTRIES)*( (m) +1));\
}

#define chk_e_size(a,m,i) {\
	if (  ( (i) ) && (!( (i) % (m) ))  ) {\
	    a = (struct FLD_ENTRIES *)realloc( (a) ,(sizeof(struct FLD_ENTRIES)*( (i) + (m) + 1)));\
	}\
}

