# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._azure_machine_learning_workspaces_enums import *


class Compute(msrest.serialization.Model):
    """Machine Learning compute object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AKS, AmlCompute, ComputeInstance, DataFactory, DataLakeAnalytics, Databricks, HDInsight, Kubernetes, SynapseSpark, VirtualMachine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AKS', 'AmlCompute': 'AmlCompute', 'ComputeInstance': 'ComputeInstance', 'DataFactory': 'DataFactory', 'DataLakeAnalytics': 'DataLakeAnalytics', 'Databricks': 'Databricks', 'HDInsight': 'HDInsight', 'Kubernetes': 'Kubernetes', 'SynapseSpark': 'SynapseSpark', 'VirtualMachine': 'VirtualMachine'}
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(Compute, self).__init__(**kwargs)
        self.compute_type = None  # type: Optional[str]
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class AKS(Compute):
    """A Machine Learning compute based on AKS.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar properties: AKS properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AKSProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'AKSProperties'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        properties: Optional["AKSProperties"] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword properties: AKS properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AKSProperties
        """
        super(AKS, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'AKS'  # type: str
        self.properties = properties


class AksComputeSecretsProperties(msrest.serialization.Model):
    """Properties of AksComputeSecrets.

    :ivar user_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype user_kube_config: str
    :ivar admin_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype admin_kube_config: str
    :ivar image_pull_secret_name: Image registry pull secret.
    :vartype image_pull_secret_name: str
    """

    _attribute_map = {
        'user_kube_config': {'key': 'userKubeConfig', 'type': 'str'},
        'admin_kube_config': {'key': 'adminKubeConfig', 'type': 'str'},
        'image_pull_secret_name': {'key': 'imagePullSecretName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_kube_config: Optional[str] = None,
        admin_kube_config: Optional[str] = None,
        image_pull_secret_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype user_kube_config: str
        :keyword admin_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype admin_kube_config: str
        :keyword image_pull_secret_name: Image registry pull secret.
        :paramtype image_pull_secret_name: str
        """
        super(AksComputeSecretsProperties, self).__init__(**kwargs)
        self.user_kube_config = user_kube_config
        self.admin_kube_config = admin_kube_config
        self.image_pull_secret_name = image_pull_secret_name


class ComputeSecrets(msrest.serialization.Model):
    """Secrets related to a Machine Learning compute. Might differ for every type of compute.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AksComputeSecrets, DatabricksComputeSecrets, VirtualMachineSecrets.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AksComputeSecrets', 'Databricks': 'DatabricksComputeSecrets', 'VirtualMachine': 'VirtualMachineSecrets'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ComputeSecrets, self).__init__(**kwargs)
        self.compute_type = None  # type: Optional[str]


class AksComputeSecrets(ComputeSecrets, AksComputeSecretsProperties):
    """Secrets related to a Machine Learning compute based on AKS.

    All required parameters must be populated in order to send to Azure.

    :ivar user_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype user_kube_config: str
    :ivar admin_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :vartype admin_kube_config: str
    :ivar image_pull_secret_name: Image registry pull secret.
    :vartype image_pull_secret_name: str
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'user_kube_config': {'key': 'userKubeConfig', 'type': 'str'},
        'admin_kube_config': {'key': 'adminKubeConfig', 'type': 'str'},
        'image_pull_secret_name': {'key': 'imagePullSecretName', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_kube_config: Optional[str] = None,
        admin_kube_config: Optional[str] = None,
        image_pull_secret_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype user_kube_config: str
        :keyword admin_kube_config: Content of kubeconfig file that can be used to connect to the
         Kubernetes cluster.
        :paramtype admin_kube_config: str
        :keyword image_pull_secret_name: Image registry pull secret.
        :paramtype image_pull_secret_name: str
        """
        super(AksComputeSecrets, self).__init__(user_kube_config=user_kube_config, admin_kube_config=admin_kube_config, image_pull_secret_name=image_pull_secret_name, **kwargs)
        self.user_kube_config = user_kube_config
        self.admin_kube_config = admin_kube_config
        self.image_pull_secret_name = image_pull_secret_name
        self.compute_type = 'AKS'  # type: str
        self.compute_type = 'AKS'  # type: str


class AksNetworkingConfiguration(msrest.serialization.Model):
    """Advance configuration for AKS networking.

    :ivar subnet_id: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet_id: str
    :ivar service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :vartype service_cidr: str
    :ivar dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :vartype dns_service_ip: str
    :ivar docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :vartype docker_bridge_cidr: str
    """

    _validation = {
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        service_cidr: Optional[str] = None,
        dns_service_ip: Optional[str] = None,
        docker_bridge_cidr: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword subnet_id: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet_id: str
        :keyword service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It
         must not overlap with any Subnet IP ranges.
        :paramtype service_cidr: str
        :keyword dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be
         within the Kubernetes service address range specified in serviceCidr.
        :paramtype dns_service_ip: str
        :keyword docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
         must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :paramtype docker_bridge_cidr: str
        """
        super(AksNetworkingConfiguration, self).__init__(**kwargs)
        self.subnet_id = subnet_id
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.docker_bridge_cidr = docker_bridge_cidr


class AKSProperties(msrest.serialization.Model):
    """AKS properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cluster_fqdn: Cluster full qualified domain name.
    :vartype cluster_fqdn: str
    :ivar system_services: System services.
    :vartype system_services: list[~azure.mgmt.machinelearningservices.models.SystemService]
    :ivar agent_count: Number of agents.
    :vartype agent_count: int
    :ivar agent_vm_size: Agent virtual machine size.
    :vartype agent_vm_size: str
    :ivar cluster_purpose: Intended usage of the cluster. Possible values include: "FastProd",
     "DenseProd", "DevTest". Default value: "FastProd".
    :vartype cluster_purpose: str or ~azure.mgmt.machinelearningservices.models.ClusterPurpose
    :ivar ssl_configuration: SSL configuration.
    :vartype ssl_configuration: ~azure.mgmt.machinelearningservices.models.SslConfiguration
    :ivar aks_networking_configuration: AKS networking configuration for vnet.
    :vartype aks_networking_configuration:
     ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
    :ivar load_balancer_type: Load Balancer Type. Possible values include: "PublicIp",
     "InternalLoadBalancer". Default value: "PublicIp".
    :vartype load_balancer_type: str or ~azure.mgmt.machinelearningservices.models.LoadBalancerType
    :ivar load_balancer_subnet: Load Balancer Subnet.
    :vartype load_balancer_subnet: str
    """

    _validation = {
        'system_services': {'readonly': True},
        'agent_count': {'minimum': 0},
    }

    _attribute_map = {
        'cluster_fqdn': {'key': 'clusterFqdn', 'type': 'str'},
        'system_services': {'key': 'systemServices', 'type': '[SystemService]'},
        'agent_count': {'key': 'agentCount', 'type': 'int'},
        'agent_vm_size': {'key': 'agentVmSize', 'type': 'str'},
        'cluster_purpose': {'key': 'clusterPurpose', 'type': 'str'},
        'ssl_configuration': {'key': 'sslConfiguration', 'type': 'SslConfiguration'},
        'aks_networking_configuration': {'key': 'aksNetworkingConfiguration', 'type': 'AksNetworkingConfiguration'},
        'load_balancer_type': {'key': 'loadBalancerType', 'type': 'str'},
        'load_balancer_subnet': {'key': 'loadBalancerSubnet', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        cluster_fqdn: Optional[str] = None,
        agent_count: Optional[int] = None,
        agent_vm_size: Optional[str] = None,
        cluster_purpose: Optional[Union[str, "ClusterPurpose"]] = "FastProd",
        ssl_configuration: Optional["SslConfiguration"] = None,
        aks_networking_configuration: Optional["AksNetworkingConfiguration"] = None,
        load_balancer_type: Optional[Union[str, "LoadBalancerType"]] = "PublicIp",
        load_balancer_subnet: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cluster_fqdn: Cluster full qualified domain name.
        :paramtype cluster_fqdn: str
        :keyword agent_count: Number of agents.
        :paramtype agent_count: int
        :keyword agent_vm_size: Agent virtual machine size.
        :paramtype agent_vm_size: str
        :keyword cluster_purpose: Intended usage of the cluster. Possible values include: "FastProd",
         "DenseProd", "DevTest". Default value: "FastProd".
        :paramtype cluster_purpose: str or ~azure.mgmt.machinelearningservices.models.ClusterPurpose
        :keyword ssl_configuration: SSL configuration.
        :paramtype ssl_configuration: ~azure.mgmt.machinelearningservices.models.SslConfiguration
        :keyword aks_networking_configuration: AKS networking configuration for vnet.
        :paramtype aks_networking_configuration:
         ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
        :keyword load_balancer_type: Load Balancer Type. Possible values include: "PublicIp",
         "InternalLoadBalancer". Default value: "PublicIp".
        :paramtype load_balancer_type: str or
         ~azure.mgmt.machinelearningservices.models.LoadBalancerType
        :keyword load_balancer_subnet: Load Balancer Subnet.
        :paramtype load_balancer_subnet: str
        """
        super(AKSProperties, self).__init__(**kwargs)
        self.cluster_fqdn = cluster_fqdn
        self.system_services = None
        self.agent_count = agent_count
        self.agent_vm_size = agent_vm_size
        self.cluster_purpose = cluster_purpose
        self.ssl_configuration = ssl_configuration
        self.aks_networking_configuration = aks_networking_configuration
        self.load_balancer_type = load_balancer_type
        self.load_balancer_subnet = load_balancer_subnet


class AmlCompute(Compute):
    """Properties(top level) of AmlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar properties: Properties of AmlCompute.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'AmlComputeProperties'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        properties: Optional["AmlComputeProperties"] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword properties: Properties of AmlCompute.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
        """
        super(AmlCompute, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'AmlCompute'  # type: str
        self.properties = properties


class AmlComputeNodeInformation(msrest.serialization.Model):
    """Compute node information related to a AmlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar node_id: ID of the compute node.
    :vartype node_id: str
    :ivar private_ip_address: Private IP address of the compute node.
    :vartype private_ip_address: str
    :ivar public_ip_address: Public IP address of the compute node.
    :vartype public_ip_address: str
    :ivar port: SSH port number of the node.
    :vartype port: int
    :ivar node_state: State of the compute node. Values are idle, running, preparing, unusable,
     leaving and preempted. Possible values include: "idle", "running", "preparing", "unusable",
     "leaving", "preempted".
    :vartype node_state: str or ~azure.mgmt.machinelearningservices.models.NodeState
    :ivar run_id: ID of the Experiment running on the node, if any else null.
    :vartype run_id: str
    """

    _validation = {
        'node_id': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'port': {'readonly': True},
        'node_state': {'readonly': True},
        'run_id': {'readonly': True},
    }

    _attribute_map = {
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'node_state': {'key': 'nodeState', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlComputeNodeInformation, self).__init__(**kwargs)
        self.node_id = None
        self.private_ip_address = None
        self.public_ip_address = None
        self.port = None
        self.node_state = None
        self.run_id = None


class AmlComputeNodesInformation(msrest.serialization.Model):
    """Result of AmlCompute Nodes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nodes: The collection of returned AmlCompute nodes details.
    :vartype nodes: list[~azure.mgmt.machinelearningservices.models.AmlComputeNodeInformation]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _validation = {
        'nodes': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'nodes': {'key': 'nodes', 'type': '[AmlComputeNodeInformation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AmlComputeNodesInformation, self).__init__(**kwargs)
        self.nodes = None
        self.next_link = None


class AmlComputeProperties(msrest.serialization.Model):
    """AML Compute properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar os_type: Compute OS Type. Possible values include: "Linux", "Windows". Default value:
     "Linux".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.OsType
    :ivar vm_size: Virtual Machine Size.
    :vartype vm_size: str
    :ivar vm_priority: Virtual Machine priority. Possible values include: "Dedicated",
     "LowPriority".
    :vartype vm_priority: str or ~azure.mgmt.machinelearningservices.models.VmPriority
    :ivar virtual_machine_image: Virtual Machine image for AML Compute - windows only.
    :vartype virtual_machine_image: ~azure.mgmt.machinelearningservices.models.VirtualMachineImage
    :ivar isolated_network: Network is isolated or not.
    :vartype isolated_network: bool
    :ivar scale_settings: Scale settings for AML Compute.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
    :ivar user_account_credentials: Credentials for an administrator user account that will be
     created on each compute node.
    :vartype user_account_credentials:
     ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
    :ivar subnet: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :ivar remote_login_port_public_access: State of the public SSH port. Possible values are:
     Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled -
     Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified -
     Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined,
     else is open all public nodes. It can be default only during cluster creation time, after
     creation it will be either enabled or disabled. Possible values include: "Enabled", "Disabled",
     "NotSpecified". Default value: "NotSpecified".
    :vartype remote_login_port_public_access: str or
     ~azure.mgmt.machinelearningservices.models.RemoteLoginPortPublicAccess
    :ivar allocation_state: Allocation state of the compute. Possible values are: steady -
     Indicates that the compute is not resizing. There are no changes to the number of compute nodes
     in the compute in progress. A compute enters this state when it is created and when no
     operations are being performed on the compute to change the number of compute nodes. resizing -
     Indicates that the compute is resizing; that is, compute nodes are being added to or removed
     from the compute. Possible values include: "Steady", "Resizing".
    :vartype allocation_state: str or ~azure.mgmt.machinelearningservices.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the compute entered its current
     allocation state.
    :vartype allocation_state_transition_time: ~datetime.datetime
    :ivar errors: Collection of errors encountered by various compute nodes during node setup.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar current_node_count: The number of compute nodes currently assigned to the compute.
    :vartype current_node_count: int
    :ivar target_node_count: The target number of compute nodes for the compute. If the
     allocationState is resizing, this property denotes the target node count for the ongoing resize
     operation. If the allocationState is steady, this property denotes the target node count for
     the previous resize operation.
    :vartype target_node_count: int
    :ivar node_state_counts: Counts of various node states on the compute.
    :vartype node_state_counts: ~azure.mgmt.machinelearningservices.models.NodeStateCounts
    :ivar enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
     values are: Possible values are: true - Indicates that the compute nodes will have public IPs
     provisioned. false - Indicates that the compute nodes will have a private endpoint and no
     public IPs.
    :vartype enable_node_public_ip: bool
    """

    _validation = {
        'allocation_state': {'readonly': True},
        'allocation_state_transition_time': {'readonly': True},
        'errors': {'readonly': True},
        'current_node_count': {'readonly': True},
        'target_node_count': {'readonly': True},
        'node_state_counts': {'readonly': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'vm_priority': {'key': 'vmPriority', 'type': 'str'},
        'virtual_machine_image': {'key': 'virtualMachineImage', 'type': 'VirtualMachineImage'},
        'isolated_network': {'key': 'isolatedNetwork', 'type': 'bool'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'ScaleSettings'},
        'user_account_credentials': {'key': 'userAccountCredentials', 'type': 'UserAccountCredentials'},
        'subnet': {'key': 'subnet', 'type': 'ResourceId'},
        'remote_login_port_public_access': {'key': 'remoteLoginPortPublicAccess', 'type': 'str'},
        'allocation_state': {'key': 'allocationState', 'type': 'str'},
        'allocation_state_transition_time': {'key': 'allocationStateTransitionTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'current_node_count': {'key': 'currentNodeCount', 'type': 'int'},
        'target_node_count': {'key': 'targetNodeCount', 'type': 'int'},
        'node_state_counts': {'key': 'nodeStateCounts', 'type': 'NodeStateCounts'},
        'enable_node_public_ip': {'key': 'enableNodePublicIp', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        os_type: Optional[Union[str, "OsType"]] = "Linux",
        vm_size: Optional[str] = None,
        vm_priority: Optional[Union[str, "VmPriority"]] = None,
        virtual_machine_image: Optional["VirtualMachineImage"] = None,
        isolated_network: Optional[bool] = None,
        scale_settings: Optional["ScaleSettings"] = None,
        user_account_credentials: Optional["UserAccountCredentials"] = None,
        subnet: Optional["ResourceId"] = None,
        remote_login_port_public_access: Optional[Union[str, "RemoteLoginPortPublicAccess"]] = "NotSpecified",
        enable_node_public_ip: Optional[bool] = True,
        **kwargs
    ):
        """
        :keyword os_type: Compute OS Type. Possible values include: "Linux", "Windows". Default value:
         "Linux".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.OsType
        :keyword vm_size: Virtual Machine Size.
        :paramtype vm_size: str
        :keyword vm_priority: Virtual Machine priority. Possible values include: "Dedicated",
         "LowPriority".
        :paramtype vm_priority: str or ~azure.mgmt.machinelearningservices.models.VmPriority
        :keyword virtual_machine_image: Virtual Machine image for AML Compute - windows only.
        :paramtype virtual_machine_image:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineImage
        :keyword isolated_network: Network is isolated or not.
        :paramtype isolated_network: bool
        :keyword scale_settings: Scale settings for AML Compute.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
        :keyword user_account_credentials: Credentials for an administrator user account that will be
         created on each compute node.
        :paramtype user_account_credentials:
         ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
        :keyword subnet: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
        :keyword remote_login_port_public_access: State of the public SSH port. Possible values are:
         Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled -
         Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified -
         Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined,
         else is open all public nodes. It can be default only during cluster creation time, after
         creation it will be either enabled or disabled. Possible values include: "Enabled", "Disabled",
         "NotSpecified". Default value: "NotSpecified".
        :paramtype remote_login_port_public_access: str or
         ~azure.mgmt.machinelearningservices.models.RemoteLoginPortPublicAccess
        :keyword enable_node_public_ip: Enable or disable node public IP address provisioning. Possible
         values are: Possible values are: true - Indicates that the compute nodes will have public IPs
         provisioned. false - Indicates that the compute nodes will have a private endpoint and no
         public IPs.
        :paramtype enable_node_public_ip: bool
        """
        super(AmlComputeProperties, self).__init__(**kwargs)
        self.os_type = os_type
        self.vm_size = vm_size
        self.vm_priority = vm_priority
        self.virtual_machine_image = virtual_machine_image
        self.isolated_network = isolated_network
        self.scale_settings = scale_settings
        self.user_account_credentials = user_account_credentials
        self.subnet = subnet
        self.remote_login_port_public_access = remote_login_port_public_access
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.errors = None
        self.current_node_count = None
        self.target_node_count = None
        self.node_state_counts = None
        self.enable_node_public_ip = enable_node_public_ip


class AmlUserFeature(msrest.serialization.Model):
    """Features enabled for a workspace.

    :ivar id: Specifies the feature ID.
    :vartype id: str
    :ivar display_name: Specifies the feature name.
    :vartype display_name: str
    :ivar description: Describes the feature for user experience.
    :vartype description: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Specifies the feature ID.
        :paramtype id: str
        :keyword display_name: Specifies the feature name.
        :paramtype display_name: str
        :keyword description: Describes the feature for user experience.
        :paramtype description: str
        """
        super(AmlUserFeature, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.description = description


class AssignedUser(msrest.serialization.Model):
    """A user that can be assigned to a compute instance.

    All required parameters must be populated in order to send to Azure.

    :ivar object_id: Required. User’s AAD Object Id.
    :vartype object_id: str
    :ivar tenant_id: Required. User’s AAD Tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        'object_id': {'required': True},
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        object_id: str,
        tenant_id: str,
        **kwargs
    ):
        """
        :keyword object_id: Required. User’s AAD Object Id.
        :paramtype object_id: str
        :keyword tenant_id: Required. User’s AAD Tenant Id.
        :paramtype tenant_id: str
        """
        super(AssignedUser, self).__init__(**kwargs)
        self.object_id = object_id
        self.tenant_id = tenant_id


class AutoPauseProperties(msrest.serialization.Model):
    """Auto pause properties.

    :ivar delay_in_minutes:
    :vartype delay_in_minutes: int
    :ivar enabled:
    :vartype enabled: bool
    """

    _attribute_map = {
        'delay_in_minutes': {'key': 'delayInMinutes', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        delay_in_minutes: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword delay_in_minutes:
        :paramtype delay_in_minutes: int
        :keyword enabled:
        :paramtype enabled: bool
        """
        super(AutoPauseProperties, self).__init__(**kwargs)
        self.delay_in_minutes = delay_in_minutes
        self.enabled = enabled


class AutoScaleProperties(msrest.serialization.Model):
    """Auto scale properties.

    :ivar min_node_count:
    :vartype min_node_count: int
    :ivar enabled:
    :vartype enabled: bool
    :ivar max_node_count:
    :vartype max_node_count: int
    """

    _attribute_map = {
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_node_count: Optional[int] = None,
        enabled: Optional[bool] = None,
        max_node_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword min_node_count:
        :paramtype min_node_count: int
        :keyword enabled:
        :paramtype enabled: bool
        :keyword max_node_count:
        :paramtype max_node_count: int
        """
        super(AutoScaleProperties, self).__init__(**kwargs)
        self.min_node_count = min_node_count
        self.enabled = enabled
        self.max_node_count = max_node_count


class ClusterUpdateParameters(msrest.serialization.Model):
    """AmlCompute update parameters.

    :ivar properties: Properties of ClusterUpdate.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ScaleSettingsInformation
    """

    _attribute_map = {
        'properties': {'key': 'properties.properties', 'type': 'ScaleSettingsInformation'},
    }

    def __init__(
        self,
        *,
        properties: Optional["ScaleSettingsInformation"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of ClusterUpdate.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ScaleSettingsInformation
        """
        super(ClusterUpdateParameters, self).__init__(**kwargs)
        self.properties = properties


class Components1D3SwueSchemasComputeresourceAllof1(msrest.serialization.Model):
    """Components1D3SwueSchemasComputeresourceAllof1.

    :ivar properties: Compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.Compute
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'Compute'},
    }

    def __init__(
        self,
        *,
        properties: Optional["Compute"] = None,
        **kwargs
    ):
        """
        :keyword properties: Compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.Compute
        """
        super(Components1D3SwueSchemasComputeresourceAllof1, self).__init__(**kwargs)
        self.properties = properties


class ComputeInstance(Compute):
    """Properties(top level) of ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar properties: Properties of ComputeInstance.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'ComputeInstanceProperties'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        properties: Optional["ComputeInstanceProperties"] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword properties: Properties of ComputeInstance.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
        """
        super(ComputeInstance, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'ComputeInstance'  # type: str
        self.properties = properties


class ComputeInstanceApplication(msrest.serialization.Model):
    """Defines an Aml Instance application and its connectivity endpoint URI.

    :ivar display_name: Name of the ComputeInstance application.
    :vartype display_name: str
    :ivar endpoint_uri: Application' endpoint URI.
    :vartype endpoint_uri: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Name of the ComputeInstance application.
        :paramtype display_name: str
        :keyword endpoint_uri: Application' endpoint URI.
        :paramtype endpoint_uri: str
        """
        super(ComputeInstanceApplication, self).__init__(**kwargs)
        self.display_name = display_name
        self.endpoint_uri = endpoint_uri


class ComputeInstanceConnectivityEndpoints(msrest.serialization.Model):
    """Defines all connectivity endpoints and properties for an ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_ip_address: Public IP Address of this ComputeInstance.
    :vartype public_ip_address: str
    :ivar private_ip_address: Private IP Address of this ComputeInstance (local to the VNET in
     which the compute instance is deployed).
    :vartype private_ip_address: str
    """

    _validation = {
        'public_ip_address': {'readonly': True},
        'private_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ComputeInstanceConnectivityEndpoints, self).__init__(**kwargs)
        self.public_ip_address = None
        self.private_ip_address = None


class ComputeInstanceCreatedBy(msrest.serialization.Model):
    """Describes information on user who created this ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_name: Name of the user.
    :vartype user_name: str
    :ivar user_org_id: Uniquely identifies user' Azure Active Directory organization.
    :vartype user_org_id: str
    :ivar user_id: Uniquely identifies the user within his/her organization.
    :vartype user_id: str
    """

    _validation = {
        'user_name': {'readonly': True},
        'user_org_id': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'user_org_id': {'key': 'userOrgId', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ComputeInstanceCreatedBy, self).__init__(**kwargs)
        self.user_name = None
        self.user_org_id = None
        self.user_id = None


class ComputeInstanceLastOperation(msrest.serialization.Model):
    """The last operation on ComputeInstance.

    :ivar operation_name: Name of the last operation. Possible values include: "Create", "Start",
     "Stop", "Restart", "Reimage", "Delete".
    :vartype operation_name: str or ~azure.mgmt.machinelearningservices.models.OperationName
    :ivar operation_time: Time of the last operation.
    :vartype operation_time: ~datetime.datetime
    :ivar operation_status: Operation status. Possible values include: "InProgress", "Succeeded",
     "CreateFailed", "StartFailed", "StopFailed", "RestartFailed", "ReimageFailed", "DeleteFailed".
    :vartype operation_status: str or ~azure.mgmt.machinelearningservices.models.OperationStatus
    """

    _attribute_map = {
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'operation_time': {'key': 'operationTime', 'type': 'iso-8601'},
        'operation_status': {'key': 'operationStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_name: Optional[Union[str, "OperationName"]] = None,
        operation_time: Optional[datetime.datetime] = None,
        operation_status: Optional[Union[str, "OperationStatus"]] = None,
        **kwargs
    ):
        """
        :keyword operation_name: Name of the last operation. Possible values include: "Create",
         "Start", "Stop", "Restart", "Reimage", "Delete".
        :paramtype operation_name: str or ~azure.mgmt.machinelearningservices.models.OperationName
        :keyword operation_time: Time of the last operation.
        :paramtype operation_time: ~datetime.datetime
        :keyword operation_status: Operation status. Possible values include: "InProgress",
         "Succeeded", "CreateFailed", "StartFailed", "StopFailed", "RestartFailed", "ReimageFailed",
         "DeleteFailed".
        :paramtype operation_status: str or ~azure.mgmt.machinelearningservices.models.OperationStatus
        """
        super(ComputeInstanceLastOperation, self).__init__(**kwargs)
        self.operation_name = operation_name
        self.operation_time = operation_time
        self.operation_status = operation_status


class ComputeInstanceProperties(msrest.serialization.Model):
    """Compute Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_size: Virtual Machine Size.
    :vartype vm_size: str
    :ivar subnet: Virtual network subnet resource ID the compute nodes belong to.
    :vartype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :ivar application_sharing_policy: Policy for sharing applications on this compute instance
     among users of parent workspace. If Personal, only the creator can access applications on this
     compute instance. When Shared, any workspace user can access applications on this instance
     depending on his/her assigned role. Possible values include: "Personal", "Shared". Default
     value: "Shared".
    :vartype application_sharing_policy: str or
     ~azure.mgmt.machinelearningservices.models.ApplicationSharingPolicy
    :ivar ssh_settings: Specifies policy and settings for SSH access.
    :vartype ssh_settings: ~azure.mgmt.machinelearningservices.models.ComputeInstanceSshSettings
    :ivar connectivity_endpoints: Describes all connectivity endpoints available for this
     ComputeInstance.
    :vartype connectivity_endpoints:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceConnectivityEndpoints
    :ivar applications: Describes available applications and their endpoints on this
     ComputeInstance.
    :vartype applications:
     list[~azure.mgmt.machinelearningservices.models.ComputeInstanceApplication]
    :ivar created_by: Describes information on user who created this ComputeInstance.
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.ComputeInstanceCreatedBy
    :ivar errors: Collection of errors encountered on this ComputeInstance.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar state: The current state of this ComputeInstance. Possible values include: "Creating",
     "CreateFailed", "Deleting", "Running", "Restarting", "JobRunning", "SettingUp", "SetupFailed",
     "Starting", "Stopped", "Stopping", "UserSettingUp", "UserSetupFailed", "Unknown", "Unusable".
    :vartype state: str or ~azure.mgmt.machinelearningservices.models.ComputeInstanceState
    :ivar compute_instance_authorization_type: The Compute Instance Authorization type. Available
     values are personal (default). Possible values include: "personal". Default value: "personal".
    :vartype compute_instance_authorization_type: str or
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceAuthorizationType
    :ivar personal_compute_instance_settings: Settings for a personal compute instance.
    :vartype personal_compute_instance_settings:
     ~azure.mgmt.machinelearningservices.models.PersonalComputeInstanceSettings
    :ivar setup_scripts: Details of customized scripts to execute for setting up the cluster.
    :vartype setup_scripts: ~azure.mgmt.machinelearningservices.models.SetupScripts
    :ivar last_operation: The last operation on ComputeInstance.
    :vartype last_operation:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceLastOperation
    :ivar schedules: The list of schedules to be applied on the compute instance.
    :vartype schedules: ~azure.mgmt.machinelearningservices.models.ComputeSchedules
    """

    _validation = {
        'connectivity_endpoints': {'readonly': True},
        'applications': {'readonly': True},
        'created_by': {'readonly': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'last_operation': {'readonly': True},
    }

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'ResourceId'},
        'application_sharing_policy': {'key': 'applicationSharingPolicy', 'type': 'str'},
        'ssh_settings': {'key': 'sshSettings', 'type': 'ComputeInstanceSshSettings'},
        'connectivity_endpoints': {'key': 'connectivityEndpoints', 'type': 'ComputeInstanceConnectivityEndpoints'},
        'applications': {'key': 'applications', 'type': '[ComputeInstanceApplication]'},
        'created_by': {'key': 'createdBy', 'type': 'ComputeInstanceCreatedBy'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'state': {'key': 'state', 'type': 'str'},
        'compute_instance_authorization_type': {'key': 'computeInstanceAuthorizationType', 'type': 'str'},
        'personal_compute_instance_settings': {'key': 'personalComputeInstanceSettings', 'type': 'PersonalComputeInstanceSettings'},
        'setup_scripts': {'key': 'setupScripts', 'type': 'SetupScripts'},
        'last_operation': {'key': 'lastOperation', 'type': 'ComputeInstanceLastOperation'},
        'schedules': {'key': 'schedules', 'type': 'ComputeSchedules'},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[str] = None,
        subnet: Optional["ResourceId"] = None,
        application_sharing_policy: Optional[Union[str, "ApplicationSharingPolicy"]] = "Shared",
        ssh_settings: Optional["ComputeInstanceSshSettings"] = None,
        compute_instance_authorization_type: Optional[Union[str, "ComputeInstanceAuthorizationType"]] = "personal",
        personal_compute_instance_settings: Optional["PersonalComputeInstanceSettings"] = None,
        setup_scripts: Optional["SetupScripts"] = None,
        schedules: Optional["ComputeSchedules"] = None,
        **kwargs
    ):
        """
        :keyword vm_size: Virtual Machine Size.
        :paramtype vm_size: str
        :keyword subnet: Virtual network subnet resource ID the compute nodes belong to.
        :paramtype subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
        :keyword application_sharing_policy: Policy for sharing applications on this compute instance
         among users of parent workspace. If Personal, only the creator can access applications on this
         compute instance. When Shared, any workspace user can access applications on this instance
         depending on his/her assigned role. Possible values include: "Personal", "Shared". Default
         value: "Shared".
        :paramtype application_sharing_policy: str or
         ~azure.mgmt.machinelearningservices.models.ApplicationSharingPolicy
        :keyword ssh_settings: Specifies policy and settings for SSH access.
        :paramtype ssh_settings: ~azure.mgmt.machinelearningservices.models.ComputeInstanceSshSettings
        :keyword compute_instance_authorization_type: The Compute Instance Authorization type.
         Available values are personal (default). Possible values include: "personal". Default value:
         "personal".
        :paramtype compute_instance_authorization_type: str or
         ~azure.mgmt.machinelearningservices.models.ComputeInstanceAuthorizationType
        :keyword personal_compute_instance_settings: Settings for a personal compute instance.
        :paramtype personal_compute_instance_settings:
         ~azure.mgmt.machinelearningservices.models.PersonalComputeInstanceSettings
        :keyword setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :paramtype setup_scripts: ~azure.mgmt.machinelearningservices.models.SetupScripts
        :keyword schedules: The list of schedules to be applied on the compute instance.
        :paramtype schedules: ~azure.mgmt.machinelearningservices.models.ComputeSchedules
        """
        super(ComputeInstanceProperties, self).__init__(**kwargs)
        self.vm_size = vm_size
        self.subnet = subnet
        self.application_sharing_policy = application_sharing_policy
        self.ssh_settings = ssh_settings
        self.connectivity_endpoints = None
        self.applications = None
        self.created_by = None
        self.errors = None
        self.state = None
        self.compute_instance_authorization_type = compute_instance_authorization_type
        self.personal_compute_instance_settings = personal_compute_instance_settings
        self.setup_scripts = setup_scripts
        self.last_operation = None
        self.schedules = schedules


class ComputeInstanceSshSettings(msrest.serialization.Model):
    """Specifies policy and settings for SSH access.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ssh_public_access: State of the public SSH port. Possible values are: Disabled -
     Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the
     public ssh port is open and accessible according to the VNet/subnet policy if applicable.
     Possible values include: "Enabled", "Disabled". Default value: "Disabled".
    :vartype ssh_public_access: str or ~azure.mgmt.machinelearningservices.models.SshPublicAccess
    :ivar admin_user_name: Describes the admin user name.
    :vartype admin_user_name: str
    :ivar ssh_port: Describes the port for connecting through SSH.
    :vartype ssh_port: int
    :ivar admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t
     rsa -b 2048" to generate your SSH key pairs.
    :vartype admin_public_key: str
    """

    _validation = {
        'admin_user_name': {'readonly': True},
        'ssh_port': {'readonly': True},
    }

    _attribute_map = {
        'ssh_public_access': {'key': 'sshPublicAccess', 'type': 'str'},
        'admin_user_name': {'key': 'adminUserName', 'type': 'str'},
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'admin_public_key': {'key': 'adminPublicKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ssh_public_access: Optional[Union[str, "SshPublicAccess"]] = "Disabled",
        admin_public_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword ssh_public_access: State of the public SSH port. Possible values are: Disabled -
         Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the
         public ssh port is open and accessible according to the VNet/subnet policy if applicable.
         Possible values include: "Enabled", "Disabled". Default value: "Disabled".
        :paramtype ssh_public_access: str or ~azure.mgmt.machinelearningservices.models.SshPublicAccess
        :keyword admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen
         -t rsa -b 2048" to generate your SSH key pairs.
        :paramtype admin_public_key: str
        """
        super(ComputeInstanceSshSettings, self).__init__(**kwargs)
        self.ssh_public_access = ssh_public_access
        self.admin_user_name = None
        self.ssh_port = None
        self.admin_public_key = admin_public_key


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ComputeResource(Resource, Components1D3SwueSchemasComputeresourceAllof1):
    """Machine Learning compute object wrapped into ARM resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.Compute
    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.Identity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar system_data: System data.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'Compute'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        properties: Optional["Compute"] = None,
        identity: Optional["Identity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        """
        :keyword properties: Compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.Compute
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.Identity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: A set of tags. Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        """
        super(ComputeResource, self).__init__(properties=properties, **kwargs)
        self.properties = properties
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.system_data = None
        self.id = None
        self.name = None
        self.type = None
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.system_data = None


class ComputeSchedules(msrest.serialization.Model):
    """The list of schedules to be applied on the computes.

    :ivar compute_start_stop: The list of compute start stop schedules to be applied.
    :vartype compute_start_stop:
     list[~azure.mgmt.machinelearningservices.models.ComputeStartStopSchedule]
    """

    _attribute_map = {
        'compute_start_stop': {'key': 'computeStartStop', 'type': '[ComputeStartStopSchedule]'},
    }

    def __init__(
        self,
        *,
        compute_start_stop: Optional[List["ComputeStartStopSchedule"]] = None,
        **kwargs
    ):
        """
        :keyword compute_start_stop: The list of compute start stop schedules to be applied.
        :paramtype compute_start_stop:
         list[~azure.mgmt.machinelearningservices.models.ComputeStartStopSchedule]
        """
        super(ComputeSchedules, self).__init__(**kwargs)
        self.compute_start_stop = compute_start_stop


class ComputeStartStopSchedule(msrest.serialization.Model):
    """Compute start stop schedule properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Schedule id.
    :vartype id: str
    :ivar provisioning_status: The current deployment state of schedule. Possible values include:
     "Completed", "Provisioning", "Failed".
    :vartype provisioning_status: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningStatus
    :ivar status: The schedule status. Possible values include: "Enabled", "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
    :ivar trigger_type: The schedule trigger type. Possible values include: "Recurrence", "Cron".
    :vartype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
    :ivar action: The compute power action. Possible values include: "Start", "Stop".
    :vartype action: str or ~azure.mgmt.machinelearningservices.models.ComputePowerAction
    :ivar recurrence: The workflow trigger recurrence for ComputeStartStop schedule type.
    :vartype recurrence: ~azure.mgmt.machinelearningservices.models.Recurrence
    :ivar cron: The workflow trigger cron for ComputeStartStop schedule type.
    :vartype cron: ~azure.mgmt.machinelearningservices.models.Cron
    """

    _validation = {
        'id': {'readonly': True},
        'provisioning_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_status': {'key': 'provisioningStatus', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'recurrence': {'key': 'recurrence', 'type': 'Recurrence'},
        'cron': {'key': 'cron', 'type': 'Cron'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "ScheduleStatus"]] = None,
        trigger_type: Optional[Union[str, "TriggerType"]] = None,
        action: Optional[Union[str, "ComputePowerAction"]] = None,
        recurrence: Optional["Recurrence"] = None,
        cron: Optional["Cron"] = None,
        **kwargs
    ):
        """
        :keyword status: The schedule status. Possible values include: "Enabled", "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.ScheduleStatus
        :keyword trigger_type: The schedule trigger type. Possible values include: "Recurrence",
         "Cron".
        :paramtype trigger_type: str or ~azure.mgmt.machinelearningservices.models.TriggerType
        :keyword action: The compute power action. Possible values include: "Start", "Stop".
        :paramtype action: str or ~azure.mgmt.machinelearningservices.models.ComputePowerAction
        :keyword recurrence: The workflow trigger recurrence for ComputeStartStop schedule type.
        :paramtype recurrence: ~azure.mgmt.machinelearningservices.models.Recurrence
        :keyword cron: The workflow trigger cron for ComputeStartStop schedule type.
        :paramtype cron: ~azure.mgmt.machinelearningservices.models.Cron
        """
        super(ComputeStartStopSchedule, self).__init__(**kwargs)
        self.id = None
        self.provisioning_status = None
        self.status = status
        self.trigger_type = trigger_type
        self.action = action
        self.recurrence = recurrence
        self.cron = cron


class ContainerResourceRequirements(msrest.serialization.Model):
    """The resource requirements for the container (cpu and memory).

    :ivar cpu: The minimum amount of CPU cores to be used by the container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype cpu: float
    :ivar cpu_limit: The maximum amount of CPU cores allowed to be used by the container. More
     info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype cpu_limit: float
    :ivar memory_in_gb: The minimum amount of memory (in GB) to be used by the container. More
     info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype memory_in_gb: float
    :ivar memory_in_gb_limit: The maximum amount of memory (in GB) allowed to be used by the
     container. More info:
     https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
    :vartype memory_in_gb_limit: float
    :ivar gpu: The number of GPU cores in the container.
    :vartype gpu: int
    :ivar fpga: The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
    :vartype fpga: int
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'float'},
        'cpu_limit': {'key': 'cpuLimit', 'type': 'float'},
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'float'},
        'memory_in_gb_limit': {'key': 'memoryInGBLimit', 'type': 'float'},
        'gpu': {'key': 'gpu', 'type': 'int'},
        'fpga': {'key': 'fpga', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        cpu: Optional[float] = None,
        cpu_limit: Optional[float] = None,
        memory_in_gb: Optional[float] = None,
        memory_in_gb_limit: Optional[float] = None,
        gpu: Optional[int] = None,
        fpga: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword cpu: The minimum amount of CPU cores to be used by the container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype cpu: float
        :keyword cpu_limit: The maximum amount of CPU cores allowed to be used by the container. More
         info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype cpu_limit: float
        :keyword memory_in_gb: The minimum amount of memory (in GB) to be used by the container. More
         info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype memory_in_gb: float
        :keyword memory_in_gb_limit: The maximum amount of memory (in GB) allowed to be used by the
         container. More info:
         https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/.
        :paramtype memory_in_gb_limit: float
        :keyword gpu: The number of GPU cores in the container.
        :paramtype gpu: int
        :keyword fpga: The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
        :paramtype fpga: int
        """
        super(ContainerResourceRequirements, self).__init__(**kwargs)
        self.cpu = cpu
        self.cpu_limit = cpu_limit
        self.memory_in_gb = memory_in_gb
        self.memory_in_gb_limit = memory_in_gb_limit
        self.gpu = gpu
        self.fpga = fpga


class CosmosDbSettings(msrest.serialization.Model):
    """CosmosDbSettings.

    :ivar collections_throughput: The throughput of the collections in cosmosdb database.
    :vartype collections_throughput: int
    """

    _attribute_map = {
        'collections_throughput': {'key': 'collectionsThroughput', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        collections_throughput: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword collections_throughput: The throughput of the collections in cosmosdb database.
        :paramtype collections_throughput: int
        """
        super(CosmosDbSettings, self).__init__(**kwargs)
        self.collections_throughput = collections_throughput


class Cron(msrest.serialization.Model):
    """The workflow trigger cron for ComputeStartStop schedule type.

    :ivar start_time: The start time.
    :vartype start_time: str
    :ivar time_zone: The time zone.
    :vartype time_zone: str
    :ivar expression: The cron expression.
    :vartype expression: str
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'expression': {'key': 'expression', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = None,
        expression: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword start_time: The start time.
        :paramtype start_time: str
        :keyword time_zone: The time zone.
        :paramtype time_zone: str
        :keyword expression: The cron expression.
        :paramtype expression: str
        """
        super(Cron, self).__init__(**kwargs)
        self.start_time = start_time
        self.time_zone = time_zone
        self.expression = expression


class Databricks(Compute):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar properties: Properties of Databricks.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'DatabricksProperties'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        properties: Optional["DatabricksProperties"] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword properties: Properties of Databricks.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
        """
        super(Databricks, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'Databricks'  # type: str
        self.properties = properties


class DatabricksComputeSecretsProperties(msrest.serialization.Model):
    """Properties of Databricks Compute Secrets.

    :ivar databricks_access_token: access token for databricks account.
    :vartype databricks_access_token: str
    """

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databricks_access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword databricks_access_token: access token for databricks account.
        :paramtype databricks_access_token: str
        """
        super(DatabricksComputeSecretsProperties, self).__init__(**kwargs)
        self.databricks_access_token = databricks_access_token


class DatabricksComputeSecrets(ComputeSecrets, DatabricksComputeSecretsProperties):
    """Secrets related to a Machine Learning compute based on Databricks.

    All required parameters must be populated in order to send to Azure.

    :ivar databricks_access_token: access token for databricks account.
    :vartype databricks_access_token: str
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databricks_access_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword databricks_access_token: access token for databricks account.
        :paramtype databricks_access_token: str
        """
        super(DatabricksComputeSecrets, self).__init__(databricks_access_token=databricks_access_token, **kwargs)
        self.databricks_access_token = databricks_access_token
        self.compute_type = 'Databricks'  # type: str
        self.compute_type = 'Databricks'  # type: str


class DatabricksProperties(msrest.serialization.Model):
    """Properties of Databricks.

    :ivar databricks_access_token: Databricks access token.
    :vartype databricks_access_token: str
    :ivar workspace_url: Workspace Url.
    :vartype workspace_url: str
    """

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
        'workspace_url': {'key': 'workspaceUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        databricks_access_token: Optional[str] = None,
        workspace_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword databricks_access_token: Databricks access token.
        :paramtype databricks_access_token: str
        :keyword workspace_url: Workspace Url.
        :paramtype workspace_url: str
        """
        super(DatabricksProperties, self).__init__(**kwargs)
        self.databricks_access_token = databricks_access_token
        self.workspace_url = workspace_url


class DataFactory(Compute):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(DataFactory, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'DataFactory'  # type: str


class DataLakeAnalytics(Compute):
    """A DataLakeAnalytics compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'DataLakeAnalyticsProperties'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        properties: Optional["DataLakeAnalyticsProperties"] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsProperties
        """
        super(DataLakeAnalytics, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'DataLakeAnalytics'  # type: str
        self.properties = properties


class DataLakeAnalyticsProperties(msrest.serialization.Model):
    """DataLakeAnalyticsProperties.

    :ivar data_lake_store_account_name: DataLake Store Account Name.
    :vartype data_lake_store_account_name: str
    """

    _attribute_map = {
        'data_lake_store_account_name': {'key': 'dataLakeStoreAccountName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_lake_store_account_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_lake_store_account_name: DataLake Store Account Name.
        :paramtype data_lake_store_account_name: str
        """
        super(DataLakeAnalyticsProperties, self).__init__(**kwargs)
        self.data_lake_store_account_name = data_lake_store_account_name


class DiagnoseRequestProperties(msrest.serialization.Model):
    """DiagnoseRequestProperties.

    :ivar udr: Setting for diagnosing user defined routing.
    :vartype udr: dict[str, any]
    :ivar nsg: Setting for diagnosing network security group.
    :vartype nsg: dict[str, any]
    :ivar resource_lock: Setting for diagnosing resource lock.
    :vartype resource_lock: dict[str, any]
    :ivar dns_resolution: Setting for diagnosing dns resolution.
    :vartype dns_resolution: dict[str, any]
    :ivar storage_account: Setting for diagnosing dependent storage account.
    :vartype storage_account: dict[str, any]
    :ivar key_vault: Setting for diagnosing dependent key vault.
    :vartype key_vault: dict[str, any]
    :ivar container_registry: Setting for diagnosing dependent container registry.
    :vartype container_registry: dict[str, any]
    :ivar application_insights: Setting for diagnosing dependent application insights.
    :vartype application_insights: dict[str, any]
    :ivar others: Setting for diagnosing unclassified category of problems.
    :vartype others: dict[str, any]
    """

    _attribute_map = {
        'udr': {'key': 'udr', 'type': '{object}'},
        'nsg': {'key': 'nsg', 'type': '{object}'},
        'resource_lock': {'key': 'resourceLock', 'type': '{object}'},
        'dns_resolution': {'key': 'dnsResolution', 'type': '{object}'},
        'storage_account': {'key': 'storageAccount', 'type': '{object}'},
        'key_vault': {'key': 'keyVault', 'type': '{object}'},
        'container_registry': {'key': 'containerRegistry', 'type': '{object}'},
        'application_insights': {'key': 'applicationInsights', 'type': '{object}'},
        'others': {'key': 'others', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        udr: Optional[Dict[str, Any]] = None,
        nsg: Optional[Dict[str, Any]] = None,
        resource_lock: Optional[Dict[str, Any]] = None,
        dns_resolution: Optional[Dict[str, Any]] = None,
        storage_account: Optional[Dict[str, Any]] = None,
        key_vault: Optional[Dict[str, Any]] = None,
        container_registry: Optional[Dict[str, Any]] = None,
        application_insights: Optional[Dict[str, Any]] = None,
        others: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword udr: Setting for diagnosing user defined routing.
        :paramtype udr: dict[str, any]
        :keyword nsg: Setting for diagnosing network security group.
        :paramtype nsg: dict[str, any]
        :keyword resource_lock: Setting for diagnosing resource lock.
        :paramtype resource_lock: dict[str, any]
        :keyword dns_resolution: Setting for diagnosing dns resolution.
        :paramtype dns_resolution: dict[str, any]
        :keyword storage_account: Setting for diagnosing dependent storage account.
        :paramtype storage_account: dict[str, any]
        :keyword key_vault: Setting for diagnosing dependent key vault.
        :paramtype key_vault: dict[str, any]
        :keyword container_registry: Setting for diagnosing dependent container registry.
        :paramtype container_registry: dict[str, any]
        :keyword application_insights: Setting for diagnosing dependent application insights.
        :paramtype application_insights: dict[str, any]
        :keyword others: Setting for diagnosing unclassified category of problems.
        :paramtype others: dict[str, any]
        """
        super(DiagnoseRequestProperties, self).__init__(**kwargs)
        self.udr = udr
        self.nsg = nsg
        self.resource_lock = resource_lock
        self.dns_resolution = dns_resolution
        self.storage_account = storage_account
        self.key_vault = key_vault
        self.container_registry = container_registry
        self.application_insights = application_insights
        self.others = others


class DiagnoseResponseResult(msrest.serialization.Model):
    """DiagnoseResponseResult.

    :ivar value:
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'DiagnoseResponseResultValue'},
    }

    def __init__(
        self,
        *,
        value: Optional["DiagnoseResponseResultValue"] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseResponseResultValue
        """
        super(DiagnoseResponseResult, self).__init__(**kwargs)
        self.value = value


class DiagnoseResponseResultValue(msrest.serialization.Model):
    """DiagnoseResponseResultValue.

    :ivar user_defined_route_results:
    :vartype user_defined_route_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar network_security_rule_results:
    :vartype network_security_rule_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar resource_lock_results:
    :vartype resource_lock_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar dns_resolution_results:
    :vartype dns_resolution_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar storage_account_results:
    :vartype storage_account_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar key_vault_results:
    :vartype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar container_registry_results:
    :vartype container_registry_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar application_insights_results:
    :vartype application_insights_results:
     list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    :ivar other_results:
    :vartype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
    """

    _attribute_map = {
        'user_defined_route_results': {'key': 'userDefinedRouteResults', 'type': '[DiagnoseResult]'},
        'network_security_rule_results': {'key': 'networkSecurityRuleResults', 'type': '[DiagnoseResult]'},
        'resource_lock_results': {'key': 'resourceLockResults', 'type': '[DiagnoseResult]'},
        'dns_resolution_results': {'key': 'dnsResolutionResults', 'type': '[DiagnoseResult]'},
        'storage_account_results': {'key': 'storageAccountResults', 'type': '[DiagnoseResult]'},
        'key_vault_results': {'key': 'keyVaultResults', 'type': '[DiagnoseResult]'},
        'container_registry_results': {'key': 'containerRegistryResults', 'type': '[DiagnoseResult]'},
        'application_insights_results': {'key': 'applicationInsightsResults', 'type': '[DiagnoseResult]'},
        'other_results': {'key': 'otherResults', 'type': '[DiagnoseResult]'},
    }

    def __init__(
        self,
        *,
        user_defined_route_results: Optional[List["DiagnoseResult"]] = None,
        network_security_rule_results: Optional[List["DiagnoseResult"]] = None,
        resource_lock_results: Optional[List["DiagnoseResult"]] = None,
        dns_resolution_results: Optional[List["DiagnoseResult"]] = None,
        storage_account_results: Optional[List["DiagnoseResult"]] = None,
        key_vault_results: Optional[List["DiagnoseResult"]] = None,
        container_registry_results: Optional[List["DiagnoseResult"]] = None,
        application_insights_results: Optional[List["DiagnoseResult"]] = None,
        other_results: Optional[List["DiagnoseResult"]] = None,
        **kwargs
    ):
        """
        :keyword user_defined_route_results:
        :paramtype user_defined_route_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword network_security_rule_results:
        :paramtype network_security_rule_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword resource_lock_results:
        :paramtype resource_lock_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword dns_resolution_results:
        :paramtype dns_resolution_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword storage_account_results:
        :paramtype storage_account_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword key_vault_results:
        :paramtype key_vault_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword container_registry_results:
        :paramtype container_registry_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword application_insights_results:
        :paramtype application_insights_results:
         list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        :keyword other_results:
        :paramtype other_results: list[~azure.mgmt.machinelearningservices.models.DiagnoseResult]
        """
        super(DiagnoseResponseResultValue, self).__init__(**kwargs)
        self.user_defined_route_results = user_defined_route_results
        self.network_security_rule_results = network_security_rule_results
        self.resource_lock_results = resource_lock_results
        self.dns_resolution_results = dns_resolution_results
        self.storage_account_results = storage_account_results
        self.key_vault_results = key_vault_results
        self.container_registry_results = container_registry_results
        self.application_insights_results = application_insights_results
        self.other_results = other_results


class DiagnoseResult(msrest.serialization.Model):
    """Result of Diagnose.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code for workspace setup error.
    :vartype code: str
    :ivar level: Level of workspace setup error. Possible values include: "Warning", "Error",
     "Information".
    :vartype level: str or ~azure.mgmt.machinelearningservices.models.DiagnoseResultLevel
    :ivar message: Message of workspace setup error.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'level': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DiagnoseResult, self).__init__(**kwargs)
        self.code = None
        self.level = None
        self.message = None


class DiagnoseWorkspaceParameters(msrest.serialization.Model):
    """Parameters to diagnose a workspace.

    :ivar value: Value of Parameters.
    :vartype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'DiagnoseRequestProperties'},
    }

    def __init__(
        self,
        *,
        value: Optional["DiagnoseRequestProperties"] = None,
        **kwargs
    ):
        """
        :keyword value: Value of Parameters.
        :paramtype value: ~azure.mgmt.machinelearningservices.models.DiagnoseRequestProperties
        """
        super(DiagnoseWorkspaceParameters, self).__init__(**kwargs)
        self.value = value


class EncryptionProperty(msrest.serialization.Model):
    """EncryptionProperty.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Indicates whether or not the encryption is enabled for the workspace.
     Possible values include: "Enabled", "Disabled".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
    :ivar identity: The identity that will be used to access the key vault for encryption at rest.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
    :ivar key_vault_properties: Required. Customer Key vault properties.
    :vartype key_vault_properties: ~azure.mgmt.machinelearningservices.models.KeyVaultProperties
    :ivar cosmos_db_resource_id: The Bring-Your-Own cosmosdb account that customer brings to store
     data.
    :vartype cosmos_db_resource_id: str
    :ivar storage_account_resource_id: The Bring-Your-Own storage account that customer brings to
     store data.
    :vartype storage_account_resource_id: str
    :ivar search_account_resource_id: The Bring-Your-Own search account that customer brings to
     store index.
    :vartype search_account_resource_id: str
    """

    _validation = {
        'status': {'required': True},
        'key_vault_properties': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityForCmk'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
        'cosmos_db_resource_id': {'key': 'cosmosDbResourceId', 'type': 'str'},
        'storage_account_resource_id': {'key': 'storageAccountResourceId', 'type': 'str'},
        'search_account_resource_id': {'key': 'searchAccountResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "EncryptionStatus"],
        key_vault_properties: "KeyVaultProperties",
        identity: Optional["IdentityForCmk"] = None,
        cosmos_db_resource_id: Optional[str] = None,
        storage_account_resource_id: Optional[str] = None,
        search_account_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Required. Indicates whether or not the encryption is enabled for the
         workspace. Possible values include: "Enabled", "Disabled".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
        :keyword identity: The identity that will be used to access the key vault for encryption at
         rest.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.IdentityForCmk
        :keyword key_vault_properties: Required. Customer Key vault properties.
        :paramtype key_vault_properties: ~azure.mgmt.machinelearningservices.models.KeyVaultProperties
        :keyword cosmos_db_resource_id: The Bring-Your-Own cosmosdb account that customer brings to
         store data.
        :paramtype cosmos_db_resource_id: str
        :keyword storage_account_resource_id: The Bring-Your-Own storage account that customer brings
         to store data.
        :paramtype storage_account_resource_id: str
        :keyword search_account_resource_id: The Bring-Your-Own search account that customer brings to
         store index.
        :paramtype search_account_resource_id: str
        """
        super(EncryptionProperty, self).__init__(**kwargs)
        self.status = status
        self.identity = identity
        self.key_vault_properties = key_vault_properties
        self.cosmos_db_resource_id = cosmos_db_resource_id
        self.storage_account_resource_id = storage_account_resource_id
        self.search_account_resource_id = search_account_resource_id


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.machinelearningservices.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.machinelearningservices.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class EstimatedVMPrice(msrest.serialization.Model):
    """The estimated price info for using a VM of a particular OS type, tier, etc.

    All required parameters must be populated in order to send to Azure.

    :ivar retail_price: Required. The price charged for using the VM.
    :vartype retail_price: float
    :ivar os_type: Required. Operating system type used by the VM. Possible values include:
     "Linux", "Windows".
    :vartype os_type: str or ~azure.mgmt.machinelearningservices.models.VMPriceOSType
    :ivar vm_tier: Required. The type of the VM. Possible values include: "Standard",
     "LowPriority", "Spot".
    :vartype vm_tier: str or ~azure.mgmt.machinelearningservices.models.VMTier
    """

    _validation = {
        'retail_price': {'required': True},
        'os_type': {'required': True},
        'vm_tier': {'required': True},
    }

    _attribute_map = {
        'retail_price': {'key': 'retailPrice', 'type': 'float'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_tier': {'key': 'vmTier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        retail_price: float,
        os_type: Union[str, "VMPriceOSType"],
        vm_tier: Union[str, "VMTier"],
        **kwargs
    ):
        """
        :keyword retail_price: Required. The price charged for using the VM.
        :paramtype retail_price: float
        :keyword os_type: Required. Operating system type used by the VM. Possible values include:
         "Linux", "Windows".
        :paramtype os_type: str or ~azure.mgmt.machinelearningservices.models.VMPriceOSType
        :keyword vm_tier: Required. The type of the VM. Possible values include: "Standard",
         "LowPriority", "Spot".
        :paramtype vm_tier: str or ~azure.mgmt.machinelearningservices.models.VMTier
        """
        super(EstimatedVMPrice, self).__init__(**kwargs)
        self.retail_price = retail_price
        self.os_type = os_type
        self.vm_tier = vm_tier


class EstimatedVMPrices(msrest.serialization.Model):
    """The estimated price info for using a VM.

    All required parameters must be populated in order to send to Azure.

    :ivar billing_currency: Required. Three lettered code specifying the currency of the VM price.
     Example: USD. Possible values include: "USD".
    :vartype billing_currency: str or ~azure.mgmt.machinelearningservices.models.BillingCurrency
    :ivar unit_of_measure: Required. The unit of time measurement for the specified VM price.
     Example: OneHour. Possible values include: "OneHour".
    :vartype unit_of_measure: str or ~azure.mgmt.machinelearningservices.models.UnitOfMeasure
    :ivar values: Required. The list of estimated prices for using a VM of a particular OS type,
     tier, etc.
    :vartype values: list[~azure.mgmt.machinelearningservices.models.EstimatedVMPrice]
    """

    _validation = {
        'billing_currency': {'required': True},
        'unit_of_measure': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'billing_currency': {'key': 'billingCurrency', 'type': 'str'},
        'unit_of_measure': {'key': 'unitOfMeasure', 'type': 'str'},
        'values': {'key': 'values', 'type': '[EstimatedVMPrice]'},
    }

    def __init__(
        self,
        *,
        billing_currency: Union[str, "BillingCurrency"],
        unit_of_measure: Union[str, "UnitOfMeasure"],
        values: List["EstimatedVMPrice"],
        **kwargs
    ):
        """
        :keyword billing_currency: Required. Three lettered code specifying the currency of the VM
         price. Example: USD. Possible values include: "USD".
        :paramtype billing_currency: str or ~azure.mgmt.machinelearningservices.models.BillingCurrency
        :keyword unit_of_measure: Required. The unit of time measurement for the specified VM price.
         Example: OneHour. Possible values include: "OneHour".
        :paramtype unit_of_measure: str or ~azure.mgmt.machinelearningservices.models.UnitOfMeasure
        :keyword values: Required. The list of estimated prices for using a VM of a particular OS type,
         tier, etc.
        :paramtype values: list[~azure.mgmt.machinelearningservices.models.EstimatedVMPrice]
        """
        super(EstimatedVMPrices, self).__init__(**kwargs)
        self.billing_currency = billing_currency
        self.unit_of_measure = unit_of_measure
        self.values = values


class ExternalFQDNResponse(msrest.serialization.Model):
    """ExternalFQDNResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoints]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FQDNEndpoints]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["FQDNEndpoints"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoints]
        """
        super(ExternalFQDNResponse, self).__init__(**kwargs)
        self.value = value


class FQDNEndpoint(msrest.serialization.Model):
    """FQDNEndpoint.

    :ivar domain_name:
    :vartype domain_name: str
    :ivar endpoint_details:
    :vartype endpoint_details: list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[FQDNEndpointDetail]'},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["FQDNEndpointDetail"]] = None,
        **kwargs
    ):
        """
        :keyword domain_name:
        :paramtype domain_name: str
        :keyword endpoint_details:
        :paramtype endpoint_details:
         list[~azure.mgmt.machinelearningservices.models.FQDNEndpointDetail]
        """
        super(FQDNEndpoint, self).__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class FQDNEndpointDetail(msrest.serialization.Model):
    """FQDNEndpointDetail.

    :ivar port:
    :vartype port: int
    """

    _attribute_map = {
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword port:
        :paramtype port: int
        """
        super(FQDNEndpointDetail, self).__init__(**kwargs)
        self.port = port


class FQDNEndpoints(msrest.serialization.Model):
    """FQDNEndpoints.

    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpointsProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'FQDNEndpointsProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["FQDNEndpointsProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.FQDNEndpointsProperties
        """
        super(FQDNEndpoints, self).__init__(**kwargs)
        self.properties = properties


class FQDNEndpointsProperties(msrest.serialization.Model):
    """FQDNEndpointsProperties.

    :ivar category:
    :vartype category: str
    :ivar endpoints:
    :vartype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[FQDNEndpoint]'},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["FQDNEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword category:
        :paramtype category: str
        :keyword endpoints:
        :paramtype endpoints: list[~azure.mgmt.machinelearningservices.models.FQDNEndpoint]
        """
        super(FQDNEndpointsProperties, self).__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class HDInsight(Compute):
    """A HDInsight compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar properties: HDInsight compute properties.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'HDInsightProperties'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        properties: Optional["HDInsightProperties"] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword properties: HDInsight compute properties.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
        """
        super(HDInsight, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'HDInsight'  # type: str
        self.properties = properties


class HDInsightProperties(msrest.serialization.Model):
    """HDInsight compute properties.

    :ivar ssh_port: Port open for ssh connections on the master node of the cluster.
    :vartype ssh_port: int
    :ivar address: Public IP address of the master node of the cluster.
    :vartype address: str
    :ivar administrator_account: Admin credentials for master node of the cluster.
    :vartype administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _attribute_map = {
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'address': {'key': 'address', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(
        self,
        *,
        ssh_port: Optional[int] = None,
        address: Optional[str] = None,
        administrator_account: Optional["VirtualMachineSshCredentials"] = None,
        **kwargs
    ):
        """
        :keyword ssh_port: Port open for ssh connections on the master node of the cluster.
        :paramtype ssh_port: int
        :keyword address: Public IP address of the master node of the cluster.
        :paramtype address: str
        :keyword administrator_account: Admin credentials for master node of the cluster.
        :paramtype administrator_account:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
        """
        super(HDInsightProperties, self).__init__(**kwargs)
        self.ssh_port = ssh_port
        self.address = address
        self.administrator_account = administrator_account


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Possible values include: "SystemAssigned",
     "SystemAssigned,UserAssigned", "UserAssigned", "None".
    :vartype type: str or ~azure.mgmt.machinelearningservices.models.ResourceIdentityType
    :ivar user_assigned_identities: The user assigned identities associated with the resource.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. Possible values include: "SystemAssigned",
         "SystemAssigned,UserAssigned", "UserAssigned", "None".
        :paramtype type: str or ~azure.mgmt.machinelearningservices.models.ResourceIdentityType
        :keyword user_assigned_identities: The user assigned identities associated with the resource.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.machinelearningservices.models.UserAssignedIdentity]
        """
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class IdentityForCmk(msrest.serialization.Model):
    """Identity that will be used to access key vault for encryption at rest.

    :ivar user_assigned_identity: The ArmId of the user assigned identity that will be used to
     access the customer managed key vault.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_assigned_identity: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_assigned_identity: The ArmId of the user assigned identity that will be used to
         access the customer managed key vault.
        :paramtype user_assigned_identity: str
        """
        super(IdentityForCmk, self).__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity


class InstanceTypeSchema(msrest.serialization.Model):
    """Instance type schema.

    :ivar node_selector: Node Selector.
    :vartype node_selector: dict[str, str]
    :ivar resources: Resource requests/limits for this instance type.
    :vartype resources: ~azure.mgmt.machinelearningservices.models.InstanceTypeSchemaResources
    """

    _attribute_map = {
        'node_selector': {'key': 'nodeSelector', 'type': '{str}'},
        'resources': {'key': 'resources', 'type': 'InstanceTypeSchemaResources'},
    }

    def __init__(
        self,
        *,
        node_selector: Optional[Dict[str, str]] = None,
        resources: Optional["InstanceTypeSchemaResources"] = None,
        **kwargs
    ):
        """
        :keyword node_selector: Node Selector.
        :paramtype node_selector: dict[str, str]
        :keyword resources: Resource requests/limits for this instance type.
        :paramtype resources: ~azure.mgmt.machinelearningservices.models.InstanceTypeSchemaResources
        """
        super(InstanceTypeSchema, self).__init__(**kwargs)
        self.node_selector = node_selector
        self.resources = resources


class InstanceTypeSchemaResources(msrest.serialization.Model):
    """Resource requests/limits for this instance type.

    :ivar requests: Resource requests for this instance type.
    :vartype requests: dict[str, str]
    :ivar limits: Resource limits for this instance type.
    :vartype limits: dict[str, str]
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': '{str}'},
        'limits': {'key': 'limits', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        requests: Optional[Dict[str, str]] = None,
        limits: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword requests: Resource requests for this instance type.
        :paramtype requests: dict[str, str]
        :keyword limits: Resource limits for this instance type.
        :paramtype limits: dict[str, str]
        """
        super(InstanceTypeSchemaResources, self).__init__(**kwargs)
        self.requests = requests
        self.limits = limits


class KeyVaultProperties(msrest.serialization.Model):
    """KeyVaultProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar key_vault_arm_id: Required. The ArmId of the keyVault where the customer owned encryption
     key is present.
    :vartype key_vault_arm_id: str
    :ivar key_identifier: Required. Key vault uri to access the encryption key.
    :vartype key_identifier: str
    :ivar identity_client_id: For future use - The client id of the identity which will be used to
     access key vault.
    :vartype identity_client_id: str
    """

    _validation = {
        'key_vault_arm_id': {'required': True},
        'key_identifier': {'required': True},
    }

    _attribute_map = {
        'key_vault_arm_id': {'key': 'keyVaultArmId', 'type': 'str'},
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_arm_id: str,
        key_identifier: str,
        identity_client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_vault_arm_id: Required. The ArmId of the keyVault where the customer owned
         encryption key is present.
        :paramtype key_vault_arm_id: str
        :keyword key_identifier: Required. Key vault uri to access the encryption key.
        :paramtype key_identifier: str
        :keyword identity_client_id: For future use - The client id of the identity which will be used
         to access key vault.
        :paramtype identity_client_id: str
        """
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_vault_arm_id = key_vault_arm_id
        self.key_identifier = key_identifier
        self.identity_client_id = identity_client_id


class KubernetesSchema(msrest.serialization.Model):
    """Kubernetes Compute Schema.

    :ivar properties: Properties of Kubernetes.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'KubernetesProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["KubernetesProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of Kubernetes.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
        """
        super(KubernetesSchema, self).__init__(**kwargs)
        self.properties = properties


class Kubernetes(Compute, KubernetesSchema):
    """A Machine Learning compute based on Kubernetes Compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar properties: Properties of Kubernetes.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'KubernetesProperties'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        properties: Optional["KubernetesProperties"] = None,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of Kubernetes.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.KubernetesProperties
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        """
        super(Kubernetes, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, properties=properties, **kwargs)
        self.properties = properties
        self.compute_type = 'Kubernetes'  # type: str
        self.compute_type = 'Kubernetes'  # type: str
        self.compute_location = compute_location
        self.provisioning_state = None
        self.description = description
        self.created_on = None
        self.modified_on = None
        self.resource_id = resource_id
        self.provisioning_errors = None
        self.is_attached_compute = None
        self.disable_local_auth = disable_local_auth


class KubernetesProperties(msrest.serialization.Model):
    """Kubernetes properties.

    :ivar relay_connection_string: Relay connection string.
    :vartype relay_connection_string: str
    :ivar service_bus_connection_string: ServiceBus connection string.
    :vartype service_bus_connection_string: str
    :ivar extension_principal_id: Extension principal-id.
    :vartype extension_principal_id: str
    :ivar extension_instance_release_train: Extension instance release train.
    :vartype extension_instance_release_train: str
    :ivar vc_name: VC name.
    :vartype vc_name: str
    :ivar namespace: Compute namespace.
    :vartype namespace: str
    :ivar default_instance_type: Default instance type.
    :vartype default_instance_type: str
    :ivar instance_types: Instance Type Schema.
    :vartype instance_types: dict[str,
     ~azure.mgmt.machinelearningservices.models.InstanceTypeSchema]
    """

    _attribute_map = {
        'relay_connection_string': {'key': 'relayConnectionString', 'type': 'str'},
        'service_bus_connection_string': {'key': 'serviceBusConnectionString', 'type': 'str'},
        'extension_principal_id': {'key': 'extensionPrincipalId', 'type': 'str'},
        'extension_instance_release_train': {'key': 'extensionInstanceReleaseTrain', 'type': 'str'},
        'vc_name': {'key': 'vcName', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'default_instance_type': {'key': 'defaultInstanceType', 'type': 'str'},
        'instance_types': {'key': 'instanceTypes', 'type': '{InstanceTypeSchema}'},
    }

    def __init__(
        self,
        *,
        relay_connection_string: Optional[str] = None,
        service_bus_connection_string: Optional[str] = None,
        extension_principal_id: Optional[str] = None,
        extension_instance_release_train: Optional[str] = None,
        vc_name: Optional[str] = None,
        namespace: Optional[str] = "default",
        default_instance_type: Optional[str] = None,
        instance_types: Optional[Dict[str, "InstanceTypeSchema"]] = None,
        **kwargs
    ):
        """
        :keyword relay_connection_string: Relay connection string.
        :paramtype relay_connection_string: str
        :keyword service_bus_connection_string: ServiceBus connection string.
        :paramtype service_bus_connection_string: str
        :keyword extension_principal_id: Extension principal-id.
        :paramtype extension_principal_id: str
        :keyword extension_instance_release_train: Extension instance release train.
        :paramtype extension_instance_release_train: str
        :keyword vc_name: VC name.
        :paramtype vc_name: str
        :keyword namespace: Compute namespace.
        :paramtype namespace: str
        :keyword default_instance_type: Default instance type.
        :paramtype default_instance_type: str
        :keyword instance_types: Instance Type Schema.
        :paramtype instance_types: dict[str,
         ~azure.mgmt.machinelearningservices.models.InstanceTypeSchema]
        """
        super(KubernetesProperties, self).__init__(**kwargs)
        self.relay_connection_string = relay_connection_string
        self.service_bus_connection_string = service_bus_connection_string
        self.extension_principal_id = extension_principal_id
        self.extension_instance_release_train = extension_instance_release_train
        self.vc_name = vc_name
        self.namespace = namespace
        self.default_instance_type = default_instance_type
        self.instance_types = instance_types


class ListAmlUserFeatureResult(msrest.serialization.Model):
    """The List Aml user feature operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of AML user facing features.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.AmlUserFeature]
    :ivar next_link: The URI to fetch the next page of AML user features information. Call
     ListNext() with this to fetch the next page of AML user features information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AmlUserFeature]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListAmlUserFeatureResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListNotebookKeysResult(msrest.serialization.Model):
    """ListNotebookKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_access_key:
    :vartype primary_access_key: str
    :ivar secondary_access_key:
    :vartype secondary_access_key: str
    """

    _validation = {
        'primary_access_key': {'readonly': True},
        'secondary_access_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_access_key': {'key': 'primaryAccessKey', 'type': 'str'},
        'secondary_access_key': {'key': 'secondaryAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListNotebookKeysResult, self).__init__(**kwargs)
        self.primary_access_key = None
        self.secondary_access_key = None


class ListStorageAccountKeysResult(msrest.serialization.Model):
    """ListStorageAccountKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_storage_key:
    :vartype user_storage_key: str
    """

    _validation = {
        'user_storage_key': {'readonly': True},
    }

    _attribute_map = {
        'user_storage_key': {'key': 'userStorageKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListStorageAccountKeysResult, self).__init__(**kwargs)
        self.user_storage_key = None


class ListUsagesResult(msrest.serialization.Model):
    """The List Usages operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of AML resource usages.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Usage]
    :ivar next_link: The URI to fetch the next page of AML resource usage information. Call
     ListNext() with this to fetch the next page of AML resource usage information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListUsagesResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListWorkspaceKeysResult(msrest.serialization.Model):
    """ListWorkspaceKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_storage_key:
    :vartype user_storage_key: str
    :ivar user_storage_resource_id:
    :vartype user_storage_resource_id: str
    :ivar app_insights_instrumentation_key:
    :vartype app_insights_instrumentation_key: str
    :ivar container_registry_credentials:
    :vartype container_registry_credentials:
     ~azure.mgmt.machinelearningservices.models.RegistryListCredentialsResult
    :ivar notebook_access_keys:
    :vartype notebook_access_keys:
     ~azure.mgmt.machinelearningservices.models.ListNotebookKeysResult
    """

    _validation = {
        'user_storage_key': {'readonly': True},
        'user_storage_resource_id': {'readonly': True},
        'app_insights_instrumentation_key': {'readonly': True},
        'container_registry_credentials': {'readonly': True},
        'notebook_access_keys': {'readonly': True},
    }

    _attribute_map = {
        'user_storage_key': {'key': 'userStorageKey', 'type': 'str'},
        'user_storage_resource_id': {'key': 'userStorageResourceId', 'type': 'str'},
        'app_insights_instrumentation_key': {'key': 'appInsightsInstrumentationKey', 'type': 'str'},
        'container_registry_credentials': {'key': 'containerRegistryCredentials', 'type': 'RegistryListCredentialsResult'},
        'notebook_access_keys': {'key': 'notebookAccessKeys', 'type': 'ListNotebookKeysResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListWorkspaceKeysResult, self).__init__(**kwargs)
        self.user_storage_key = None
        self.user_storage_resource_id = None
        self.app_insights_instrumentation_key = None
        self.container_registry_credentials = None
        self.notebook_access_keys = None


class ListWorkspaceQuotas(msrest.serialization.Model):
    """The List WorkspaceQuotasByVMFamily operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Workspace Quotas by VM Family.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ResourceQuota]
    :ivar next_link: The URI to fetch the next page of workspace quota information by VM Family.
     Call ListNext() with this to fetch the next page of Workspace Quota information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListWorkspaceQuotas, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedIdentity(msrest.serialization.Model):
    """ManagedIdentity.

    :ivar resource_id:
    :vartype resource_id: str
    :ivar client_id:
    :vartype client_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword resource_id:
        :paramtype resource_id: str
        :keyword client_id:
        :paramtype client_id: str
        """
        super(ManagedIdentity, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.client_id = client_id


class WorkspaceConnectionPropertiesV2(msrest.serialization.Model):
    """WorkspaceConnectionPropertiesV2.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ManagedIdentityAuthTypeWorkspaceConnectionProperties, NoneAuthTypeWorkspaceConnectionProperties, PATAuthTypeWorkspaceConnectionProperties, SASAuthTypeWorkspaceConnectionProperties, ServicePrincipalAuthTypeWorkspaceConnectionProperties, UsernamePasswordAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "FeatureStore".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar metadata: Other Metadata that we would like to store with workspace connection.
    :vartype metadata: dict[str, any]
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
    }

    _subtype_map = {
        'auth_type': {'ManagedIdentity': 'ManagedIdentityAuthTypeWorkspaceConnectionProperties', 'None': 'NoneAuthTypeWorkspaceConnectionProperties', 'PAT': 'PATAuthTypeWorkspaceConnectionProperties', 'SAS': 'SASAuthTypeWorkspaceConnectionProperties', 'ServicePrincipal': 'ServicePrincipalAuthTypeWorkspaceConnectionProperties', 'UsernamePassword': 'UsernamePasswordAuthTypeWorkspaceConnectionProperties'}
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "FeatureStore".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword metadata: Other Metadata that we would like to store with workspace connection.
        :paramtype metadata: dict[str, any]
        """
        super(WorkspaceConnectionPropertiesV2, self).__init__(**kwargs)
        self.auth_type = None  # type: Optional[str]
        self.category = category
        self.target = target
        self.value = value
        self.value_format = value_format
        self.metadata = metadata


class ManagedIdentityAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """ManagedIdentityAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "FeatureStore".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar metadata: Other Metadata that we would like to store with workspace connection.
    :vartype metadata: dict[str, any]
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.ManagedIdentity
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'credentials': {'key': 'credentials', 'type': 'ManagedIdentity'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        credentials: Optional["ManagedIdentity"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "FeatureStore".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword metadata: Other Metadata that we would like to store with workspace connection.
        :paramtype metadata: dict[str, any]
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.ManagedIdentity
        """
        super(ManagedIdentityAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, metadata=metadata, **kwargs)
        self.auth_type = 'ManagedIdentity'  # type: str
        self.credentials = credentials


class NodeStateCounts(msrest.serialization.Model):
    """Counts of various compute node states on the amlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar idle_node_count: Number of compute nodes in idle state.
    :vartype idle_node_count: int
    :ivar running_node_count: Number of compute nodes which are running jobs.
    :vartype running_node_count: int
    :ivar preparing_node_count: Number of compute nodes which are being prepared.
    :vartype preparing_node_count: int
    :ivar unusable_node_count: Number of compute nodes which are in unusable state.
    :vartype unusable_node_count: int
    :ivar leaving_node_count: Number of compute nodes which are leaving the amlCompute.
    :vartype leaving_node_count: int
    :ivar preempted_node_count: Number of compute nodes which are in preempted state.
    :vartype preempted_node_count: int
    """

    _validation = {
        'idle_node_count': {'readonly': True},
        'running_node_count': {'readonly': True},
        'preparing_node_count': {'readonly': True},
        'unusable_node_count': {'readonly': True},
        'leaving_node_count': {'readonly': True},
        'preempted_node_count': {'readonly': True},
    }

    _attribute_map = {
        'idle_node_count': {'key': 'idleNodeCount', 'type': 'int'},
        'running_node_count': {'key': 'runningNodeCount', 'type': 'int'},
        'preparing_node_count': {'key': 'preparingNodeCount', 'type': 'int'},
        'unusable_node_count': {'key': 'unusableNodeCount', 'type': 'int'},
        'leaving_node_count': {'key': 'leavingNodeCount', 'type': 'int'},
        'preempted_node_count': {'key': 'preemptedNodeCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NodeStateCounts, self).__init__(**kwargs)
        self.idle_node_count = None
        self.running_node_count = None
        self.preparing_node_count = None
        self.unusable_node_count = None
        self.leaving_node_count = None
        self.preempted_node_count = None


class NoneAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """NoneAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "FeatureStore".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar metadata: Other Metadata that we would like to store with workspace connection.
    :vartype metadata: dict[str, any]
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "FeatureStore".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword metadata: Other Metadata that we would like to store with workspace connection.
        :paramtype metadata: dict[str, any]
        """
        super(NoneAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, metadata=metadata, **kwargs)
        self.auth_type = 'None'  # type: str


class NotebookAccessTokenResult(msrest.serialization.Model):
    """NotebookAccessTokenResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar notebook_resource_id:
    :vartype notebook_resource_id: str
    :ivar host_name:
    :vartype host_name: str
    :ivar public_dns:
    :vartype public_dns: str
    :ivar access_token:
    :vartype access_token: str
    :ivar token_type:
    :vartype token_type: str
    :ivar expires_in:
    :vartype expires_in: int
    :ivar refresh_token:
    :vartype refresh_token: str
    :ivar scope:
    :vartype scope: str
    """

    _validation = {
        'notebook_resource_id': {'readonly': True},
        'host_name': {'readonly': True},
        'public_dns': {'readonly': True},
        'access_token': {'readonly': True},
        'token_type': {'readonly': True},
        'expires_in': {'readonly': True},
        'refresh_token': {'readonly': True},
        'scope': {'readonly': True},
    }

    _attribute_map = {
        'notebook_resource_id': {'key': 'notebookResourceId', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'public_dns': {'key': 'publicDns', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(NotebookAccessTokenResult, self).__init__(**kwargs)
        self.notebook_resource_id = None
        self.host_name = None
        self.public_dns = None
        self.access_token = None
        self.token_type = None
        self.expires_in = None
        self.refresh_token = None
        self.scope = None


class NotebookPreparationError(msrest.serialization.Model):
    """NotebookPreparationError.

    :ivar error_message:
    :vartype error_message: str
    :ivar status_code:
    :vartype status_code: int
    """

    _attribute_map = {
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        status_code: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword error_message:
        :paramtype error_message: str
        :keyword status_code:
        :paramtype status_code: int
        """
        super(NotebookPreparationError, self).__init__(**kwargs)
        self.error_message = error_message
        self.status_code = status_code


class NotebookResourceInfo(msrest.serialization.Model):
    """NotebookResourceInfo.

    :ivar fqdn:
    :vartype fqdn: str
    :ivar resource_id: the data plane resourceId that used to initialize notebook component.
    :vartype resource_id: str
    :ivar notebook_preparation_error: The error that occurs when preparing notebook.
    :vartype notebook_preparation_error:
     ~azure.mgmt.machinelearningservices.models.NotebookPreparationError
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'notebook_preparation_error': {'key': 'notebookPreparationError', 'type': 'NotebookPreparationError'},
    }

    def __init__(
        self,
        *,
        fqdn: Optional[str] = None,
        resource_id: Optional[str] = None,
        notebook_preparation_error: Optional["NotebookPreparationError"] = None,
        **kwargs
    ):
        """
        :keyword fqdn:
        :paramtype fqdn: str
        :keyword resource_id: the data plane resourceId that used to initialize notebook component.
        :paramtype resource_id: str
        :keyword notebook_preparation_error: The error that occurs when preparing notebook.
        :paramtype notebook_preparation_error:
         ~azure.mgmt.machinelearningservices.models.NotebookPreparationError
        """
        super(NotebookResourceInfo, self).__init__(**kwargs)
        self.fqdn = fqdn
        self.resource_id = resource_id
        self.notebook_preparation_error = notebook_preparation_error


class Operation(msrest.serialization.Model):
    """Azure Machine Learning workspace REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display name of operation.
    :vartype display: ~azure.mgmt.machinelearningservices.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display name of operation.
        :paramtype display: ~azure.mgmt.machinelearningservices.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """Display name of operation.

    :ivar provider: The resource provider name: Microsoft.MachineLearningExperimentation.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that users can perform.
    :vartype operation: str
    :ivar description: The description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: The resource provider name: Microsoft.MachineLearningExperimentation.
        :paramtype provider: str
        :keyword resource: The resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The operation that users can perform.
        :paramtype operation: str
        :keyword description: The description for the operation.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """An array of operations supported by the resource provider.

    :ivar value: List of AML workspace operations supported by the AML workspace resource provider.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of AML workspace operations supported by the AML workspace resource
         provider.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Operation]
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value


class PaginatedComputeResourcesList(msrest.serialization.Model):
    """Paginated list of Machine Learning compute objects wrapped in ARM resource envelope.

    :ivar value: An array of Machine Learning compute objects wrapped in ARM resource envelope.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ComputeResource]
    :ivar next_link: A continuation link (absolute URI) to the next page of results in the list.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ComputeResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ComputeResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: An array of Machine Learning compute objects wrapped in ARM resource envelope.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.ComputeResource]
        :keyword next_link: A continuation link (absolute URI) to the next page of results in the list.
        :paramtype next_link: str
        """
        super(PaginatedComputeResourcesList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Password(msrest.serialization.Model):
    """Password.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Password, self).__init__(**kwargs)
        self.name = None
        self.value = None


class PATAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """PATAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "FeatureStore".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar metadata: Other Metadata that we would like to store with workspace connection.
    :vartype metadata: dict[str, any]
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.PersonalAccessToken
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'credentials': {'key': 'credentials', 'type': 'PersonalAccessToken'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        credentials: Optional["PersonalAccessToken"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "FeatureStore".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword metadata: Other Metadata that we would like to store with workspace connection.
        :paramtype metadata: dict[str, any]
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.PersonalAccessToken
        """
        super(PATAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, metadata=metadata, **kwargs)
        self.auth_type = 'PAT'  # type: str
        self.credentials = credentials


class PersonalAccessToken(msrest.serialization.Model):
    """PersonalAccessToken.

    :ivar pat:
    :vartype pat: str
    """

    _attribute_map = {
        'pat': {'key': 'pat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        pat: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword pat:
        :paramtype pat: str
        """
        super(PersonalAccessToken, self).__init__(**kwargs)
        self.pat = pat


class PersonalComputeInstanceSettings(msrest.serialization.Model):
    """Settings for a personal compute instance.

    :ivar assigned_user: A user explicitly assigned to a personal compute instance.
    :vartype assigned_user: ~azure.mgmt.machinelearningservices.models.AssignedUser
    """

    _attribute_map = {
        'assigned_user': {'key': 'assignedUser', 'type': 'AssignedUser'},
    }

    def __init__(
        self,
        *,
        assigned_user: Optional["AssignedUser"] = None,
        **kwargs
    ):
        """
        :keyword assigned_user: A user explicitly assigned to a personal compute instance.
        :paramtype assigned_user: ~azure.mgmt.machinelearningservices.models.AssignedUser
        """
        super(PersonalComputeInstanceSettings, self).__init__(**kwargs)
        self.assigned_user = assigned_user


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    :ivar subnet_arm_id: The ARM identifier for Subnet resource that private endpoint links to.
    :vartype subnet_arm_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'subnet_arm_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subnet_arm_id': {'key': 'subnetArmId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None
        self.subnet_arm_id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.Identity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar system_data: System data.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.machinelearningservices.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.machinelearningservices.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["Identity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.Identity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: A set of tags. Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.machinelearningservices.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.machinelearningservices.models.PrivateLinkServiceConnectionState
        """
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.system_data = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified workspace.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        **kwargs
    ):
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
        """
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.Identity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar system_data: System data.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        identity: Optional["Identity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.Identity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: A set of tags. Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.system_data = None
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.PrivateLinkResource]
        """
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected", "Disconnected",
     "Timeout".
    :vartype status: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Possible values include: "Pending", "Approved", "Rejected",
         "Disconnected", "Timeout".
        :paramtype status: str or
         ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class QuotaBaseProperties(msrest.serialization.Model):
    """The properties for Quota update or retrieval.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar limit: The maximum permitted quota of the resource.
    :vartype limit: long
    :ivar unit: An enum describing the unit of quota measurement. Possible values include: "Count".
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        type: Optional[str] = None,
        limit: Optional[int] = None,
        unit: Optional[Union[str, "QuotaUnit"]] = None,
        **kwargs
    ):
        """
        :keyword id: Specifies the resource ID.
        :paramtype id: str
        :keyword type: Specifies the resource type.
        :paramtype type: str
        :keyword limit: The maximum permitted quota of the resource.
        :paramtype limit: long
        :keyword unit: An enum describing the unit of quota measurement. Possible values include:
         "Count".
        :paramtype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
        """
        super(QuotaBaseProperties, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.limit = limit
        self.unit = unit


class QuotaUpdateParameters(msrest.serialization.Model):
    """Quota update parameters.

    :ivar value: The list for update quota.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.QuotaBaseProperties]
    :ivar location: Region of workspace quota to be updated.
    :vartype location: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QuotaBaseProperties]'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["QuotaBaseProperties"]] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list for update quota.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.QuotaBaseProperties]
        :keyword location: Region of workspace quota to be updated.
        :paramtype location: str
        """
        super(QuotaUpdateParameters, self).__init__(**kwargs)
        self.value = value
        self.location = location


class Recurrence(msrest.serialization.Model):
    """The workflow trigger recurrence for ComputeStartStop schedule type.

    :ivar frequency: The recurrence frequency. Possible values include: "NotSpecified", "Second",
     "Minute", "Hour", "Day", "Week", "Month", "Year".
    :vartype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
    :ivar interval: The interval.
    :vartype interval: int
    :ivar start_time: The start time.
    :vartype start_time: str
    :ivar time_zone: The time zone.
    :vartype time_zone: str
    :ivar schedule: The recurrence schedule.
    :vartype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceSchedule
    """

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'RecurrenceSchedule'},
    }

    def __init__(
        self,
        *,
        frequency: Optional[Union[str, "RecurrenceFrequency"]] = None,
        interval: Optional[int] = None,
        start_time: Optional[str] = None,
        time_zone: Optional[str] = None,
        schedule: Optional["RecurrenceSchedule"] = None,
        **kwargs
    ):
        """
        :keyword frequency: The recurrence frequency. Possible values include: "NotSpecified",
         "Second", "Minute", "Hour", "Day", "Week", "Month", "Year".
        :paramtype frequency: str or ~azure.mgmt.machinelearningservices.models.RecurrenceFrequency
        :keyword interval: The interval.
        :paramtype interval: int
        :keyword start_time: The start time.
        :paramtype start_time: str
        :keyword time_zone: The time zone.
        :paramtype time_zone: str
        :keyword schedule: The recurrence schedule.
        :paramtype schedule: ~azure.mgmt.machinelearningservices.models.RecurrenceSchedule
        """
        super(Recurrence, self).__init__(**kwargs)
        self.frequency = frequency
        self.interval = interval
        self.start_time = start_time
        self.time_zone = time_zone
        self.schedule = schedule


class RecurrenceSchedule(msrest.serialization.Model):
    """The recurrence schedule.

    :ivar minutes: The minutes.
    :vartype minutes: list[int]
    :ivar hours: The hours.
    :vartype hours: list[int]
    :ivar week_days: The days of the week.
    :vartype week_days: list[str or ~azure.mgmt.machinelearningservices.models.DaysOfWeek]
    """

    _attribute_map = {
        'minutes': {'key': 'minutes', 'type': '[int]'},
        'hours': {'key': 'hours', 'type': '[int]'},
        'week_days': {'key': 'weekDays', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        minutes: Optional[List[int]] = None,
        hours: Optional[List[int]] = None,
        week_days: Optional[List[Union[str, "DaysOfWeek"]]] = None,
        **kwargs
    ):
        """
        :keyword minutes: The minutes.
        :paramtype minutes: list[int]
        :keyword hours: The hours.
        :paramtype hours: list[int]
        :keyword week_days: The days of the week.
        :paramtype week_days: list[str or ~azure.mgmt.machinelearningservices.models.DaysOfWeek]
        """
        super(RecurrenceSchedule, self).__init__(**kwargs)
        self.minutes = minutes
        self.hours = hours
        self.week_days = week_days


class RegistryListCredentialsResult(msrest.serialization.Model):
    """RegistryListCredentialsResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location:
    :vartype location: str
    :ivar username:
    :vartype username: str
    :ivar passwords:
    :vartype passwords: list[~azure.mgmt.machinelearningservices.models.Password]
    """

    _validation = {
        'location': {'readonly': True},
        'username': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[Password]'},
    }

    def __init__(
        self,
        *,
        passwords: Optional[List["Password"]] = None,
        **kwargs
    ):
        """
        :keyword passwords:
        :paramtype passwords: list[~azure.mgmt.machinelearningservices.models.Password]
        """
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.location = None
        self.username = None
        self.passwords = passwords


class ResourceAutoGenerated(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceAutoGenerated, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ResourceId(msrest.serialization.Model):
    """Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. The ID of the resource.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. The ID of the resource.
        :paramtype id: str
        """
        super(ResourceId, self).__init__(**kwargs)
        self.id = id


class ResourceName(msrest.serialization.Model):
    """The Resource Name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class ResourceQuota(msrest.serialization.Model):
    """The quota assigned to a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar aml_workspace_location: Region of the AML workspace in the id.
    :vartype aml_workspace_location: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar name: Name of the resource.
    :vartype name: ~azure.mgmt.machinelearningservices.models.ResourceName
    :ivar limit: The maximum permitted quota of the resource.
    :vartype limit: long
    :ivar unit: An enum describing the unit of quota measurement. Possible values include: "Count".
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
    """

    _validation = {
        'id': {'readonly': True},
        'aml_workspace_location': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'aml_workspace_location': {'key': 'amlWorkspaceLocation', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'ResourceName'},
        'limit': {'key': 'limit', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ResourceQuota, self).__init__(**kwargs)
        self.id = None
        self.aml_workspace_location = None
        self.type = None
        self.name = None
        self.limit = None
        self.unit = None


class SASAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """SASAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "FeatureStore".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar metadata: Other Metadata that we would like to store with workspace connection.
    :vartype metadata: dict[str, any]
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.SharedAccessSignature
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'credentials': {'key': 'credentials', 'type': 'SharedAccessSignature'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        credentials: Optional["SharedAccessSignature"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "FeatureStore".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword metadata: Other Metadata that we would like to store with workspace connection.
        :paramtype metadata: dict[str, any]
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.SharedAccessSignature
        """
        super(SASAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, metadata=metadata, **kwargs)
        self.auth_type = 'SAS'  # type: str
        self.credentials = credentials


class ScaleSettings(msrest.serialization.Model):
    """scale settings for AML Compute.

    All required parameters must be populated in order to send to Azure.

    :ivar max_node_count: Required. Max number of nodes to use.
    :vartype max_node_count: int
    :ivar min_node_count: Min number of nodes to use.
    :vartype min_node_count: int
    :ivar node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This
     string needs to be in the RFC Format.
    :vartype node_idle_time_before_scale_down: ~datetime.timedelta
    """

    _validation = {
        'max_node_count': {'required': True},
    }

    _attribute_map = {
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'node_idle_time_before_scale_down': {'key': 'nodeIdleTimeBeforeScaleDown', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        max_node_count: int,
        min_node_count: Optional[int] = 0,
        node_idle_time_before_scale_down: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword max_node_count: Required. Max number of nodes to use.
        :paramtype max_node_count: int
        :keyword min_node_count: Min number of nodes to use.
        :paramtype min_node_count: int
        :keyword node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This
         string needs to be in the RFC Format.
        :paramtype node_idle_time_before_scale_down: ~datetime.timedelta
        """
        super(ScaleSettings, self).__init__(**kwargs)
        self.max_node_count = max_node_count
        self.min_node_count = min_node_count
        self.node_idle_time_before_scale_down = node_idle_time_before_scale_down


class ScaleSettingsInformation(msrest.serialization.Model):
    """Desired scale settings for the amlCompute.

    :ivar scale_settings: scale settings for AML Compute.
    :vartype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
    """

    _attribute_map = {
        'scale_settings': {'key': 'scaleSettings', 'type': 'ScaleSettings'},
    }

    def __init__(
        self,
        *,
        scale_settings: Optional["ScaleSettings"] = None,
        **kwargs
    ):
        """
        :keyword scale_settings: scale settings for AML Compute.
        :paramtype scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
        """
        super(ScaleSettingsInformation, self).__init__(**kwargs)
        self.scale_settings = scale_settings


class ScriptReference(msrest.serialization.Model):
    """Script reference.

    :ivar script_source: The storage source of the script: inline, workspace.
    :vartype script_source: str
    :ivar script_data: The location of scripts in the mounted volume.
    :vartype script_data: str
    :ivar script_arguments: Optional command line arguments passed to the script to run.
    :vartype script_arguments: str
    :ivar timeout: Optional time period passed to timeout command.
    :vartype timeout: str
    """

    _attribute_map = {
        'script_source': {'key': 'scriptSource', 'type': 'str'},
        'script_data': {'key': 'scriptData', 'type': 'str'},
        'script_arguments': {'key': 'scriptArguments', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        script_source: Optional[str] = None,
        script_data: Optional[str] = None,
        script_arguments: Optional[str] = None,
        timeout: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword script_source: The storage source of the script: inline, workspace.
        :paramtype script_source: str
        :keyword script_data: The location of scripts in the mounted volume.
        :paramtype script_data: str
        :keyword script_arguments: Optional command line arguments passed to the script to run.
        :paramtype script_arguments: str
        :keyword timeout: Optional time period passed to timeout command.
        :paramtype timeout: str
        """
        super(ScriptReference, self).__init__(**kwargs)
        self.script_source = script_source
        self.script_data = script_data
        self.script_arguments = script_arguments
        self.timeout = timeout


class ScriptsToExecute(msrest.serialization.Model):
    """Customized setup scripts.

    :ivar startup_script: Script that's run every time the machine starts.
    :vartype startup_script: ~azure.mgmt.machinelearningservices.models.ScriptReference
    :ivar creation_script: Script that's run only once during provision of the compute.
    :vartype creation_script: ~azure.mgmt.machinelearningservices.models.ScriptReference
    """

    _attribute_map = {
        'startup_script': {'key': 'startupScript', 'type': 'ScriptReference'},
        'creation_script': {'key': 'creationScript', 'type': 'ScriptReference'},
    }

    def __init__(
        self,
        *,
        startup_script: Optional["ScriptReference"] = None,
        creation_script: Optional["ScriptReference"] = None,
        **kwargs
    ):
        """
        :keyword startup_script: Script that's run every time the machine starts.
        :paramtype startup_script: ~azure.mgmt.machinelearningservices.models.ScriptReference
        :keyword creation_script: Script that's run only once during provision of the compute.
        :paramtype creation_script: ~azure.mgmt.machinelearningservices.models.ScriptReference
        """
        super(ScriptsToExecute, self).__init__(**kwargs)
        self.startup_script = startup_script
        self.creation_script = creation_script


class ServiceManagedResourcesSettings(msrest.serialization.Model):
    """ServiceManagedResourcesSettings.

    :ivar cosmos_db: The settings for the service managed cosmosdb account.
    :vartype cosmos_db: ~azure.mgmt.machinelearningservices.models.CosmosDbSettings
    """

    _attribute_map = {
        'cosmos_db': {'key': 'cosmosDb', 'type': 'CosmosDbSettings'},
    }

    def __init__(
        self,
        *,
        cosmos_db: Optional["CosmosDbSettings"] = None,
        **kwargs
    ):
        """
        :keyword cosmos_db: The settings for the service managed cosmosdb account.
        :paramtype cosmos_db: ~azure.mgmt.machinelearningservices.models.CosmosDbSettings
        """
        super(ServiceManagedResourcesSettings, self).__init__(**kwargs)
        self.cosmos_db = cosmos_db


class ServicePrincipal(msrest.serialization.Model):
    """ServicePrincipal.

    :ivar client_id:
    :vartype client_id: str
    :ivar client_secret:
    :vartype client_secret: str
    :ivar tenant_id:
    :vartype tenant_id: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword client_id:
        :paramtype client_id: str
        :keyword client_secret:
        :paramtype client_secret: str
        :keyword tenant_id:
        :paramtype tenant_id: str
        """
        super(ServicePrincipal, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_secret = client_secret
        self.tenant_id = tenant_id


class ServicePrincipalAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """ServicePrincipalAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "FeatureStore".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar metadata: Other Metadata that we would like to store with workspace connection.
    :vartype metadata: dict[str, any]
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.ServicePrincipal
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'credentials': {'key': 'credentials', 'type': 'ServicePrincipal'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        credentials: Optional["ServicePrincipal"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "FeatureStore".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword metadata: Other Metadata that we would like to store with workspace connection.
        :paramtype metadata: dict[str, any]
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.ServicePrincipal
        """
        super(ServicePrincipalAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, metadata=metadata, **kwargs)
        self.auth_type = 'ServicePrincipal'  # type: str
        self.credentials = credentials


class ServicePrincipalCredentials(msrest.serialization.Model):
    """Service principal credentials.

    All required parameters must be populated in order to send to Azure.

    :ivar client_id: Required. Client Id.
    :vartype client_id: str
    :ivar client_secret: Required. Client secret.
    :vartype client_secret: str
    """

    _validation = {
        'client_id': {'required': True},
        'client_secret': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        client_secret: str,
        **kwargs
    ):
        """
        :keyword client_id: Required. Client Id.
        :paramtype client_id: str
        :keyword client_secret: Required. Client secret.
        :paramtype client_secret: str
        """
        super(ServicePrincipalCredentials, self).__init__(**kwargs)
        self.client_id = client_id
        self.client_secret = client_secret


class SetupScripts(msrest.serialization.Model):
    """Details of customized scripts to execute for setting up the cluster.

    :ivar scripts: Customized setup scripts.
    :vartype scripts: ~azure.mgmt.machinelearningservices.models.ScriptsToExecute
    """

    _attribute_map = {
        'scripts': {'key': 'scripts', 'type': 'ScriptsToExecute'},
    }

    def __init__(
        self,
        *,
        scripts: Optional["ScriptsToExecute"] = None,
        **kwargs
    ):
        """
        :keyword scripts: Customized setup scripts.
        :paramtype scripts: ~azure.mgmt.machinelearningservices.models.ScriptsToExecute
        """
        super(SetupScripts, self).__init__(**kwargs)
        self.scripts = scripts


class SharedAccessSignature(msrest.serialization.Model):
    """SharedAccessSignature.

    :ivar sas:
    :vartype sas: str
    """

    _attribute_map = {
        'sas': {'key': 'sas', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sas: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword sas:
        :paramtype sas: str
        """
        super(SharedAccessSignature, self).__init__(**kwargs)
        self.sas = sas


class SharedPrivateLinkResource(msrest.serialization.Model):
    """SharedPrivateLinkResource.

    :ivar name: Unique name of the private link.
    :vartype name: str
    :ivar private_link_resource_id: The resource id that private link links to.
    :vartype private_link_resource_id: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar request_message: Request message.
    :vartype request_message: str
    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected", "Disconnected",
     "Timeout".
    :vartype status: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'request_message': {'key': 'properties.requestMessage', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        group_id: Optional[str] = None,
        request_message: Optional[str] = None,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        **kwargs
    ):
        """
        :keyword name: Unique name of the private link.
        :paramtype name: str
        :keyword private_link_resource_id: The resource id that private link links to.
        :paramtype private_link_resource_id: str
        :keyword group_id: The private link resource group id.
        :paramtype group_id: str
        :keyword request_message: Request message.
        :paramtype request_message: str
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Possible values include: "Pending", "Approved", "Rejected",
         "Disconnected", "Timeout".
        :paramtype status: str or
         ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
        """
        super(SharedPrivateLinkResource, self).__init__(**kwargs)
        self.name = name
        self.private_link_resource_id = private_link_resource_id
        self.group_id = group_id
        self.request_message = request_message
        self.status = status


class Sku(msrest.serialization.Model):
    """Sku of the resource.

    :ivar name: Name of the sku.
    :vartype name: str
    :ivar tier: Tier of the sku like Basic or Enterprise.
    :vartype tier: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the sku.
        :paramtype name: str
        :keyword tier: Tier of the sku like Basic or Enterprise.
        :paramtype tier: str
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class SslConfiguration(msrest.serialization.Model):
    """The ssl configuration for scoring.

    :ivar status: Enable or disable ssl for scoring. Possible values include: "Disabled",
     "Enabled", "Auto".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.SslConfigurationStatus
    :ivar cert: Cert data.
    :vartype cert: str
    :ivar key: Key data.
    :vartype key: str
    :ivar cname: CNAME of the cert.
    :vartype cname: str
    :ivar leaf_domain_label: Leaf domain label of public endpoint.
    :vartype leaf_domain_label: str
    :ivar overwrite_existing_domain: Indicates whether to overwrite existing domain label.
    :vartype overwrite_existing_domain: bool
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'cert': {'key': 'cert', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'cname': {'key': 'cname', 'type': 'str'},
        'leaf_domain_label': {'key': 'leafDomainLabel', 'type': 'str'},
        'overwrite_existing_domain': {'key': 'overwriteExistingDomain', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "SslConfigurationStatus"]] = None,
        cert: Optional[str] = None,
        key: Optional[str] = None,
        cname: Optional[str] = None,
        leaf_domain_label: Optional[str] = None,
        overwrite_existing_domain: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword status: Enable or disable ssl for scoring. Possible values include: "Disabled",
         "Enabled", "Auto".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.SslConfigurationStatus
        :keyword cert: Cert data.
        :paramtype cert: str
        :keyword key: Key data.
        :paramtype key: str
        :keyword cname: CNAME of the cert.
        :paramtype cname: str
        :keyword leaf_domain_label: Leaf domain label of public endpoint.
        :paramtype leaf_domain_label: str
        :keyword overwrite_existing_domain: Indicates whether to overwrite existing domain label.
        :paramtype overwrite_existing_domain: bool
        """
        super(SslConfiguration, self).__init__(**kwargs)
        self.status = status
        self.cert = cert
        self.key = key
        self.cname = cname
        self.leaf_domain_label = leaf_domain_label
        self.overwrite_existing_domain = overwrite_existing_domain


class SynapseSpark(Compute):
    """A SynapseSpark compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.SynapseSparkProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'SynapseSparkProperties'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        properties: Optional["SynapseSparkProperties"] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.SynapseSparkProperties
        """
        super(SynapseSpark, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'SynapseSpark'  # type: str
        self.properties = properties


class SynapseSparkProperties(msrest.serialization.Model):
    """SynapseSparkProperties.

    :ivar auto_scale_properties: Auto scale properties.
    :vartype auto_scale_properties: ~azure.mgmt.machinelearningservices.models.AutoScaleProperties
    :ivar auto_pause_properties: Auto pause properties.
    :vartype auto_pause_properties: ~azure.mgmt.machinelearningservices.models.AutoPauseProperties
    :ivar spark_version: Spark version.
    :vartype spark_version: str
    :ivar node_count: The number of compute nodes currently assigned to the compute.
    :vartype node_count: int
    :ivar node_size: Node size.
    :vartype node_size: str
    :ivar node_size_family: Node size family.
    :vartype node_size_family: str
    :ivar subscription_id: Azure subscription identifier.
    :vartype subscription_id: str
    :ivar resource_group: Name of the resource group in which workspace is located.
    :vartype resource_group: str
    :ivar workspace_name: Name of Azure Machine Learning workspace.
    :vartype workspace_name: str
    :ivar pool_name: Pool name.
    :vartype pool_name: str
    """

    _attribute_map = {
        'auto_scale_properties': {'key': 'autoScaleProperties', 'type': 'AutoScaleProperties'},
        'auto_pause_properties': {'key': 'autoPauseProperties', 'type': 'AutoPauseProperties'},
        'spark_version': {'key': 'sparkVersion', 'type': 'str'},
        'node_count': {'key': 'nodeCount', 'type': 'int'},
        'node_size': {'key': 'nodeSize', 'type': 'str'},
        'node_size_family': {'key': 'nodeSizeFamily', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'workspace_name': {'key': 'workspaceName', 'type': 'str'},
        'pool_name': {'key': 'poolName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auto_scale_properties: Optional["AutoScaleProperties"] = None,
        auto_pause_properties: Optional["AutoPauseProperties"] = None,
        spark_version: Optional[str] = None,
        node_count: Optional[int] = None,
        node_size: Optional[str] = None,
        node_size_family: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        workspace_name: Optional[str] = None,
        pool_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword auto_scale_properties: Auto scale properties.
        :paramtype auto_scale_properties:
         ~azure.mgmt.machinelearningservices.models.AutoScaleProperties
        :keyword auto_pause_properties: Auto pause properties.
        :paramtype auto_pause_properties:
         ~azure.mgmt.machinelearningservices.models.AutoPauseProperties
        :keyword spark_version: Spark version.
        :paramtype spark_version: str
        :keyword node_count: The number of compute nodes currently assigned to the compute.
        :paramtype node_count: int
        :keyword node_size: Node size.
        :paramtype node_size: str
        :keyword node_size_family: Node size family.
        :paramtype node_size_family: str
        :keyword subscription_id: Azure subscription identifier.
        :paramtype subscription_id: str
        :keyword resource_group: Name of the resource group in which workspace is located.
        :paramtype resource_group: str
        :keyword workspace_name: Name of Azure Machine Learning workspace.
        :paramtype workspace_name: str
        :keyword pool_name: Pool name.
        :paramtype pool_name: str
        """
        super(SynapseSparkProperties, self).__init__(**kwargs)
        self.auto_scale_properties = auto_scale_properties
        self.auto_pause_properties = auto_pause_properties
        self.spark_version = spark_version
        self.node_count = node_count
        self.node_size = node_size
        self.node_size_family = node_size_family
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.workspace_name = workspace_name
        self.pool_name = pool_name


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.machinelearningservices.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class SystemService(msrest.serialization.Model):
    """A system service running on a compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar system_service_type: The type of this system service.
    :vartype system_service_type: str
    :ivar public_ip_address: Public IP address.
    :vartype public_ip_address: str
    :ivar version: The version for this type.
    :vartype version: str
    """

    _validation = {
        'system_service_type': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'system_service_type': {'key': 'systemServiceType', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SystemService, self).__init__(**kwargs)
        self.system_service_type = None
        self.public_ip_address = None
        self.version = None


class UpdateWorkspaceQuotas(msrest.serialization.Model):
    """The properties for update Quota response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar limit: The maximum permitted quota of the resource.
    :vartype limit: long
    :ivar unit: An enum describing the unit of quota measurement. Possible values include: "Count".
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
    :ivar status: Status of update workspace quota. Possible values include: "Undefined",
     "Success", "Failure", "InvalidQuotaBelowClusterMinimum",
     "InvalidQuotaExceedsSubscriptionLimit", "InvalidVMFamilyName", "OperationNotSupportedForSku",
     "OperationNotEnabledForRegion".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.Status
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        limit: Optional[int] = None,
        status: Optional[Union[str, "Status"]] = None,
        **kwargs
    ):
        """
        :keyword limit: The maximum permitted quota of the resource.
        :paramtype limit: long
        :keyword status: Status of update workspace quota. Possible values include: "Undefined",
         "Success", "Failure", "InvalidQuotaBelowClusterMinimum",
         "InvalidQuotaExceedsSubscriptionLimit", "InvalidVMFamilyName", "OperationNotSupportedForSku",
         "OperationNotEnabledForRegion".
        :paramtype status: str or ~azure.mgmt.machinelearningservices.models.Status
        """
        super(UpdateWorkspaceQuotas, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.limit = limit
        self.unit = None
        self.status = status


class UpdateWorkspaceQuotasResult(msrest.serialization.Model):
    """The result of update workspace quota.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of workspace quota update result.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.UpdateWorkspaceQuotas]
    :ivar next_link: The URI to fetch the next page of workspace quota update result. Call
     ListNext() with this to fetch the next page of Workspace Quota update result.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpdateWorkspaceQuotas]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UpdateWorkspaceQuotasResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Usage(msrest.serialization.Model):
    """Describes AML Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar aml_workspace_location: Region of the AML workspace in the id.
    :vartype aml_workspace_location: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar unit: An enum describing the unit of usage measurement. Possible values include: "Count".
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.UsageUnit
    :ivar current_value: The current usage of the resource.
    :vartype current_value: long
    :ivar limit: The maximum permitted usage of the resource.
    :vartype limit: long
    :ivar name: The name of the type of usage.
    :vartype name: ~azure.mgmt.machinelearningservices.models.UsageName
    """

    _validation = {
        'id': {'readonly': True},
        'aml_workspace_location': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'aml_workspace_location': {'key': 'amlWorkspaceLocation', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.aml_workspace_location = None
        self.type = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageName(msrest.serialization.Model):
    """The Usage Names.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UsageName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class UserAccountCredentials(msrest.serialization.Model):
    """Settings for user account that gets created on each on the nodes of a compute.

    All required parameters must be populated in order to send to Azure.

    :ivar admin_user_name: Required. Name of the administrator user account which can be used to
     SSH to nodes.
    :vartype admin_user_name: str
    :ivar admin_user_ssh_public_key: SSH public key of the administrator user account.
    :vartype admin_user_ssh_public_key: str
    :ivar admin_user_password: Password of the administrator user account.
    :vartype admin_user_password: str
    """

    _validation = {
        'admin_user_name': {'required': True},
    }

    _attribute_map = {
        'admin_user_name': {'key': 'adminUserName', 'type': 'str'},
        'admin_user_ssh_public_key': {'key': 'adminUserSshPublicKey', 'type': 'str'},
        'admin_user_password': {'key': 'adminUserPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        admin_user_name: str,
        admin_user_ssh_public_key: Optional[str] = None,
        admin_user_password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword admin_user_name: Required. Name of the administrator user account which can be used to
         SSH to nodes.
        :paramtype admin_user_name: str
        :keyword admin_user_ssh_public_key: SSH public key of the administrator user account.
        :paramtype admin_user_ssh_public_key: str
        :keyword admin_user_password: Password of the administrator user account.
        :paramtype admin_user_password: str
        """
        super(UserAccountCredentials, self).__init__(**kwargs)
        self.admin_user_name = admin_user_name
        self.admin_user_ssh_public_key = admin_user_ssh_public_key
        self.admin_user_password = admin_user_password


class UserAssignedIdentity(msrest.serialization.Model):
    """User Assigned Identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the user assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the user assigned identity.
    :vartype tenant_id: str
    :ivar client_id: The clientId(aka appId) of the user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.client_id = None


class UsernamePassword(msrest.serialization.Model):
    """UsernamePassword.

    :ivar username:
    :vartype username: str
    :ivar password:
    :vartype password: str
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword username:
        :paramtype username: str
        :keyword password:
        :paramtype password: str
        """
        super(UsernamePassword, self).__init__(**kwargs)
        self.username = username
        self.password = password


class UsernamePasswordAuthTypeWorkspaceConnectionProperties(WorkspaceConnectionPropertiesV2):
    """UsernamePasswordAuthTypeWorkspaceConnectionProperties.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Required. Authentication type of the connection target.Constant filled by
     server. Possible values include: "PAT", "ManagedIdentity", "UsernamePassword", "None", "SAS",
     "ServicePrincipal".
    :vartype auth_type: str or ~azure.mgmt.machinelearningservices.models.ConnectionAuthType
    :ivar category: Category of the connection. Possible values include: "PythonFeed",
     "ContainerRegistry", "Git", "FeatureStore".
    :vartype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
    :ivar target:
    :vartype target: str
    :ivar value: Value details of the workspace connection.
    :vartype value: str
    :ivar value_format: format for the workspace connection value. Possible values include: "JSON".
    :vartype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
    :ivar metadata: Other Metadata that we would like to store with workspace connection.
    :vartype metadata: dict[str, any]
    :ivar credentials:
    :vartype credentials: ~azure.mgmt.machinelearningservices.models.UsernamePassword
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'value_format': {'key': 'valueFormat', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': '{object}'},
        'credentials': {'key': 'credentials', 'type': 'UsernamePassword'},
    }

    def __init__(
        self,
        *,
        category: Optional[Union[str, "ConnectionCategory"]] = None,
        target: Optional[str] = None,
        value: Optional[str] = None,
        value_format: Optional[Union[str, "ValueFormat"]] = None,
        metadata: Optional[Dict[str, Any]] = None,
        credentials: Optional["UsernamePassword"] = None,
        **kwargs
    ):
        """
        :keyword category: Category of the connection. Possible values include: "PythonFeed",
         "ContainerRegistry", "Git", "FeatureStore".
        :paramtype category: str or ~azure.mgmt.machinelearningservices.models.ConnectionCategory
        :keyword target:
        :paramtype target: str
        :keyword value: Value details of the workspace connection.
        :paramtype value: str
        :keyword value_format: format for the workspace connection value. Possible values include:
         "JSON".
        :paramtype value_format: str or ~azure.mgmt.machinelearningservices.models.ValueFormat
        :keyword metadata: Other Metadata that we would like to store with workspace connection.
        :paramtype metadata: dict[str, any]
        :keyword credentials:
        :paramtype credentials: ~azure.mgmt.machinelearningservices.models.UsernamePassword
        """
        super(UsernamePasswordAuthTypeWorkspaceConnectionProperties, self).__init__(category=category, target=target, value=value, value_format=value_format, metadata=metadata, **kwargs)
        self.auth_type = 'UsernamePassword'  # type: str
        self.credentials = credentials


class VirtualMachine(Compute):
    """A Machine Learning compute based on Azure Virtual Machines.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar compute_location: Location for the underlying compute.
    :vartype compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar description: The description of the Machine Learning compute.
    :vartype description: str
    :ivar created_on: The time at which the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The time at which the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :ivar resource_id: ARM resource id of the underlying compute.
    :vartype resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors: list[~azure.mgmt.machinelearningservices.models.ErrorResponse]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :ivar disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI
     and AAD exclusively for authentication.
    :vartype disable_local_auth: bool
    :ivar properties:
    :vartype properties: ~azure.mgmt.machinelearningservices.models.VirtualMachineProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[ErrorResponse]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'disable_local_auth': {'key': 'disableLocalAuth', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'VirtualMachineProperties'},
    }

    def __init__(
        self,
        *,
        compute_location: Optional[str] = None,
        description: Optional[str] = None,
        resource_id: Optional[str] = None,
        disable_local_auth: Optional[bool] = None,
        properties: Optional["VirtualMachineProperties"] = None,
        **kwargs
    ):
        """
        :keyword compute_location: Location for the underlying compute.
        :paramtype compute_location: str
        :keyword description: The description of the Machine Learning compute.
        :paramtype description: str
        :keyword resource_id: ARM resource id of the underlying compute.
        :paramtype resource_id: str
        :keyword disable_local_auth: Opt-out of local authentication and ensure customers can use only
         MSI and AAD exclusively for authentication.
        :paramtype disable_local_auth: bool
        :keyword properties:
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.VirtualMachineProperties
        """
        super(VirtualMachine, self).__init__(compute_location=compute_location, description=description, resource_id=resource_id, disable_local_auth=disable_local_auth, **kwargs)
        self.compute_type = 'VirtualMachine'  # type: str
        self.properties = properties


class VirtualMachineImage(msrest.serialization.Model):
    """Virtual Machine image for Windows AML Compute.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Virtual Machine image path.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. Virtual Machine image path.
        :paramtype id: str
        """
        super(VirtualMachineImage, self).__init__(**kwargs)
        self.id = id


class VirtualMachineProperties(msrest.serialization.Model):
    """VirtualMachineProperties.

    :ivar virtual_machine_size: Virtual Machine size.
    :vartype virtual_machine_size: str
    :ivar ssh_port: Port open for ssh connections.
    :vartype ssh_port: int
    :ivar address: Public IP address of the virtual machine.
    :vartype address: str
    :ivar administrator_account: Admin credentials for virtual machine.
    :vartype administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    :ivar is_notebook_instance_compute: Indicates whether this compute will be used for running
     notebooks.
    :vartype is_notebook_instance_compute: bool
    """

    _attribute_map = {
        'virtual_machine_size': {'key': 'virtualMachineSize', 'type': 'str'},
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'address': {'key': 'address', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
        'is_notebook_instance_compute': {'key': 'isNotebookInstanceCompute', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        virtual_machine_size: Optional[str] = None,
        ssh_port: Optional[int] = None,
        address: Optional[str] = None,
        administrator_account: Optional["VirtualMachineSshCredentials"] = None,
        is_notebook_instance_compute: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword virtual_machine_size: Virtual Machine size.
        :paramtype virtual_machine_size: str
        :keyword ssh_port: Port open for ssh connections.
        :paramtype ssh_port: int
        :keyword address: Public IP address of the virtual machine.
        :paramtype address: str
        :keyword administrator_account: Admin credentials for virtual machine.
        :paramtype administrator_account:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
        :keyword is_notebook_instance_compute: Indicates whether this compute will be used for running
         notebooks.
        :paramtype is_notebook_instance_compute: bool
        """
        super(VirtualMachineProperties, self).__init__(**kwargs)
        self.virtual_machine_size = virtual_machine_size
        self.ssh_port = ssh_port
        self.address = address
        self.administrator_account = administrator_account
        self.is_notebook_instance_compute = is_notebook_instance_compute


class VirtualMachineSecrets(ComputeSecrets):
    """Secrets related to a Machine Learning compute based on AKS.

    All required parameters must be populated in order to send to Azure.

    :ivar compute_type: Required. The type of compute.Constant filled by server. Possible values
     include: "AKS", "Kubernetes", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine",
     "HDInsight", "Databricks", "DataLakeAnalytics", "SynapseSpark".
    :vartype compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar administrator_account: Admin credentials for virtual machine.
    :vartype administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(
        self,
        *,
        administrator_account: Optional["VirtualMachineSshCredentials"] = None,
        **kwargs
    ):
        """
        :keyword administrator_account: Admin credentials for virtual machine.
        :paramtype administrator_account:
         ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
        """
        super(VirtualMachineSecrets, self).__init__(**kwargs)
        self.compute_type = 'VirtualMachine'  # type: str
        self.administrator_account = administrator_account


class VirtualMachineSize(msrest.serialization.Model):
    """Describes the properties of a VM size.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the virtual machine size.
    :vartype name: str
    :ivar family: The family name of the virtual machine size.
    :vartype family: str
    :ivar v_cp_us: The number of vCPUs supported by the virtual machine size.
    :vartype v_cp_us: int
    :ivar gpus: The number of gPUs supported by the virtual machine size.
    :vartype gpus: int
    :ivar os_vhd_size_mb: The OS VHD disk size, in MB, allowed by the virtual machine size.
    :vartype os_vhd_size_mb: int
    :ivar max_resource_volume_mb: The resource volume size, in MB, allowed by the virtual machine
     size.
    :vartype max_resource_volume_mb: int
    :ivar memory_gb: The amount of memory, in GB, supported by the virtual machine size.
    :vartype memory_gb: float
    :ivar low_priority_capable: Specifies if the virtual machine size supports low priority VMs.
    :vartype low_priority_capable: bool
    :ivar premium_io: Specifies if the virtual machine size supports premium IO.
    :vartype premium_io: bool
    :ivar estimated_vm_prices: The estimated price information for using a VM.
    :vartype estimated_vm_prices: ~azure.mgmt.machinelearningservices.models.EstimatedVMPrices
    :ivar supported_compute_types: Specifies the compute types supported by the virtual machine
     size.
    :vartype supported_compute_types: list[str]
    """

    _validation = {
        'name': {'readonly': True},
        'family': {'readonly': True},
        'v_cp_us': {'readonly': True},
        'gpus': {'readonly': True},
        'os_vhd_size_mb': {'readonly': True},
        'max_resource_volume_mb': {'readonly': True},
        'memory_gb': {'readonly': True},
        'low_priority_capable': {'readonly': True},
        'premium_io': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'v_cp_us': {'key': 'vCPUs', 'type': 'int'},
        'gpus': {'key': 'gpus', 'type': 'int'},
        'os_vhd_size_mb': {'key': 'osVhdSizeMB', 'type': 'int'},
        'max_resource_volume_mb': {'key': 'maxResourceVolumeMB', 'type': 'int'},
        'memory_gb': {'key': 'memoryGB', 'type': 'float'},
        'low_priority_capable': {'key': 'lowPriorityCapable', 'type': 'bool'},
        'premium_io': {'key': 'premiumIO', 'type': 'bool'},
        'estimated_vm_prices': {'key': 'estimatedVMPrices', 'type': 'EstimatedVMPrices'},
        'supported_compute_types': {'key': 'supportedComputeTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        estimated_vm_prices: Optional["EstimatedVMPrices"] = None,
        supported_compute_types: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword estimated_vm_prices: The estimated price information for using a VM.
        :paramtype estimated_vm_prices: ~azure.mgmt.machinelearningservices.models.EstimatedVMPrices
        :keyword supported_compute_types: Specifies the compute types supported by the virtual machine
         size.
        :paramtype supported_compute_types: list[str]
        """
        super(VirtualMachineSize, self).__init__(**kwargs)
        self.name = None
        self.family = None
        self.v_cp_us = None
        self.gpus = None
        self.os_vhd_size_mb = None
        self.max_resource_volume_mb = None
        self.memory_gb = None
        self.low_priority_capable = None
        self.premium_io = None
        self.estimated_vm_prices = estimated_vm_prices
        self.supported_compute_types = supported_compute_types


class VirtualMachineSizeListResult(msrest.serialization.Model):
    """The List Virtual Machine size operation response.

    :ivar value: The list of virtual machine sizes supported by AmlCompute.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.VirtualMachineSize]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineSize]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualMachineSize"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of virtual machine sizes supported by AmlCompute.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.VirtualMachineSize]
        """
        super(VirtualMachineSizeListResult, self).__init__(**kwargs)
        self.value = value


class VirtualMachineSshCredentials(msrest.serialization.Model):
    """Admin credentials for virtual machine.

    :ivar username: Username of admin account.
    :vartype username: str
    :ivar password: Password of admin account.
    :vartype password: str
    :ivar public_key_data: Public key data.
    :vartype public_key_data: str
    :ivar private_key_data: Private key data.
    :vartype private_key_data: str
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'public_key_data': {'key': 'publicKeyData', 'type': 'str'},
        'private_key_data': {'key': 'privateKeyData', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
        public_key_data: Optional[str] = None,
        private_key_data: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword username: Username of admin account.
        :paramtype username: str
        :keyword password: Password of admin account.
        :paramtype password: str
        :keyword public_key_data: Public key data.
        :paramtype public_key_data: str
        :keyword private_key_data: Private key data.
        :paramtype private_key_data: str
        """
        super(VirtualMachineSshCredentials, self).__init__(**kwargs)
        self.username = username
        self.password = password
        self.public_key_data = public_key_data
        self.private_key_data = private_key_data


class Workspace(Resource):
    """An object that represents a machine learning workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.Identity
    :ivar location: Specifies the location of the resource.
    :vartype location: str
    :ivar tags: A set of tags. Contains resource tags defined as key/value pairs.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar system_data: System data.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar workspace_id: The immutable id associated with this workspace.
    :vartype workspace_id: str
    :ivar description: The description of this workspace.
    :vartype description: str
    :ivar friendly_name: The friendly name for this workspace. This name in mutable.
    :vartype friendly_name: str
    :ivar key_vault: ARM id of the key vault associated with this workspace. This cannot be changed
     once the workspace has been created.
    :vartype key_vault: str
    :ivar application_insights: ARM id of the application insights associated with this workspace.
     This cannot be changed once the workspace has been created.
    :vartype application_insights: str
    :ivar container_registry: ARM id of the container registry associated with this workspace. This
     cannot be changed once the workspace has been created.
    :vartype container_registry: str
    :ivar storage_account: ARM id of the storage account associated with this workspace. This
     cannot be changed once the workspace has been created.
    :vartype storage_account: str
    :ivar discovery_url: Url for the discovery service to identify regional endpoints for machine
     learning experimentation services.
    :vartype discovery_url: str
    :ivar provisioning_state: The current deployment state of workspace resource. The
     provisioningState is to indicate states for resource provisioning. Possible values include:
     "Unknown", "Updating", "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :ivar encryption: The encryption settings of Azure ML workspace.
    :vartype encryption: ~azure.mgmt.machinelearningservices.models.EncryptionProperty
    :ivar hbi_workspace: The flag to signal HBI data in the workspace and reduce diagnostic data
     collected by the service.
    :vartype hbi_workspace: bool
    :ivar soft_delete_enabled: create a workspace with soft delete capability. Possible values
     include: "True", "False".
    :vartype soft_delete_enabled: str or
     ~azure.mgmt.machinelearningservices.models.SoftDeleteEnabled
    :ivar allow_recover_soft_deleted_workspace: Allow a soft deleted workspace to be recovered.
     Possible values include: "True", "False".
    :vartype allow_recover_soft_deleted_workspace: str or
     ~azure.mgmt.machinelearningservices.models.AllowRecoverSoftDeletedWorkspace
    :ivar service_provisioned_resource_group: The name of the managed resource group created by
     workspace RP in customer subscription if the workspace is CMK workspace.
    :vartype service_provisioned_resource_group: str
    :ivar private_link_count: Count of private connections in the workspace.
    :vartype private_link_count: int
    :ivar image_build_compute: The compute name for image build.
    :vartype image_build_compute: str
    :ivar allow_public_access_when_behind_vnet: The flag to indicate whether to allow public access
     when behind VNet.
    :vartype allow_public_access_when_behind_vnet: bool
    :ivar public_network_access: Whether requests from Public Network are allowed. Possible values
     include: "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.PublicNetworkAccess
    :ivar private_endpoint_connections: The list of private endpoint connections in the workspace.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
    :ivar shared_private_link_resources: The list of shared private link resources in this
     workspace.
    :vartype shared_private_link_resources:
     list[~azure.mgmt.machinelearningservices.models.SharedPrivateLinkResource]
    :ivar notebook_info: The notebook info of Azure ML workspace.
    :vartype notebook_info: ~azure.mgmt.machinelearningservices.models.NotebookResourceInfo
    :ivar service_managed_resources_settings: The service managed resource settings.
    :vartype service_managed_resources_settings:
     ~azure.mgmt.machinelearningservices.models.ServiceManagedResourcesSettings
    :ivar primary_user_assigned_identity: The user assigned identity resource id that represents
     the workspace identity.
    :vartype primary_user_assigned_identity: str
    :ivar tenant_id: The tenant id associated with this workspace.
    :vartype tenant_id: str
    :ivar storage_hns_enabled: If the storage associated with the workspace has hierarchical
     namespace(HNS) enabled.
    :vartype storage_hns_enabled: bool
    :ivar ml_flow_tracking_uri: The URI associated with this workspace that machine learning flow
     must point at to set up tracking.
    :vartype ml_flow_tracking_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'workspace_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'service_provisioned_resource_group': {'readonly': True},
        'private_link_count': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'notebook_info': {'readonly': True},
        'tenant_id': {'readonly': True},
        'storage_hns_enabled': {'readonly': True},
        'ml_flow_tracking_uri': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'str'},
        'application_insights': {'key': 'properties.applicationInsights', 'type': 'str'},
        'container_registry': {'key': 'properties.containerRegistry', 'type': 'str'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'str'},
        'discovery_url': {'key': 'properties.discoveryUrl', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperty'},
        'hbi_workspace': {'key': 'properties.hbiWorkspace', 'type': 'bool'},
        'soft_delete_enabled': {'key': 'properties.softDeleteEnabled', 'type': 'str'},
        'allow_recover_soft_deleted_workspace': {'key': 'properties.allowRecoverSoftDeletedWorkspace', 'type': 'str'},
        'service_provisioned_resource_group': {'key': 'properties.serviceProvisionedResourceGroup', 'type': 'str'},
        'private_link_count': {'key': 'properties.privateLinkCount', 'type': 'int'},
        'image_build_compute': {'key': 'properties.imageBuildCompute', 'type': 'str'},
        'allow_public_access_when_behind_vnet': {'key': 'properties.allowPublicAccessWhenBehindVnet', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'shared_private_link_resources': {'key': 'properties.sharedPrivateLinkResources', 'type': '[SharedPrivateLinkResource]'},
        'notebook_info': {'key': 'properties.notebookInfo', 'type': 'NotebookResourceInfo'},
        'service_managed_resources_settings': {'key': 'properties.serviceManagedResourcesSettings', 'type': 'ServiceManagedResourcesSettings'},
        'primary_user_assigned_identity': {'key': 'properties.primaryUserAssignedIdentity', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'storage_hns_enabled': {'key': 'properties.storageHnsEnabled', 'type': 'bool'},
        'ml_flow_tracking_uri': {'key': 'properties.mlFlowTrackingUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        identity: Optional["Identity"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        key_vault: Optional[str] = None,
        application_insights: Optional[str] = None,
        container_registry: Optional[str] = None,
        storage_account: Optional[str] = None,
        discovery_url: Optional[str] = None,
        encryption: Optional["EncryptionProperty"] = None,
        hbi_workspace: Optional[bool] = False,
        soft_delete_enabled: Optional[Union[str, "SoftDeleteEnabled"]] = None,
        allow_recover_soft_deleted_workspace: Optional[Union[str, "AllowRecoverSoftDeletedWorkspace"]] = None,
        image_build_compute: Optional[str] = None,
        allow_public_access_when_behind_vnet: Optional[bool] = False,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        shared_private_link_resources: Optional[List["SharedPrivateLinkResource"]] = None,
        service_managed_resources_settings: Optional["ServiceManagedResourcesSettings"] = None,
        primary_user_assigned_identity: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.Identity
        :keyword location: Specifies the location of the resource.
        :paramtype location: str
        :keyword tags: A set of tags. Contains resource tags defined as key/value pairs.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword description: The description of this workspace.
        :paramtype description: str
        :keyword friendly_name: The friendly name for this workspace. This name in mutable.
        :paramtype friendly_name: str
        :keyword key_vault: ARM id of the key vault associated with this workspace. This cannot be
         changed once the workspace has been created.
        :paramtype key_vault: str
        :keyword application_insights: ARM id of the application insights associated with this
         workspace. This cannot be changed once the workspace has been created.
        :paramtype application_insights: str
        :keyword container_registry: ARM id of the container registry associated with this workspace.
         This cannot be changed once the workspace has been created.
        :paramtype container_registry: str
        :keyword storage_account: ARM id of the storage account associated with this workspace. This
         cannot be changed once the workspace has been created.
        :paramtype storage_account: str
        :keyword discovery_url: Url for the discovery service to identify regional endpoints for
         machine learning experimentation services.
        :paramtype discovery_url: str
        :keyword encryption: The encryption settings of Azure ML workspace.
        :paramtype encryption: ~azure.mgmt.machinelearningservices.models.EncryptionProperty
        :keyword hbi_workspace: The flag to signal HBI data in the workspace and reduce diagnostic data
         collected by the service.
        :paramtype hbi_workspace: bool
        :keyword soft_delete_enabled: create a workspace with soft delete capability. Possible values
         include: "True", "False".
        :paramtype soft_delete_enabled: str or
         ~azure.mgmt.machinelearningservices.models.SoftDeleteEnabled
        :keyword allow_recover_soft_deleted_workspace: Allow a soft deleted workspace to be recovered.
         Possible values include: "True", "False".
        :paramtype allow_recover_soft_deleted_workspace: str or
         ~azure.mgmt.machinelearningservices.models.AllowRecoverSoftDeletedWorkspace
        :keyword image_build_compute: The compute name for image build.
        :paramtype image_build_compute: str
        :keyword allow_public_access_when_behind_vnet: The flag to indicate whether to allow public
         access when behind VNet.
        :paramtype allow_public_access_when_behind_vnet: bool
        :keyword public_network_access: Whether requests from Public Network are allowed. Possible
         values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.PublicNetworkAccess
        :keyword shared_private_link_resources: The list of shared private link resources in this
         workspace.
        :paramtype shared_private_link_resources:
         list[~azure.mgmt.machinelearningservices.models.SharedPrivateLinkResource]
        :keyword service_managed_resources_settings: The service managed resource settings.
        :paramtype service_managed_resources_settings:
         ~azure.mgmt.machinelearningservices.models.ServiceManagedResourcesSettings
        :keyword primary_user_assigned_identity: The user assigned identity resource id that represents
         the workspace identity.
        :paramtype primary_user_assigned_identity: str
        """
        super(Workspace, self).__init__(**kwargs)
        self.identity = identity
        self.location = location
        self.tags = tags
        self.sku = sku
        self.system_data = None
        self.workspace_id = None
        self.description = description
        self.friendly_name = friendly_name
        self.key_vault = key_vault
        self.application_insights = application_insights
        self.container_registry = container_registry
        self.storage_account = storage_account
        self.discovery_url = discovery_url
        self.provisioning_state = None
        self.encryption = encryption
        self.hbi_workspace = hbi_workspace
        self.soft_delete_enabled = soft_delete_enabled
        self.allow_recover_soft_deleted_workspace = allow_recover_soft_deleted_workspace
        self.service_provisioned_resource_group = None
        self.private_link_count = None
        self.image_build_compute = image_build_compute
        self.allow_public_access_when_behind_vnet = allow_public_access_when_behind_vnet
        self.public_network_access = public_network_access
        self.private_endpoint_connections = None
        self.shared_private_link_resources = shared_private_link_resources
        self.notebook_info = None
        self.service_managed_resources_settings = service_managed_resources_settings
        self.primary_user_assigned_identity = primary_user_assigned_identity
        self.tenant_id = None
        self.storage_hns_enabled = None
        self.ml_flow_tracking_uri = None


class WorkspaceConnectionPropertiesV2BasicResource(ResourceAutoGenerated):
    """WorkspaceConnectionPropertiesV2BasicResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar properties: Required.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'WorkspaceConnectionPropertiesV2'},
    }

    def __init__(
        self,
        *,
        properties: "WorkspaceConnectionPropertiesV2",
        **kwargs
    ):
        """
        :keyword properties: Required.
        :paramtype properties:
         ~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2
        """
        super(WorkspaceConnectionPropertiesV2BasicResource, self).__init__(**kwargs)
        self.properties = properties


class WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult(msrest.serialization.Model):
    """WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value:
     list[~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2BasicResource]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkspaceConnectionPropertiesV2BasicResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["WorkspaceConnectionPropertiesV2BasicResource"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value:
         list[~azure.mgmt.machinelearningservices.models.WorkspaceConnectionPropertiesV2BasicResource]
        """
        super(WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class WorkspaceListResult(msrest.serialization.Model):
    """The result of a request to list machine learning workspaces.

    :ivar value: The list of machine learning workspaces. Since this list may be incomplete, the
     nextLink field should be used to request the next list of machine learning workspaces.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Workspace]
    :ivar next_link: The URI that can be used to request the next list of machine learning
     workspaces.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workspace]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Workspace"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of machine learning workspaces. Since this list may be incomplete, the
         nextLink field should be used to request the next list of machine learning workspaces.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Workspace]
        :keyword next_link: The URI that can be used to request the next list of machine learning
         workspaces.
        :paramtype next_link: str
        """
        super(WorkspaceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkspaceUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a machine learning workspace.

    :ivar tags: A set of tags. The resource tags for the machine learning workspace.
    :vartype tags: dict[str, str]
    :ivar sku: The sku of the workspace.
    :vartype sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.machinelearningservices.models.Identity
    :ivar description: The description of this workspace.
    :vartype description: str
    :ivar friendly_name: The friendly name for this workspace.
    :vartype friendly_name: str
    :ivar image_build_compute: The compute name for image build.
    :vartype image_build_compute: str
    :ivar service_managed_resources_settings: The service managed resource settings.
    :vartype service_managed_resources_settings:
     ~azure.mgmt.machinelearningservices.models.ServiceManagedResourcesSettings
    :ivar primary_user_assigned_identity: The user assigned identity resource id that represents
     the workspace identity.
    :vartype primary_user_assigned_identity: str
    :ivar public_network_access: Whether requests from Public Network are allowed. Possible values
     include: "Enabled", "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.machinelearningservices.models.PublicNetworkAccess
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'image_build_compute': {'key': 'properties.imageBuildCompute', 'type': 'str'},
        'service_managed_resources_settings': {'key': 'properties.serviceManagedResourcesSettings', 'type': 'ServiceManagedResourcesSettings'},
        'primary_user_assigned_identity': {'key': 'properties.primaryUserAssignedIdentity', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        identity: Optional["Identity"] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        image_build_compute: Optional[str] = None,
        service_managed_resources_settings: Optional["ServiceManagedResourcesSettings"] = None,
        primary_user_assigned_identity: Optional[str] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The resource tags for the machine learning workspace.
        :paramtype tags: dict[str, str]
        :keyword sku: The sku of the workspace.
        :paramtype sku: ~azure.mgmt.machinelearningservices.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.machinelearningservices.models.Identity
        :keyword description: The description of this workspace.
        :paramtype description: str
        :keyword friendly_name: The friendly name for this workspace.
        :paramtype friendly_name: str
        :keyword image_build_compute: The compute name for image build.
        :paramtype image_build_compute: str
        :keyword service_managed_resources_settings: The service managed resource settings.
        :paramtype service_managed_resources_settings:
         ~azure.mgmt.machinelearningservices.models.ServiceManagedResourcesSettings
        :keyword primary_user_assigned_identity: The user assigned identity resource id that represents
         the workspace identity.
        :paramtype primary_user_assigned_identity: str
        :keyword public_network_access: Whether requests from Public Network are allowed. Possible
         values include: "Enabled", "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.machinelearningservices.models.PublicNetworkAccess
        """
        super(WorkspaceUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.identity = identity
        self.description = description
        self.friendly_name = friendly_name
        self.image_build_compute = image_build_compute
        self.service_managed_resources_settings = service_managed_resources_settings
        self.primary_user_assigned_identity = primary_user_assigned_identity
        self.public_network_access = public_network_access
