# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.avs.aio import AVSClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAVSClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AVSClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_clusters_list(self, resource_group):
        response = self.client.clusters.list(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_clusters_get(self, resource_group):
        response = await self.client.clusters.get(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_clusters_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.clusters.begin_create_or_update(
                resource_group_name=resource_group.name,
                private_cloud_name="str",
                cluster_name="str",
                cluster={
                    "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "clusterId": 0,
                        "clusterSize": 0,
                        "hosts": ["str"],
                        "provisioningState": "str",
                        "vsanDatastoreName": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_clusters_begin_update(self, resource_group):
        response = await (
            await self.client.clusters.begin_update(
                resource_group_name=resource_group.name,
                private_cloud_name="str",
                cluster_name="str",
                cluster_update={
                    "properties": {"clusterSize": 0, "hosts": ["str"]},
                    "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_clusters_begin_delete(self, resource_group):
        response = await (
            await self.client.clusters.begin_delete(
                resource_group_name=resource_group.name,
                private_cloud_name="str",
                cluster_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_clusters_list_zones(self, resource_group):
        response = await self.client.clusters.list_zones(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
        )

        # please add some check logic here by yourself
        # ...
