# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the action to take on rule match.
    """

    ALLOW = "Allow"
    BLOCK = "Block"
    LOG = "Log"
    REDIRECT = "Redirect"

class Algorithm(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Algorithm to use for URL signing
    """

    SHA256 = "SHA256"

class CacheBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Caching behavior for the requests
    """

    BYPASS_CACHE = "BypassCache"
    OVERRIDE = "Override"
    SET_IF_MISSING = "SetIfMissing"

class CacheType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The level at which the content needs to be cached.
    """

    ALL = "All"

class CertificateSource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the source of the SSL certificate.
    """

    AZURE_KEY_VAULT = "AzureKeyVault"
    CDN = "Cdn"

class CertificateType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of certificate used
    """

    SHARED = "Shared"
    DEDICATED = "Dedicated"

class CookiesOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"

class CustomDomainResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the custom domain.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"

class CustomHttpsProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning status of Custom Https of the custom domain.
    """

    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    FAILED = "Failed"

class CustomHttpsProvisioningSubstate(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by
    step.
    """

    SUBMITTING_DOMAIN_CONTROL_VALIDATION_REQUEST = "SubmittingDomainControlValidationRequest"
    PENDING_DOMAIN_CONTROL_VALIDATION_R_EQUEST_APPROVAL = "PendingDomainControlValidationREquestApproval"
    DOMAIN_CONTROL_VALIDATION_REQUEST_APPROVED = "DomainControlValidationRequestApproved"
    DOMAIN_CONTROL_VALIDATION_REQUEST_REJECTED = "DomainControlValidationRequestRejected"
    DOMAIN_CONTROL_VALIDATION_REQUEST_TIMED_OUT = "DomainControlValidationRequestTimedOut"
    ISSUING_CERTIFICATE = "IssuingCertificate"
    DEPLOYING_CERTIFICATE = "DeployingCertificate"
    CERTIFICATE_DEPLOYED = "CertificateDeployed"
    DELETING_CERTIFICATE = "DeletingCertificate"
    CERTIFICATE_DELETED = "CertificateDeleted"

class CustomRuleEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class DeleteRule(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes the action that shall be taken when the certificate is removed from Key Vault.
    """

    NO_ACTION = "NoAction"

class DeliveryRuleActionName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the action for the delivery rule.
    """

    CACHE_EXPIRATION = "CacheExpiration"
    CACHE_KEY_QUERY_STRING = "CacheKeyQueryString"
    MODIFY_REQUEST_HEADER = "ModifyRequestHeader"
    MODIFY_RESPONSE_HEADER = "ModifyResponseHeader"
    URL_REDIRECT = "UrlRedirect"
    URL_REWRITE = "UrlRewrite"
    URL_SIGNING = "UrlSigning"

class DestinationProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol to use for the redirect. The default value is MatchRequest
    """

    MATCH_REQUEST = "MatchRequest"
    HTTP = "Http"
    HTTPS = "Https"

class EndpointResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the endpoint.
    """

    CREATING = "Creating"
    DELETING = "Deleting"
    RUNNING = "Running"
    STARTING = "Starting"
    STOPPED = "Stopped"
    STOPPING = "Stopping"

class Enum16(with_metaclass(_CaseInsensitiveEnumMeta, int, Enum)):
    """If the action type is block, this field defines the default customer overridable http response
    status code.
    """

    TWO_HUNDRED = 200
    FOUR_HUNDRED_THREE = 403
    FOUR_HUNDRED_FIVE = 405
    FOUR_HUNDRED_SIX = 406
    FOUR_HUNDRED_TWENTY_NINE = 429

class GeoFilterActions(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Action of the geo filter, i.e. allow or block access.
    """

    BLOCK = "Block"
    ALLOW = "Allow"

class HeaderAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Action to perform
    """

    APPEND = "Append"
    OVERWRITE = "Overwrite"
    DELETE = "Delete"

class HealthProbeRequestType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of health probe request that is made.
    """

    NOT_SET = "NotSet"
    GET = "GET"
    HEAD = "HEAD"

class HttpVersionOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class IsDeviceMatchConditionParametersMatchValuesItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    MOBILE = "Mobile"
    DESKTOP = "Desktop"

class IsDeviceOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class ManagedRuleEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class MatchVariable(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the condition for the delivery rule.
    """

    REMOTE_ADDRESS = "RemoteAddress"
    REQUEST_METHOD = "RequestMethod"
    QUERY_STRING = "QueryString"
    POST_ARGS = "PostArgs"
    REQUEST_URI = "RequestUri"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_BODY = "RequestBody"
    REQUEST_SCHEME = "RequestScheme"
    URL_PATH = "UrlPath"
    URL_FILE_EXTENSION = "UrlFileExtension"
    URL_FILE_NAME = "UrlFileName"
    HTTP_VERSION = "HttpVersion"
    COOKIES = "Cookies"
    IS_DEVICE = "IsDevice"
    REMOTE_ADDR = "RemoteAddr"
    SOCKET_ADDR = "SocketAddr"

class MinimumTlsVersion(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """TLS protocol version that will be used for Https
    """

    NONE = "None"
    TLS10 = "TLS10"
    TLS12 = "TLS12"

class Operator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    REG_EX = "RegEx"

class OptimizationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies what scenario the customer wants this CDN endpoint to optimize, e.g. Download, Media
    services. With this information we can apply scenario driven optimization.
    """

    GENERAL_WEB_DELIVERY = "GeneralWebDelivery"
    GENERAL_MEDIA_STREAMING = "GeneralMediaStreaming"
    VIDEO_ON_DEMAND_MEDIA_STREAMING = "VideoOnDemandMediaStreaming"
    LARGE_FILE_DOWNLOAD = "LargeFileDownload"
    DYNAMIC_SITE_ACCELERATION = "DynamicSiteAcceleration"

class OriginGroupResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the origin group.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"

class OriginResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the origin.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"

class ParamIndicator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates the purpose of the parameter
    """

    EXPIRES = "Expires"
    KEY_ID = "KeyId"
    SIGNATURE = "Signature"

class PolicyEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """describes if the policy is in enabled state or disabled state
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class PolicyMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if it is in detection mode or prevention mode at policy level.
    """

    PREVENTION = "Prevention"
    DETECTION = "Detection"

class PolicyResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the policy.
    """

    CREATING = "Creating"
    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    DELETING = "Deleting"

class PostArgsOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"

class PrivateEndpointStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The approval status for the connection to the Private Link
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"

class ProbeProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol to use for health probe.
    """

    NOT_SET = "NotSet"
    HTTP = "Http"
    HTTPS = "Https"

class ProfileResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the profile.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"
    DISABLED = "Disabled"

class ProtocolType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the TLS extension protocol that is used for secure delivery.
    """

    SERVER_NAME_INDICATION = "ServerNameIndication"
    IP_BASED = "IPBased"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the WebApplicationFirewallPolicy.
    """

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class QueryStringBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Caching behavior for the requests
    """

    INCLUDE = "Include"
    INCLUDE_ALL = "IncludeAll"
    EXCLUDE = "Exclude"
    EXCLUDE_ALL = "ExcludeAll"

class QueryStringCachingBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines how CDN caches requests that include query strings. You can ignore any query strings
    when caching, bypass caching to prevent requests that contain query strings from being cached,
    or cache every request with a unique URL.
    """

    IGNORE_QUERY_STRING = "IgnoreQueryString"
    BYPASS_CACHING = "BypassCaching"
    USE_QUERY_STRING = "UseQueryString"
    NOT_SET = "NotSet"

class QueryStringOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"

class RedirectType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The redirect type the rule will use when redirecting traffic.
    """

    MOVED = "Moved"
    FOUND = "Found"
    TEMPORARY_REDIRECT = "TemporaryRedirect"
    PERMANENT_REDIRECT = "PermanentRedirect"

class RemoteAddressOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"

class RequestBodyOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"

class RequestHeaderOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"

class RequestMethodMatchConditionParametersMatchValuesItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    GET = "GET"
    HEAD = "HEAD"
    POST = "POST"
    PUT = "PUT"
    DELETE = "DELETE"
    OPTIONS = "OPTIONS"
    TRACE = "TRACE"

class RequestMethodOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class RequestSchemeMatchConditionParametersMatchValuesItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    HTTP = "HTTP"
    HTTPS = "HTTPS"

class RequestUriOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"

class ResponseBasedDetectedErrorTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of response errors for real user requests for which origin will be deemed unhealthy
    """

    NONE = "None"
    TCP_ERRORS_ONLY = "TcpErrorsOnly"
    TCP_AND_HTTP_ERRORS = "TcpAndHttpErrors"

class SkuName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Name of the pricing tier.
    """

    STANDARD_VERIZON = "Standard_Verizon"
    PREMIUM_VERIZON = "Premium_Verizon"
    CUSTOM_VERIZON = "Custom_Verizon"
    STANDARD_AKAMAI = "Standard_Akamai"
    STANDARD_CHINA_CDN = "Standard_ChinaCdn"
    STANDARD_MICROSOFT = "Standard_Microsoft"
    PREMIUM_CHINA_CDN = "Premium_ChinaCdn"

class Transform(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes what transforms are applied before matching
    """

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"

class TransformType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes what transforms were applied before matching.
    """

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"

class UpdateRule(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes the action that shall be taken when the certificate is updated in Key Vault.
    """

    NO_ACTION = "NoAction"

class UrlFileExtensionOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"

class UrlFileNameOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"

class UrlPathOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    WILDCARD = "Wildcard"
