# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class MetricNamespace(msrest.serialization.Model):
    """Metric namespace class specifies the metadata for a metric namespace.

    :param id: The ID of the metricNamespace.
    :type id: str
    :param type: The type of the namespace.
    :type type: str
    :param name: The name of the namespace.
    :type name: str
    :param properties: Properties which include the fully qualified namespace name.
    :type properties: ~$(python-base-namespace).v2017_12_01_preview.models.MetricNamespaceName
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MetricNamespaceName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricNamespace, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)
        self.properties = kwargs.get('properties', None)


class MetricNamespaceCollection(msrest.serialization.Model):
    """Represents collection of metric namespaces.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The values for the metric namespaces.
    :type value: list[~$(python-base-namespace).v2017_12_01_preview.models.MetricNamespace]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricNamespace]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricNamespaceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']


class MetricNamespaceName(msrest.serialization.Model):
    """The fully qualified metric namespace name.

    :param metric_namespace_name: The metric namespace name.
    :type metric_namespace_name: str
    """

    _attribute_map = {
        'metric_namespace_name': {'key': 'metricNamespaceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricNamespaceName, self).__init__(**kwargs)
        self.metric_namespace_name = kwargs.get('metric_namespace_name', None)
