/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.check;

import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cobertura.check.CoverageRate;
import net.sourceforge.cobertura.check.PackageCoverage;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.util.Header;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class Main {
    private static final Logger logger = Logger.getLogger((Class)(class$net$sourceforge$cobertura$check$Main == null ? (class$net$sourceforge$cobertura$check$Main = Main.class$("net.sourceforge.cobertura.check.Main")) : class$net$sourceforge$cobertura$check$Main));
    final Perl5Matcher pm = new Perl5Matcher();
    final Perl5Compiler pc = new Perl5Compiler();
    CoverageRate minimumCoverageRate;
    Map minimumCoverageRates = new HashMap();
    Map packageCoverageMap = new HashMap();
    static /* synthetic */ Class class$net$sourceforge$cobertura$check$Main;

    double inRangeAndDivideByOneHundred(String coverageRateAsPercentage) {
        return this.inRangeAndDivideByOneHundred(Integer.valueOf(coverageRateAsPercentage));
    }

    double inRangeAndDivideByOneHundred(int coverageRateAsPercentage) {
        if (coverageRateAsPercentage >= 0 && coverageRateAsPercentage <= 100) {
            return (double)coverageRateAsPercentage / 100.0;
        }
        throw new IllegalArgumentException("The value " + coverageRateAsPercentage + "% is invalid.  Percentages must be between 0 and 100.");
    }

    void setMinimumCoverageRate(String minimumCoverageRate) throws MalformedPatternException {
        StringTokenizer tokenizer = new StringTokenizer(minimumCoverageRate, ":");
        this.minimumCoverageRates.put(this.pc.compile(tokenizer.nextToken()), new CoverageRate(this.inRangeAndDivideByOneHundred(tokenizer.nextToken()), this.inRangeAndDivideByOneHundred(tokenizer.nextToken())));
    }

    CoverageRate findMinimumCoverageRate(String classname) {
        Iterator iter = this.minimumCoverageRates.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!this.pm.matches(classname, (Pattern)entry.getKey())) continue;
            return (CoverageRate)entry.getValue();
        }
        return this.minimumCoverageRate;
    }

    public Main(String[] args) throws MalformedPatternException {
        int exitStatus = 0;
        Header.print(System.out);
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        double branchCoverageRate = 0.0;
        double lineCoverageRate = 0.0;
        double packageBranchCoverageRate = 0.0;
        double packageLineCoverageRate = 0.0;
        double totalBranchCoverageRate = 0.0;
        double totalLineCoverageRate = 0.0;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--branch")) {
                branchCoverageRate = this.inRangeAndDivideByOneHundred(args[++i]);
            } else if (args[i].equals("--datafile")) {
                dataFile = new File(args[++i]);
            } else if (args[i].equals("--line")) {
                lineCoverageRate = this.inRangeAndDivideByOneHundred(args[++i]);
            } else if (args[i].equals("--regex")) {
                this.setMinimumCoverageRate(args[++i]);
            } else if (args[i].equals("--packagebranch")) {
                packageBranchCoverageRate = this.inRangeAndDivideByOneHundred(args[++i]);
            } else if (args[i].equals("--packageline")) {
                packageLineCoverageRate = this.inRangeAndDivideByOneHundred(args[++i]);
            } else if (args[i].equals("--totalbranch")) {
                totalBranchCoverageRate = this.inRangeAndDivideByOneHundred(args[++i]);
            } else if (args[i].equals("--totalline")) {
                totalLineCoverageRate = this.inRangeAndDivideByOneHundred(args[++i]);
            }
            ++i;
        }
        ProjectData projectData = CoverageDataFileHandler.loadCoverageData(dataFile);
        if (projectData == null) {
            System.err.println("Error: Unable to read from data file " + dataFile.getAbsolutePath());
            System.exit(1);
        }
        if (branchCoverageRate == 0.0 && lineCoverageRate == 0.0 && packageLineCoverageRate == 0.0 && packageBranchCoverageRate == 0.0 && totalLineCoverageRate == 0.0 && totalBranchCoverageRate == 0.0 && this.minimumCoverageRates.size() == 0) {
            branchCoverageRate = 0.5;
            lineCoverageRate = 0.5;
            packageBranchCoverageRate = 0.5;
            packageLineCoverageRate = 0.5;
            totalBranchCoverageRate = 0.5;
            totalLineCoverageRate = 0.5;
        }
        this.minimumCoverageRate = new CoverageRate(lineCoverageRate, branchCoverageRate);
        double totalLines = 0.0;
        double totalLinesCovered = 0.0;
        double totalBranches = 0.0;
        double totalBranchesCovered = 0.0;
        Iterator iter = projectData.getClasses().iterator();
        while (iter.hasNext()) {
            ClassData classData = (ClassData)iter.next();
            CoverageRate coverageRate = this.findMinimumCoverageRate(classData.getName());
            if (totalBranchCoverageRate > 0.0) {
                totalBranches += (double)classData.getNumberOfValidBranches();
                totalBranchesCovered += (double)classData.getNumberOfCoveredBranches();
            }
            if (totalLineCoverageRate > 0.0) {
                totalLines += (double)classData.getNumberOfValidLines();
                totalLinesCovered += (double)classData.getNumberOfCoveredLines();
            }
            PackageCoverage packageCoverage = this.getPackageCoverage(classData.getPackageName());
            if (packageBranchCoverageRate > 0.0) {
                packageCoverage.addBranchCount(classData.getNumberOfValidBranches());
                packageCoverage.addBranchCoverage(classData.getNumberOfCoveredBranches());
            }
            if (packageLineCoverageRate > 0.0) {
                packageCoverage.addLineCount(classData.getNumberOfValidLines());
                packageCoverage.addLineCoverage(classData.getNumberOfCoveredLines());
            }
            logger.debug((Object)("Class " + classData.getName() + ", line coverage rate: " + this.percentage(classData.getLineCoverageRate()) + "%, branch coverage rate: " + this.percentage(classData.getBranchCoverageRate()) + "%"));
            if (classData.getBranchCoverageRate() < coverageRate.getBranchCoverageRate()) {
                System.err.println(classData.getName() + " failed check. Branch coverage rate of " + this.percentage(classData.getBranchCoverageRate()) + "% is below " + this.percentage(coverageRate.getBranchCoverageRate()) + "%");
                exitStatus |= 2;
            }
            if (!(classData.getLineCoverageRate() < coverageRate.getLineCoverageRate())) continue;
            System.err.println(classData.getName() + " failed check. Line coverage rate of " + this.percentage(classData.getLineCoverageRate()) + "% is below " + this.percentage(coverageRate.getLineCoverageRate()) + "%");
            exitStatus |= 4;
        }
        exitStatus |= this.checkPackageCoverageLevels(packageBranchCoverageRate, packageLineCoverageRate);
        if (totalBranches > 0.0 && totalBranchCoverageRate > totalBranchesCovered / totalBranches) {
            System.err.println("Project failed check. Total branch coverage rate of " + this.percentage(totalBranchesCovered / totalBranches) + "% is below " + this.percentage(totalBranchCoverageRate) + "%");
            exitStatus |= 8;
        }
        if (totalLines > 0.0 && totalLineCoverageRate > totalLinesCovered / totalLines) {
            System.err.println("Project failed check. Total line coverage rate of " + this.percentage(totalLinesCovered / totalLines) + "% is below " + this.percentage(totalLineCoverageRate) + "%");
            exitStatus |= 0x10;
        }
        System.exit(exitStatus);
    }

    private PackageCoverage getPackageCoverage(String packageName) {
        PackageCoverage packageCoverage = (PackageCoverage)this.packageCoverageMap.get(packageName);
        if (packageCoverage == null) {
            packageCoverage = new PackageCoverage();
            this.packageCoverageMap.put(packageName, packageCoverage);
        }
        return packageCoverage;
    }

    private int checkPackageCoverageLevels(double packageBranchCoverageRate, double packageLineCoverageRate) {
        int exitStatus = 0;
        Iterator iter = this.packageCoverageMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String packageName = (String)entry.getKey();
            PackageCoverage packageCoverage = (PackageCoverage)entry.getValue();
            exitStatus |= this.checkPackageCoverage(packageBranchCoverageRate, packageLineCoverageRate, packageName, packageCoverage);
        }
        return exitStatus;
    }

    private int checkPackageCoverage(double packageBranchCoverageRate, double packageLineCoverageRate, String packageName, PackageCoverage packageCoverage) {
        int exitStatus = 0;
        double branchCoverage = packageCoverage.getBranchCoverage() / packageCoverage.getBranchCount();
        if (packageCoverage.getBranchCount() > 0.0 && packageBranchCoverageRate > branchCoverage) {
            System.err.println("Package " + packageName + " failed check. Package branch coverage rate of " + this.percentage(branchCoverage) + "% is below " + this.percentage(packageBranchCoverageRate) + "%");
            exitStatus |= 0x20;
        }
        double lineCoverage = packageCoverage.getLineCoverage() / packageCoverage.getLineCount();
        if (packageCoverage.getLineCount() > 0.0 && packageLineCoverageRate > lineCoverage) {
            System.err.println("Package " + packageName + " failed check. Package line coverage rate of " + this.percentage(lineCoverage) + "% is below " + this.percentage(packageLineCoverageRate) + "%");
            exitStatus |= 0x40;
        }
        return exitStatus;
    }

    private String percentage(double coverateRate) {
        BigDecimal decimal = new BigDecimal(coverateRate * 100.0);
        return decimal.setScale(1, 1).toString();
    }

    public static void main(String[] args) throws MalformedPatternException {
        new Main(args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

