/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model.parse;

import java.util.Stack;
import jd.xml.util.XmlSource;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xpath.model.NodeName;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xpath.model.XPathRootNode;
import jd.xml.xpath.model.build.ElementInfo;
import jd.xml.xpath.model.build.ModelBuilder;
import jd.xml.xpath.model.build.ModelLocator;
import jd.xml.xpath.model.parse.ParseTextBuffer;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;

public abstract class ParseHandler
implements ModelLocator {
    protected ElementInfo elementInfo_ = new ElementInfo();
    protected NodeNamePool nodeNamePool_;
    protected ParseTextBuffer text_;
    protected ModelBuilder modelBuilder_;
    protected Stack preserveSpaceStack_ = new Stack();
    protected boolean preserveWhitespace_;

    public abstract void setValidating(boolean var1);

    public abstract boolean isValidating();

    public abstract void setEntityResolver(EntityResolver var1);

    public abstract EntityResolver getEntityResolver();

    public abstract Object getParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XPathRootNode parse(XmlSource xmlSource, NodeNamePool nodeNamePool, ModelBuilder modelBuilder, int n, boolean bl) throws Exception {
        XPathRootNode xPathRootNode;
        try {
            this.text_ = new ParseTextBuffer();
            this.nodeNamePool_ = nodeNamePool;
            this.modelBuilder_ = modelBuilder;
            this.preserveWhitespace_ = false;
            modelBuilder.startBuild(xmlSource.getUri(), nodeNamePool, n, this, bl);
            this.parse(xmlSource);
            xPathRootNode = modelBuilder.endBuild();
            Object var8_7 = null;
            this.nodeNamePool_ = null;
            this.modelBuilder_ = null;
            this.text_ = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.nodeNamePool_ = null;
            this.modelBuilder_ = null;
            this.text_ = null;
            this.preserveSpaceStack_.removeAllElements();
            throw throwable;
        }
        this.preserveSpaceStack_.removeAllElements();
        return xPathRootNode;
    }

    protected abstract void parse(XmlSource var1) throws Exception;

    protected void pushPreserveWhitespace(boolean bl) {
        this.preserveSpaceStack_.push(this.preserveWhitespace_ ? Boolean.TRUE : Boolean.FALSE);
        this.preserveWhitespace_ = bl;
    }

    protected void popPreserveWhitespace() {
        this.preserveWhitespace_ = (Boolean)this.preserveSpaceStack_.pop();
    }

    protected NodeName getNodeName(String string, String string2, String string3) throws SAXParseException {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string3 == null) {
            if (string2 == null) {
                throw new IllegalArgumentException("SAX Parser error: reported qname and localName are null");
            }
            if (string == null) {
                string3 = string2;
            } else {
                String string4 = this.modelBuilder_.getNamespaceContext().getPrefix(string);
                if (string4 == null) {
                    throw new IllegalArgumentException("cannot construct namespace prefix");
                }
                string3 = string4.length() > 0 ? string4 + ':' + string2 : string2;
            }
        } else if (string2 == null) {
            throw new IllegalArgumentException("localName for element '" + string3 + "' not correctly parsed");
        }
        return this.nodeNamePool_.getName(string, string2, string3);
    }

    protected NodeName getNodeName(String string, boolean bl) throws SAXParseException {
        String string2;
        String string3;
        NamespaceContext namespaceContext = this.modelBuilder_.getNamespaceContext();
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(n + 1);
            String string4 = string.substring(0, n);
            string2 = NamespaceContext.getUri(namespaceContext, string4);
            if (string2 == null) {
                throw new IllegalArgumentException("no namespace declared for prefix '" + string4 + "'");
            }
        } else {
            string3 = string;
            string2 = bl ? NamespaceContext.getUri(namespaceContext, "") : null;
        }
        return this.getNodeName(string2, string3, string);
    }

    protected void flushTextNode() {
        if (this.text_.length() > 0) {
            if (!this.text_.isWhitespace || this.preserveWhitespace_) {
                this.modelBuilder_.addText(this.text_);
            }
            this.text_.setLength(0);
        }
        this.text_.isWhitespace = true;
    }
}

