/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.tool;

import alt.jiapi.file.Attribute;
import alt.jiapi.file.ClassFile;
import alt.jiapi.file.CodeAttribute;
import alt.jiapi.file.ConstantPool;
import alt.jiapi.file.Field;
import alt.jiapi.file.Interface;
import alt.jiapi.file.LineNumberTableAttribute;
import alt.jiapi.file.LocalVariableTableAttribute;
import alt.jiapi.file.Method;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.instruction.CPInstruction;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;

public class ClassDiff {
    private ClassFile f1;
    private ClassFile f2;

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: ClassDiff <file1.class> <file2.class>");
            System.exit(0);
        }
        ClassDiff cd = new ClassDiff(args[0], args[1]);
        cd.runDiff();
    }

    public ClassDiff(String file1, String file2) throws IOException {
        this.f1 = ClassFile.parse(file1);
        this.f2 = ClassFile.parse(file2);
    }

    public void runDiff() {
        this.diff("magic-number", this.f1.getMagicNumber(), this.f2.getMagicNumber());
        this.diff("major-version", this.f1.getMajorVersion(), this.f2.getMajorVersion());
        this.diff("minor-version", this.f1.getMinorVersion(), this.f2.getMinorVersion());
        this.diff("access-flags", this.f1.getAccessFlags(), this.f2.getAccessFlags());
        ConstantPool cp1 = this.f1.getConstantPool();
        ConstantPool cp2 = this.f2.getConstantPool();
        this.diffCPEntry("this_class", cp1.get(this.f1.getThisClassIndex()), cp2.get(this.f2.getThisClassIndex()));
        this.diffCPEntry("super_class", cp1.get(this.f1.getSuperClassIndex()), cp2.get(this.f2.getSuperClassIndex()));
        this.diffInterfaces("interface", this.f1.getInterfaces(), this.f2.getInterfaces());
        this.diffFields("field", this.f1.getFields(), this.f2.getFields());
        this.diffMethods("method", this.f1.getMethods(), this.f2.getMethods());
    }

    public void diff(String dName, int i1, int i2) {
        if (i1 != i2) {
            System.out.println("< " + dName + ": " + i1);
            System.out.println("> " + dName + ": " + i2);
        }
    }

    private void diffInstructions(Instruction i1, Instruction i2) {
        if (i1.getOpcode() != i2.getOpcode()) {
            System.out.println("< instruction: " + i1);
            System.out.println("> instruction: " + i2);
            return;
        }
        if (i1 instanceof CPInstruction) {
            CPInstruction cpIns1 = (CPInstruction)i1;
            CPInstruction cpIns2 = (CPInstruction)i2;
            this.diffCPEntry("instruction, constant-pool entry", cpIns1.getEntry(), cpIns2.getEntry());
        }
    }

    public void diffCPEntry(String name, ConstantPool.Entry e1, ConstantPool.Entry e2) {
        if (e1.getClass().getName() != e2.getClass().getName()) {
            System.out.println("< " + name + ": " + e1);
            System.out.println("> " + name + ": " + e2);
            return;
        }
        if (e1 instanceof ConstantPool.ClassInfo) {
            String cn2;
            ConstantPool.ClassInfo ci1 = (ConstantPool.ClassInfo)e1;
            ConstantPool.ClassInfo ci2 = (ConstantPool.ClassInfo)e2;
            String cn1 = ci1.getName();
            if (!cn1.equals(cn2 = ci2.getName())) {
                System.out.println("< " + name + ": " + cn1);
                System.out.println("> " + name + ": " + cn2);
                return;
            }
        } else if (e1 instanceof ConstantPool.FieldRefInfo) {
            ConstantPool.FieldRefInfo fri1 = (ConstantPool.FieldRefInfo)e1;
            ConstantPool.FieldRefInfo fri2 = (ConstantPool.FieldRefInfo)e2;
            if (!fri1.getFieldName().equals(fri2.getFieldName()) || !fri2.getDescriptor().equals(fri2.getDescriptor())) {
                System.out.println("< " + name + ": " + e1);
                System.out.println("> " + name + ": " + e2);
                return;
            }
        } else if (e1 instanceof ConstantPool.MethodRefInfo) {
            ConstantPool.MethodRefInfo mri1 = (ConstantPool.MethodRefInfo)e1;
            ConstantPool.MethodRefInfo mri2 = (ConstantPool.MethodRefInfo)e2;
            if (!mri1.getMethodName().equals(mri2.getMethodName()) || !mri2.getDescriptor().equals(mri2.getDescriptor())) {
                System.out.println("< " + name + ": " + e1);
                System.out.println("> " + name + ": " + e2);
                return;
            }
        } else if (e1 instanceof ConstantPool.StringInfo) {
            ConstantPool.StringInfo si1 = (ConstantPool.StringInfo)e1;
            ConstantPool.StringInfo si2 = (ConstantPool.StringInfo)e2;
            if (!si1.stringValue().equals(si2.stringValue())) {
                System.out.println("< " + name + ": " + si1.stringValue());
                System.out.println("> " + name + ": " + si2.stringValue());
                return;
            }
        } else {
            System.out.println("ERROR: comparison not defined: " + e1 + ", " + e2);
        }
    }

    private void diffInterfaces(String name, List il1, List il2) {
        Iterator i1 = il1.iterator();
        Iterator i2 = il2.iterator();
        Interface if1 = null;
        Interface if2 = null;
        while (i1.hasNext()) {
            if1 = (Interface)i1.next();
            String n1 = if1.getName();
            String n2 = null;
            if (i2.hasNext()) {
                if2 = (Interface)i2.next();
                n2 = if2.getName();
            }
            if (n2 != null) {
                if (n1.equals(n2)) continue;
                System.out.println("< " + name + ": " + n1);
                System.out.println("> " + name + ": " + n2);
                continue;
            }
            System.out.println("< only here, " + name + ": " + n1);
        }
        while (i2.hasNext()) {
            if2 = (Interface)i2.next();
            System.out.println("> only here, " + name + ": " + if2.getName());
        }
    }

    private void diffFields(String name, List il1, List il2) {
        Field f2;
        for (Field f1 : il1) {
            f2 = this.findField(f1.getName(), f1.getDescriptor(), il2);
            if (f2 != null) {
                if (f1.getAccessFlags() != f2.getAccessFlags()) {
                    System.out.println("< " + name + ": " + Modifier.toString(f1.getAccessFlags()) + " " + f1.getName() + " " + f1.getDescriptor());
                    System.out.println("> " + name + ": " + Modifier.toString(f2.getAccessFlags()) + " " + f2.getName() + " " + f2.getDescriptor());
                }
                this.diffAttributes("field", f1.getName(), f2.getName(), f1.getAttributes(), f2.getAttributes());
                continue;
            }
            System.out.println("< only here, " + name + ": " + Modifier.toString(f1.getAccessFlags()) + " " + f1.getName() + f1.getDescriptor());
        }
        for (Field f1 : il2) {
            f2 = this.findField(f1.getName(), f1.getDescriptor(), il1);
            if (f2 != null) continue;
            System.out.println("> only here, " + name + ": " + Modifier.toString(f1.getAccessFlags()) + " " + f1.getName() + f1.getDescriptor());
        }
    }

    private void diffMethods(String name, List il1, List il2) {
        Method m2;
        for (Method m1 : il1) {
            m2 = this.findMethod(m1.getName(), m1.getDescriptor(), il2);
            if (m2 != null) {
                if (m1.getAccessFlags() != m2.getAccessFlags()) {
                    System.out.println("< " + name + ": " + Modifier.toString(m1.getAccessFlags()) + " " + m1.getName() + m1.getDescriptor());
                    System.out.println("> " + name + ": " + Modifier.toString(m2.getAccessFlags()) + " " + m2.getName() + m2.getDescriptor());
                }
                this.diffAttributes("method", m1.getName(), m2.getName(), m1.getAttributes(), m2.getAttributes());
            } else {
                System.out.println("< only here, " + name + ": " + Modifier.toString(m1.getAccessFlags()) + " " + m1.getName() + m1.getDescriptor());
            }
            JiapiMethod jm1 = new JiapiMethod(m1);
            JiapiMethod jm2 = new JiapiMethod(m2);
            this.diffInstructions(jm1, jm2);
        }
        for (Method m1 : il2) {
            m2 = this.findMethod(m1.getName(), m1.getDescriptor(), il1);
            if (m2 != null) continue;
            System.out.println("> only here, " + name + ": " + Modifier.toString(m1.getAccessFlags()) + " " + m1.getName() + m1.getDescriptor());
        }
    }

    private void diffAttributes(String name, String n1, String n2, List al1, List al2) {
        Attribute a2;
        for (Attribute a1 : al1) {
            a2 = this.findAttribute(a1.getName(), al2);
            if (a2 != null) {
                if (a1 instanceof CodeAttribute) {
                    this.diffCodeAttributes((CodeAttribute)a1, (CodeAttribute)a2);
                    continue;
                }
                if (a1 instanceof LineNumberTableAttribute) {
                    this.diffLNTableAttributes((LineNumberTableAttribute)a1, (LineNumberTableAttribute)a2);
                    continue;
                }
                if (a1 instanceof LocalVariableTableAttribute) {
                    this.diffLVTableAttributes((LocalVariableTableAttribute)a1, (LocalVariableTableAttribute)a2);
                    continue;
                }
                System.out.println("diff: " + a1.getName() + " not implemented");
                continue;
            }
            System.out.println("< only here, " + name + "(" + n1 + ") attribute: '" + a1.getName() + "'");
            if (!(a1 instanceof LocalVariableTableAttribute)) continue;
            this.printLVTable((LocalVariableTableAttribute)a1);
        }
        for (Attribute a1 : al2) {
            a2 = this.findAttribute(a1.getName(), al1);
            if (a2 != null) continue;
            System.out.println("> only here, " + name + "(" + n2 + ") attribute: '" + a1.getName() + "'");
            if (!(a1 instanceof LocalVariableTableAttribute)) continue;
            this.printLVTable((LocalVariableTableAttribute)a1);
        }
    }

    private void diffInstructions(JiapiMethod jm1, JiapiMethod jm2) {
        InstructionList il1 = jm1.getInstructionList();
        InstructionList il2 = jm2.getInstructionList();
        this.diff("instruction-list size", il1.size(), il2.size());
        for (int i = 0; i < il1.size() && i < il2.size(); ++i) {
            this.diffInstructions(il1.get(i), il2.get(i));
        }
    }

    private void diffCodeAttributes(CodeAttribute a1, CodeAttribute a2) {
        this.diff("max-locals", a1.getMaxLocals(), a2.getMaxLocals());
        this.diff("max-stack", a1.getMaxStack(), a2.getMaxStack());
        this.diffAttributes("attribute", "c1", "c2", a1.getAttributes(), a2.getAttributes());
    }

    private void diffLNTableAttributes(LineNumberTableAttribute a1, LineNumberTableAttribute a2) {
    }

    private void diffLVTableAttributes(LocalVariableTableAttribute a1, LocalVariableTableAttribute a2) {
    }

    private Method findMethod(String name, String descriptor, List il) {
        for (Method m : il) {
            if (!name.equals(m.getName()) || !descriptor.equals(m.getDescriptor())) continue;
            return m;
        }
        return null;
    }

    private Field findField(String name, String descriptor, List il) {
        for (Field f : il) {
            if (!name.equals(f.getName()) || !descriptor.equals(f.getDescriptor())) continue;
            return f;
        }
        return null;
    }

    private Attribute findAttribute(String name, List il) {
        for (Attribute a : il) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    private void printLVTable(LocalVariableTableAttribute lvta) {
        List lvt = lvta.getLocalVariables();
        System.out.println(lvt.size() + " local variables");
        Iterator i = lvt.iterator();
        System.out.println("  start_pc length name descriptor index");
        while (i.hasNext()) {
            LocalVariableTableAttribute.LocalVariable lv = (LocalVariableTableAttribute.LocalVariable)i.next();
            System.out.println("  " + lv.getStartPc() + "  " + lv.getLength() + "  " + lv.getName() + " " + lv.getDescriptor() + "  " + lv.getIndex());
        }
    }
}

