/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.Runtime;
import alt.jiapi.file.Attribute;
import alt.jiapi.file.CodeAttribute;
import alt.jiapi.file.ExceptionsAttribute;
import alt.jiapi.file.LineNumberTableAttribute;
import alt.jiapi.file.LocalVariableTableAttribute;
import alt.jiapi.file.Method;
import alt.jiapi.reflect.BranchInstruction;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.LNTableEntry;
import alt.jiapi.reflect.Loader;
import alt.jiapi.reflect.LocalVariable;
import alt.jiapi.reflect.Signature;
import alt.jiapi.reflect.TryBlock;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;

public class JiapiMethod {
    private static Category log = Runtime.getLogCategory(JiapiMethod.class);
    private Method method;
    private Signature signature;
    private JiapiClass declaringClass;
    private InstructionList instructions;
    private TryBlock[] tryBlocks = null;
    private List lineNumberTable;
    private List exceptionTable;

    public JiapiMethod(Method m) {
        this.method = m;
        this.signature = new Signature(m.getDescriptor());
    }

    public String getName() {
        return this.method.getName();
    }

    public int getModifiers() {
        return this.method.getAccessFlags();
    }

    public String getReturnType() {
        return this.signature.getReturnType();
    }

    public Signature getSignature() {
        return this.signature;
    }

    public InstructionFactory getInstructionFactory() {
        return new InstructionFactory(this.method.getConstantPool());
    }

    public InstructionList getInstructionList() {
        CodeAttribute ca = null;
        if (this.instructions == null) {
            ca = (CodeAttribute)this.getAttribute("Code");
            if (ca == null) {
                return null;
            }
            byte[] byteCode = ca.getByteCode();
            this.instructions = new InstructionList(byteCode, this.method.getConstantPool());
            this.instructions.setDeclaringMethod(this);
            this.lineNumberTable = new LinkedList();
            LineNumberTableAttribute lnta = (LineNumberTableAttribute)ca.getAttribute("LineNumberTable");
            if (lnta != null) {
                List entries = lnta.getEntries();
                for (LineNumberTableAttribute.Entry entry : entries) {
                    Instruction ins = this.instructions.instructionAtOffset(entry.getStartPc());
                    this.lineNumberTable.add(new LNTableEntry(entry, ins));
                }
            }
            this.exceptionTable = new LinkedList();
            List eTable = ca.getExceptionTable();
            if (eTable != null) {
                for (CodeAttribute.ExceptionTableEntry entry : eTable) {
                    Instruction start = this.instructions.instructionAtOffset(entry.getStartPc());
                    Instruction end = this.instructions.instructionAtOffset(entry.getEndPc());
                    Instruction handler = this.instructions.instructionAtOffset(entry.getHandlerPc());
                    this.exceptionTable.add(new ETEntry(entry, start, end, handler));
                }
            }
        }
        return this.instructions;
    }

    TryBlock[] getTryBlocks() {
        return null;
    }

    void addTryBlock(InstructionList tryBlock, String exceptionName, Instruction handlerStart) {
    }

    void addTryBlock(TryBlock b) {
    }

    public JiapiClass getDeclaringClass() {
        return this.declaringClass;
    }

    void setDeclaringClass(JiapiClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public JiapiClass[] getParameterTypes() throws ClassNotFoundException {
        String[] paramNames = this.getParameterTypeNames();
        JiapiClass[] types = new JiapiClass[paramNames.length];
        Loader loader = this.getDeclaringClass().getLoader();
        int i = 0;
        try {
            for (i = 0; i < paramNames.length; ++i) {
                types[i] = loader.loadClass(paramNames[i]);
            }
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(paramNames[i]);
        }
        return types;
    }

    public String[] getParameterTypeNames() {
        return this.signature.getParameters();
    }

    public JiapiClass[] getExceptionTypes() throws ClassNotFoundException {
        String[] exceptionNames = this.getExceptionNames();
        JiapiClass[] types = new JiapiClass[exceptionNames.length];
        Loader loader = this.getDeclaringClass().getLoader();
        int i = 0;
        try {
            for (i = 0; i < exceptionNames.length; ++i) {
                types[i] = loader.loadClass(exceptionNames[i]);
            }
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(exceptionNames[i]);
        }
        return types;
    }

    public String[] getExceptionNames() {
        ExceptionsAttribute a = (ExceptionsAttribute)this.getAttribute("Exceptions");
        if (a == null) {
            return new String[0];
        }
        return a.getExceptionNames();
    }

    public LocalVariable addLocalVariable(String type, String name) {
        return null;
    }

    void copy(JiapiMethod source) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String ms = Modifier.toString(this.getModifiers());
        sb.append(ms);
        if (ms.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.getReturnType());
        sb.append(' ');
        sb.append(this.getName());
        sb.append('(');
        String[] params = this.getParameterTypeNames();
        for (int i = 0; i < params.length; ++i) {
            sb.append(params[i]);
            if (i >= params.length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        String[] eNames = this.getExceptionNames();
        if (eNames.length > 0) {
            sb.append(" throws ");
            for (int i = 0; i < eNames.length; ++i) {
                sb.append(eNames[i]);
                if (i >= eNames.length - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    private List getAttributes() {
        return this.method.getAttributes();
    }

    Method getMethod() {
        return this.method;
    }

    Attribute getAttribute(String name) {
        List l = this.method.getAttributes();
        for (Attribute a : l) {
            if (a == null || !a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    void update() {
        if (this.instructions != null) {
            this.instructions.updateOffsets();
            this.updateBranchOffsets();
            CodeAttribute ca = (CodeAttribute)this.getAttribute("Code");
            ca.setByteCode(this.instructions.getBytes());
            this.updateMaxLocals(ca, this.instructions);
            this.updateMaxStack(ca, this.instructions);
        }
        this.updateLineNumberTableOffsets();
        this.updateExceptionTableOffsets();
    }

    private short updateMaxLocals(CodeAttribute ca, InstructionList il) {
        short maxLocals = (short)this.getParameterTypeNames().length;
        LocalVariableTableAttribute lvta = (LocalVariableTableAttribute)this.getAttribute("LocalVariableTable");
        if (lvta != null) {
            maxLocals = (short)(maxLocals + lvta.getLocalVariables().size());
        }
        boolean maxLocalsInInstructions = false;
        block9: for (int i = 0; i < il.size(); ++i) {
            Instruction ins = il.get(i);
            switch (ins.getOpcode()) {
                case 26: 
                case 34: 
                case 42: 
                case 59: 
                case 67: 
                case 75: {
                    if (maxLocals >= 1) continue block9;
                    maxLocals = 1;
                    continue block9;
                }
                case 27: 
                case 30: 
                case 35: 
                case 38: 
                case 43: 
                case 60: 
                case 63: 
                case 68: 
                case 71: 
                case 76: {
                    if (maxLocals >= 2) continue block9;
                    maxLocals = 2;
                    continue block9;
                }
                case 28: 
                case 31: 
                case 36: 
                case 39: 
                case 44: 
                case 61: 
                case 64: 
                case 69: 
                case 72: 
                case 77: {
                    if (maxLocals >= 3) continue block9;
                    maxLocals = 3;
                    continue block9;
                }
                case 29: 
                case 32: 
                case 37: 
                case 40: 
                case 45: 
                case 62: 
                case 65: 
                case 70: 
                case 73: 
                case 78: {
                    if (maxLocals >= 4) continue block9;
                    maxLocals = 4;
                    continue block9;
                }
                case 33: 
                case 41: 
                case 66: 
                case 74: {
                    if (maxLocals >= 5) continue block9;
                    maxLocals = 5;
                    continue block9;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    byte[] bytes_l = ins.getBytes();
                    byte mloc_l = bytes_l[1];
                    if (maxLocals >= mloc_l + 1) continue block9;
                    maxLocals = (short)(mloc_l + 1);
                    continue block9;
                }
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: {
                    byte[] bytes = ins.getBytes();
                    short mloc = bytes[1];
                    if (maxLocals >= mloc) continue block9;
                    maxLocals = mloc;
                }
            }
        }
        maxLocals = (short)(maxLocals + 1);
        ca.setMaxLocals(maxLocals);
        return maxLocals;
    }

    private short updateMaxStack(CodeAttribute ca, InstructionList il) {
        short maxStack = 0;
        short su = 0;
        if (il != null) {
            for (int i = 0; i < il.size(); ++i) {
                Instruction ins = il.get(i);
                if ((su = (short)(su + ins.stackUsage())) > maxStack) {
                    maxStack = su;
                }
                if (ins.getOpcode() != -78 && ins.getOpcode() != -76) continue;
                maxStack = (short)(maxStack + 1);
            }
            ca.setMaxStack(maxStack);
        }
        return maxStack;
    }

    private void updateBranchOffsets() {
        for (int i = 0; i < this.instructions.size(); ++i) {
            Instruction ins = this.instructions.get(i);
            if (!(ins instanceof BranchInstruction)) continue;
            BranchInstruction bIns = (BranchInstruction)ins;
            if (this.instructions.indexOf(bIns.getTarget()) != -1) {
                short branchOffset = bIns.getOffset();
                short targetOffset = bIns.getTarget().getOffset();
                bIns.setTargetOffset(targetOffset - branchOffset);
                continue;
            }
            log.warn((Object)"Target instruction for branch was not found. This is most likely because branch-instruction was copied from some other instruction-list, and target was not copied. Branch offset is left as is.");
        }
    }

    private void updateLineNumberTableOffsets() {
        if (this.lineNumberTable != null) {
            for (LNTableEntry entry : this.lineNumberTable) {
                entry.update();
            }
        }
    }

    private void updateExceptionTableOffsets() {
        if (this.exceptionTable != null) {
            for (ETEntry entry : this.exceptionTable) {
                entry.update();
            }
        }
    }

    public int getMaxLocals() {
        CodeAttribute ca = (CodeAttribute)this.getAttribute("Code");
        if (ca == null) {
            throw new NullPointerException("No Code attribute found");
        }
        ca.setByteCode(this.getInstructionList().getBytes());
        return this.updateMaxLocals(ca, this.getInstructionList());
    }

    public int getMaxStack() {
        CodeAttribute ca = (CodeAttribute)this.getAttribute("Code");
        return this.updateMaxStack(ca, this.getInstructionList());
    }

    public boolean isSynthetic() {
        return this.method.getAttribute("Synthetic") != null;
    }

    private class ETEntry {
        private Instruction start;
        private Instruction end;
        private Instruction handler;
        private CodeAttribute.ExceptionTableEntry entry;

        ETEntry(CodeAttribute.ExceptionTableEntry entry, Instruction start, Instruction end, Instruction handler) {
            this.entry = entry;
            this.start = start;
            this.end = end;
            this.handler = handler;
        }

        void update() {
            this.entry.setStartPc(this.start.getOffset());
            this.entry.setEndPc(this.end.getOffset());
            this.entry.setHandlerPc(this.handler.getOffset());
        }

        Instruction getStart() {
            return this.start;
        }

        Instruction getEnd() {
            return this.end;
        }

        Instruction getHandler() {
            return this.handler;
        }
    }
}

