/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.File;
import java.util.Arrays;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.AbstractReferenceTypeDelegate;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;

public class SourceContextImpl
implements ISourceContext {
    private AbstractReferenceTypeDelegate delegate;
    private int[] lineBreaks;
    public static final ISourceContext UNKNOWN_SOURCE_CONTEXT = new ISourceContext(){

        public ISourceLocation makeSourceLocation(IHasPosition position) {
            return null;
        }

        public ISourceLocation makeSourceLocation(int line, int offset) {
            return null;
        }

        public int getOffset() {
            return 0;
        }

        public void tidy() {
        }
    };

    public SourceContextImpl(AbstractReferenceTypeDelegate delegate) {
        this.delegate = delegate;
    }

    public void configureFromAttribute(String name, int[] linebreaks) {
        this.delegate.setSourcefilename(name);
        this.lineBreaks = linebreaks;
    }

    private File getSourceFile() {
        return new File(this.delegate.getSourcefilename());
    }

    public void tidy() {
    }

    public int getOffset() {
        return 0;
    }

    public ISourceLocation makeSourceLocation(IHasPosition position) {
        if (this.lineBreaks != null) {
            int line = Arrays.binarySearch(this.lineBreaks, position.getStart());
            if (line < 0) {
                line = -line;
            }
            return new SourceLocation(this.getSourceFile(), line);
        }
        return new SourceLocation(this.getSourceFile(), 0);
    }

    public ISourceLocation makeSourceLocation(int line, int offset) {
        if (line < 0) {
            line = 0;
        }
        SourceLocation sl = new SourceLocation(this.getSourceFile(), line);
        if (offset > 0) {
            sl.setOffset(offset);
        } else if (this.lineBreaks != null) {
            int likelyOffset = 0;
            if (line > 0 && line < this.lineBreaks.length) {
                likelyOffset = this.lineBreaks[line - 1] + 1;
            }
            sl.setOffset(likelyOffset);
        }
        return sl;
    }
}

