/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.verifier.structurals;

import java.util.AbstractList;
import java.util.ArrayList;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.ReferenceType;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.verifier.exc.AssertionViolatedException;
import org.aspectj.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.aspectj.apache.bcel.verifier.structurals.UninitializedObjectType;

public class OperandStack {
    private ArrayList stack = new ArrayList();
    private int maxStack;

    public OperandStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public OperandStack(int maxStack, ObjectType obj) {
        this.maxStack = maxStack;
        this.push(obj);
    }

    protected Object clone() {
        OperandStack newstack = new OperandStack(this.maxStack);
        newstack.stack = (ArrayList)this.stack.clone();
        return newstack;
    }

    public void clear() {
        this.stack = new ArrayList();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OperandStack)) {
            return false;
        }
        OperandStack s = (OperandStack)o;
        return ((AbstractList)this.stack).equals(s.stack);
    }

    public OperandStack getClone() {
        return (OperandStack)this.clone();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int maxStack() {
        return this.maxStack;
    }

    public Type peek() {
        return this.peek(0);
    }

    public Type peek(int i) {
        return (Type)this.stack.get(this.size() - i - 1);
    }

    public Type pop() {
        Type e = (Type)this.stack.remove(this.size() - 1);
        return e;
    }

    public Type pop(int i) {
        int j = 0;
        while (j < i) {
            this.pop();
            ++j;
        }
        return null;
    }

    public void push(Type type) {
        if (type == null) {
            throw new AssertionViolatedException("Cannot push NULL onto OperandStack.");
        }
        if (type == Type.BOOLEAN || type == Type.CHAR || type == Type.BYTE || type == Type.SHORT) {
            throw new AssertionViolatedException("The OperandStack does not know about '" + type + "'; use Type.INT instead.");
        }
        if (this.slotsUsed() >= this.maxStack) {
            throw new AssertionViolatedException("OperandStack too small, should have thrown proper Exception elsewhere. Stack: " + this);
        }
        this.stack.add(type);
    }

    int size() {
        return this.stack.size();
    }

    public int slotsUsed() {
        int slots = 0;
        int i = 0;
        while (i < this.stack.size()) {
            slots += this.peek(i).getSize();
            ++i;
        }
        return slots;
    }

    public String toString() {
        String s = "Slots used: " + this.slotsUsed() + " MaxStack: " + this.maxStack + ".\n";
        int i = 0;
        while (i < this.size()) {
            s = String.valueOf(s) + this.peek(i) + " (Size: " + this.peek(i).getSize() + ")\n";
            ++i;
        }
        return s;
    }

    public void merge(OperandStack s) {
        if (this.slotsUsed() != s.slotsUsed() || this.size() != s.size()) {
            throw new StructuralCodeConstraintException("Cannot merge stacks of different size:\nOperandStack A:\n" + this + "\nOperandStack B:\n" + s);
        }
        int i = 0;
        while (i < this.size()) {
            if (!(this.stack.get(i) instanceof UninitializedObjectType) && s.stack.get(i) instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (!this.stack.get(i).equals(s.stack.get(i)) && this.stack.get(i) instanceof UninitializedObjectType && !(s.stack.get(i) instanceof UninitializedObjectType)) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (this.stack.get(i) instanceof UninitializedObjectType && !(s.stack.get(i) instanceof UninitializedObjectType)) {
                this.stack.set(i, ((UninitializedObjectType)this.stack.get(i)).getInitialized());
            }
            if (!this.stack.get(i).equals(s.stack.get(i))) {
                if (this.stack.get(i) instanceof ReferenceType && s.stack.get(i) instanceof ReferenceType) {
                    this.stack.set(i, ((ReferenceType)this.stack.get(i)).getFirstCommonSuperclass((ReferenceType)s.stack.get(i)));
                } else {
                    throw new StructuralCodeConstraintException("Cannot merge stacks of different types:\nStack A:\n" + this + "\nStack B:\n" + s);
                }
            }
            ++i;
        }
    }

    public void initializeObject(UninitializedObjectType u) {
        int i = 0;
        while (i < this.stack.size()) {
            if (this.stack.get(i) == u) {
                this.stack.set(i, u.getInitialized());
            }
            ++i;
        }
    }
}

