# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class ApplyUpdatesOperations(object):
    """ApplyUpdatesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.maintenance.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def get_parent(
        self,
        resource_group_name,  # type: str
        resource_parent_type,  # type: str
        resource_parent_name,  # type: str
        provider_name,  # type: str
        resource_type,  # type: str
        resource_name,  # type: str
        apply_update_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ApplyUpdate"
        """Track Updates to resource with parent.

        Track maintenance updates to resource with parent.

        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param resource_parent_type: Resource parent type.
        :type resource_parent_type: str
        :param resource_parent_name: Resource parent identifier.
        :type resource_parent_name: str
        :param provider_name: Resource provider name.
        :type provider_name: str
        :param resource_type: Resource type.
        :type resource_type: str
        :param resource_name: Resource identifier.
        :type resource_name: str
        :param apply_update_name: applyUpdate Id.
        :type apply_update_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplyUpdate, or the result of cls(response)
        :rtype: ~azure.mgmt.maintenance.models.ApplyUpdate
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ApplyUpdate"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-01-preview"
        accept = "application/json"

        # Construct URL
        url = self.get_parent.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'resourceParentType': self._serialize.url("resource_parent_type", resource_parent_type, 'str'),
            'resourceParentName': self._serialize.url("resource_parent_name", resource_parent_name, 'str'),
            'providerName': self._serialize.url("provider_name", provider_name, 'str'),
            'resourceType': self._serialize.url("resource_type", resource_type, 'str'),
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
            'applyUpdateName': self._serialize.url("apply_update_name", apply_update_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ApplyUpdate', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_parent.metadata = {'url': '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceParentType}/{resourceParentName}/{resourceType}/{resourceName}/providers/Microsoft.Maintenance/applyUpdates/{applyUpdateName}'}  # type: ignore

    def get(
        self,
        resource_group_name,  # type: str
        provider_name,  # type: str
        resource_type,  # type: str
        resource_name,  # type: str
        apply_update_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ApplyUpdate"
        """Track Updates to resource.

        Track maintenance updates to resource.

        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param provider_name: Resource provider name.
        :type provider_name: str
        :param resource_type: Resource type.
        :type resource_type: str
        :param resource_name: Resource identifier.
        :type resource_name: str
        :param apply_update_name: applyUpdate Id.
        :type apply_update_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplyUpdate, or the result of cls(response)
        :rtype: ~azure.mgmt.maintenance.models.ApplyUpdate
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ApplyUpdate"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-01-preview"
        accept = "application/json"

        # Construct URL
        url = self.get.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'providerName': self._serialize.url("provider_name", provider_name, 'str'),
            'resourceType': self._serialize.url("resource_type", resource_type, 'str'),
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
            'applyUpdateName': self._serialize.url("apply_update_name", apply_update_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ApplyUpdate', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get.metadata = {'url': '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}/providers/Microsoft.Maintenance/applyUpdates/{applyUpdateName}'}  # type: ignore

    def create_or_update_parent(
        self,
        resource_group_name,  # type: str
        provider_name,  # type: str
        resource_parent_type,  # type: str
        resource_parent_name,  # type: str
        resource_type,  # type: str
        resource_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ApplyUpdate"
        """Apply Updates to resource with parent.

        Apply maintenance updates to resource with parent.

        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param provider_name: Resource provider name.
        :type provider_name: str
        :param resource_parent_type: Resource parent type.
        :type resource_parent_type: str
        :param resource_parent_name: Resource parent identifier.
        :type resource_parent_name: str
        :param resource_type: Resource type.
        :type resource_type: str
        :param resource_name: Resource identifier.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplyUpdate, or the result of cls(response)
        :rtype: ~azure.mgmt.maintenance.models.ApplyUpdate
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ApplyUpdate"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-01-preview"
        accept = "application/json"

        # Construct URL
        url = self.create_or_update_parent.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'providerName': self._serialize.url("provider_name", provider_name, 'str'),
            'resourceParentType': self._serialize.url("resource_parent_type", resource_parent_type, 'str'),
            'resourceParentName': self._serialize.url("resource_parent_name", resource_parent_name, 'str'),
            'resourceType': self._serialize.url("resource_type", resource_type, 'str'),
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ApplyUpdate', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_or_update_parent.metadata = {'url': '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceParentType}/{resourceParentName}/{resourceType}/{resourceName}/providers/Microsoft.Maintenance/applyUpdates/default'}  # type: ignore

    def create_or_update(
        self,
        resource_group_name,  # type: str
        provider_name,  # type: str
        resource_type,  # type: str
        resource_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.ApplyUpdate"
        """Apply Updates to resource.

        Apply maintenance updates to resource.

        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param provider_name: Resource provider name.
        :type provider_name: str
        :param resource_type: Resource type.
        :type resource_type: str
        :param resource_name: Resource identifier.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplyUpdate, or the result of cls(response)
        :rtype: ~azure.mgmt.maintenance.models.ApplyUpdate
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.ApplyUpdate"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "2020-07-01-preview"
        accept = "application/json"

        # Construct URL
        url = self.create_or_update.metadata['url']  # type: ignore
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'providerName': self._serialize.url("provider_name", provider_name, 'str'),
            'resourceType': self._serialize.url("resource_type", resource_type, 'str'),
            'resourceName': self._serialize.url("resource_name", resource_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('ApplyUpdate', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_or_update.metadata = {'url': '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}/providers/Microsoft.Maintenance/applyUpdates/default'}  # type: ignore
