# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.communication.aio import CommunicationServiceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCommunicationServiceManagementCommunicationServicesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CommunicationServiceManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_check_name_availability(self, resource_group):
        response = await self.client.communication_services.check_name_availability(
            name_availability_parameters={"name": "str", "type": "str"},
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_link_notification_hub(self, resource_group):
        response = await self.client.communication_services.link_notification_hub(
            resource_group_name=resource_group.name,
            communication_service_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_list_by_subscription(self, resource_group):
        response = self.client.communication_services.list_by_subscription(
            api_version="2025-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_list_by_resource_group(self, resource_group):
        response = self.client.communication_services.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_update(self, resource_group):
        response = await self.client.communication_services.update(
            resource_group_name=resource_group.name,
            communication_service_name="str",
            parameters={
                "disableLocalAuth": bool,
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "linkedDomains": ["str"],
                "publicNetworkAccess": "str",
                "tags": {"str": "str"},
            },
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_get(self, resource_group):
        response = await self.client.communication_services.get(
            resource_group_name=resource_group.name,
            communication_service_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.communication_services.begin_create_or_update(
                resource_group_name=resource_group.name,
                communication_service_name="str",
                parameters={
                    "location": "str",
                    "dataLocation": "str",
                    "disableLocalAuth": bool,
                    "hostName": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "immutableResourceId": "str",
                    "linkedDomains": ["str"],
                    "name": "str",
                    "notificationHubId": "str",
                    "provisioningState": "str",
                    "publicNetworkAccess": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "version": "str",
                },
                api_version="2025-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_begin_delete(self, resource_group):
        response = await (
            await self.client.communication_services.begin_delete(
                resource_group_name=resource_group.name,
                communication_service_name="str",
                api_version="2025-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_list_keys(self, resource_group):
        response = await self.client.communication_services.list_keys(
            resource_group_name=resource_group.name,
            communication_service_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_communication_services_regenerate_key(self, resource_group):
        response = await self.client.communication_services.regenerate_key(
            resource_group_name=resource_group.name,
            communication_service_name="str",
            parameters={"keyType": "str"},
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...
